/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.sp;

import drasys.or.CompareNumberReverse;
import drasys.or.InvalidPriorityException;
import drasys.or.PairI;
import drasys.or.cont.PriorityQueue;
import drasys.or.cont.PriorityQueueI;
import drasys.or.graph.EdgeI;
import drasys.or.graph.EdgeValueI;
import drasys.or.graph.ElementI;
import drasys.or.graph.GraphError;
import drasys.or.graph.GraphI;
import drasys.or.graph.InvalidGraphError;
import drasys.or.graph.InvalidPropertyException;
import drasys.or.graph.PropertiesAdapter;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.sp.SingleVertexI;
import drasys.or.graph.sp.SingleVertexListenerI;
import java.util.Enumeration;
import java.util.Vector;

public class Dijkstra
implements SingleVertexI {
    private GraphI _graph;
    private PriorityQueueI _queue;
    private SingleVertexListenerI _listener;
    private PropertiesI _properties = new PropertiesAdapter();
    private int _label;
    private int _numVert;
    private int _pathCnt;
    private int _graphChangeCount;
    private Vertex _candHead;
    private Vertex _candTail;
    private Vertex[] _vertices;
    private int _maxLen;
    private int _maxPaths;
    private double _maxCost;
    private double _maxTime;
    private double _maxDist;
    private boolean _reverseEdges;
    private boolean _allEdgesAreDirected;

    public Dijkstra(GraphI graphI) {
        this._init();
        this._setGraph(graphI);
        this._queue = new PriorityQueue(new CompareNumberReverse());
    }

    public Dijkstra(GraphI graphI, PriorityQueueI priorityQueueI) {
        this._init();
        this._setGraph(graphI);
        this._queue = priorityQueueI;
        this._queue.setCompare(new CompareNumberReverse());
    }

    private int _generatePaths(Object object) throws VertexNotFoundException, InvalidPropertyException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("Can't find the origin vertex.");
        }
        if (this._listener != null) {
            this._listener.beginPathTree(vertexI, this._reverseEdges);
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        this._label += 2;
        this._candHead = null;
        vertex._len = 0;
        vertex._dist = 0.0;
        vertex._time = 0.0;
        vertex._cost = 0.0;
        vertex._prevEdge = null;
        vertex._prevVertex = null;
        this._queue.removeAllElements();
        vertex._queuePair = this._queue.insert(new Double(0.0), vertex);
        this._pathCnt = 0;
        while (this._queue.size() > 0 && this._pathCnt < this._maxPaths) {
            VertexI vertexI2;
            Vertex vertex2;
            EdgeI edgeI;
            Enumeration enumeration;
            Vertex vertex3 = (Vertex)this._queue.popHead().getSecond();
            vertex3.setPerm(this._label);
            if (vertex3._isCand && vertex3 != vertex) {
                vertex3._nextCand = null;
                if (this._candHead == null) {
                    this._candHead = vertex3;
                    this._candTail = vertex3;
                } else {
                    this._candTail._nextCand = vertex3;
                    this._candTail = vertex3;
                }
                ++this._pathCnt;
            }
            if (this._properties.isVertexRestricted(vertex3._vertex)) continue;
            if (!this._reverseEdges || !this._allEdgesAreDirected) {
                enumeration = vertex3._vertex.outEdges();
                while (enumeration.hasMoreElements()) {
                    edgeI = (EdgeI)enumeration.nextElement();
                    if (this._reverseEdges && edgeI.isDirected() || (vertex2 = this._vertices[(vertexI2 = edgeI.getToVertex()).getIndex()]).isPerm(this._label)) continue;
                    this._updateVertex(vertex3, edgeI, vertex2, this._reverseEdges);
                }
            }
            if (!this._reverseEdges && this._allEdgesAreDirected) continue;
            enumeration = vertex3._vertex.inEdges();
            while (enumeration.hasMoreElements()) {
                edgeI = (EdgeI)enumeration.nextElement();
                if (!this._reverseEdges && edgeI.isDirected() || (vertex2 = this._vertices[(vertexI2 = edgeI.getFromVertex()).getIndex()]).isPerm(this._label)) continue;
                this._updateVertex(vertex3, edgeI, vertex2, this._reverseEdges ^ true);
            }
        }
        if (this._listener != null) {
            this._listener.endPathTree(this._pathCnt);
        }
        return this._pathCnt;
    }

    private void _init() {
        this._label = 2;
        this._candTail = null;
        this._candHead = null;
        this._pathCnt = 0;
        this._listener = null;
        this._maxLen = Integer.MAX_VALUE;
        this._maxCost = Double.POSITIVE_INFINITY;
        this._maxTime = Double.POSITIVE_INFINITY;
        this._maxDist = Double.POSITIVE_INFINITY;
        this._maxPaths = Integer.MAX_VALUE;
    }

    private void _setGraph(GraphI graphI) {
        this._graph = graphI;
        this._graphChangeCount = graphI.getChangeCount();
        if (graphI == null) {
            return;
        }
        this._numVert = graphI.sizeOfVertices();
        this._vertices = new Vertex[this._numVert];
        Enumeration enumeration = graphI.vertices();
        while (enumeration.hasMoreElements()) {
            VertexI vertexI = (VertexI)enumeration.nextElement();
            this._vertices[vertexI.getIndex()] = new Vertex(vertexI);
        }
        this.setCandidate(false);
        boolean bl = this._allEdgesAreDirected = graphI.sizeOfDirectedEdges() == graphI.sizeOfEdges();
        if (this._listener != null) {
            this._listener.initialize(graphI, this);
        }
    }

    private final void _updateVertex(Vertex vertex, EdgeI edgeI, Vertex vertex2, boolean bl) {
        int n = vertex._len + 1;
        if (n > this._maxLen) {
            return;
        }
        double d = vertex._cost;
        d += this._properties.getVertexCost(vertex._vertex);
        d += this._properties.getEdgeCost(edgeI, bl);
        double d2 = vertex._time;
        d2 += this._properties.getVertexTime(vertex._vertex);
        d2 += this._properties.getEdgeTime(edgeI, bl);
        double d3 = vertex._dist;
        d3 += this._properties.getEdgeDistance(edgeI, bl);
        if (d > this._maxCost || d2 > this._maxTime || d3 > this._maxDist) {
            return;
        }
        if (this._properties.isEdgeRestricted(edgeI, bl)) {
            return;
        }
        if (!vertex2.isInQueue(this._label)) {
            vertex2._prevEdge = edgeI;
            vertex2._prevVertex = vertex;
            vertex2._len = n;
            vertex2._cost = d;
            vertex2._time = d2;
            vertex2._dist = d3;
            vertex2.setIsInQueue(this._label);
            vertex2._queuePair = this._queue.insert(new Double(d), vertex2);
            if (this._listener != null) {
                this._listener.updateVertexCost(vertex._vertex, edgeI, vertex2._vertex, vertex2);
            }
        } else if (vertex2._cost > d) {
            vertex2._prevEdge = edgeI;
            vertex2._prevVertex = vertex;
            vertex2._len = n;
            vertex2._cost = d;
            vertex2._time = d2;
            vertex2._dist = d3;
            try {
                this._queue.changePriority(vertex2._queuePair, new Double(d));
            }
            catch (InvalidPriorityException invalidPriorityException) {
                throw new GraphError("The priority queue does not support change priority.");
            }
            if (this._listener != null) {
                this._listener.updateVertexCost(vertex._vertex, edgeI, vertex2._vertex, vertex2);
            }
        }
    }

    public Enumeration candidates() {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        return new CandEnumeration(this._candHead);
    }

    public int generatePathsFrom(Object object) throws VertexNotFoundException, InvalidPropertyException {
        this._reverseEdges = false;
        return this._generatePaths(object);
    }

    public int generatePathsTo(Object object) throws VertexNotFoundException, InvalidPropertyException {
        this._reverseEdges = true;
        return this._generatePaths(object);
    }

    public EdgeValueI getEdgeValue(VertexI vertexI) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        if (vertexI.getGraph() != this._graph) {
            throw new GraphError("The vertex is not owned by the graph");
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        if (vertex._label < this._label) {
            return null;
        }
        return vertex;
    }

    public VertexI getNearestCandidate() {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        return this._candHead == null ? null : this._candHead._vertex;
    }

    public Vector getPath(VertexI vertexI) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        if (vertexI.getGraph() != this._graph) {
            throw new GraphError("The vertex is not owned by the graph");
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        if (vertex._label < this._label) {
            throw new VertexNotFoundException("The vertex is not in the solution.");
        }
        Vector<ElementI> vector = new Vector<ElementI>(vertex._len * 2 + 1);
        vector.addElement(vertex._vertex);
        while (vertex._prevVertex != null) {
            vector.addElement(vertex._prevEdge);
            vector.addElement(vertex._prevVertex._vertex);
            vertex = vertex._prevVertex;
        }
        if (!this._reverseEdges) {
            int n = 0;
            int n2 = vector.size() - 1;
            while (n2 > n) {
                Object e = vector.elementAt(n);
                vector.setElementAt((ElementI)vector.elementAt(n2), n);
                vector.setElementAt((ElementI)e, n2);
                ++n;
                --n2;
            }
        }
        return vector;
    }

    public Enumeration pathElements(VertexI vertexI) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        if (vertexI.getGraph() != this._graph) {
            throw new GraphError("The vertex is not owned by the graph");
        }
        Vertex vertex = this._vertices[vertexI.getIndex()];
        if (vertex._label < this._label) {
            throw new VertexNotFoundException("The vertex is not in the solution.");
        }
        return new PathEnumeration(vertex);
    }

    public void setCandidate(Object object, boolean bl) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException();
        }
        this._vertices[vertexI.getIndex()]._isCand = bl;
    }

    public void setCandidate(boolean bl) {
        if (this._graph == null) {
            throw new GraphError("The graph has not been set.");
        }
        if (this._graph.getChangeCount() != this._graphChangeCount) {
            throw new InvalidGraphError("The graph has changed since construction, create a new algorithm.");
        }
        int n = 0;
        while (n < this._numVert) {
            this._vertices[n]._isCand = bl;
            ++n;
        }
    }

    public void setListener(SingleVertexListenerI singleVertexListenerI) {
        this._listener = singleVertexListenerI;
    }

    public void setMaxCost(double d) {
        this._maxCost = d;
    }

    public void setMaxDistance(double d) {
        this._maxDist = d;
    }

    public void setMaxLength(int n) {
        this._maxLen = n;
    }

    public void setMaxPaths(int n) {
        this._maxPaths = n;
    }

    public void setMaxTime(double d) {
        this._maxTime = d;
    }

    public void setProperties(PropertiesI propertiesI) {
        this._properties = propertiesI;
    }

    public String toString() {
        if (this._graph == null) {
            return "Dijkstra: The graph is not set\n";
        }
        String string = "";
        string = String.valueOf(string) + "------------------------------------\n";
        string = String.valueOf(string) + "Dijkstra: " + this._graph.sizeOfVertices() + " vertices, " + this._graph.sizeOfEdges() + " edges\n";
        string = String.valueOf(string) + "------------------------------------\n";
        Enumeration enumeration = this._graph.vertices();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + this._vertices[((VertexI)enumeration.nextElement()).getIndex()] + "\n";
        }
        string = String.valueOf(string) + "\n";
        return string;
    }

    public boolean usesConnectionProperties() {
        return false;
    }

    private static class Vertex
    implements EdgeValueI {
        int _label = 0;
        PairI _queuePair;
        double _cost;
        double _time;
        double _dist;
        int _len;
        boolean _isCand = false;
        EdgeI _prevEdge;
        Vertex _prevVertex;
        Vertex _nextCand;
        VertexI _vertex;

        Vertex(VertexI vertexI) {
            this._vertex = vertexI;
        }

        public double getCost(boolean bl) {
            return this._cost;
        }

        public double getDistance(boolean bl) {
            return this._dist;
        }

        public double getTime(boolean bl) {
            return this._time;
        }

        boolean isInQueue(int n) {
            return this._label == n;
        }

        boolean isPerm(int n) {
            return this._label == n + 1;
        }

        void setIsInQueue(int n) {
            this._label = n;
        }

        void setPerm(int n) {
            this._label = n + 1;
        }

        public String toString() {
            return String.valueOf(this._vertex.toString()) + (this._isCand ? ", cand" : "");
        }
    }

    private static class CandEnumeration
    implements Enumeration {
        Vertex _vertex;

        CandEnumeration(Vertex vertex) {
            this._vertex = vertex;
        }

        public boolean hasMoreElements() {
            return this._vertex != null;
        }

        public Object nextElement() {
            if (this._vertex == null) {
                return null;
            }
            VertexI vertexI = this._vertex._vertex;
            this._vertex = this._vertex._nextCand;
            return vertexI;
        }
    }

    private static class PathEnumeration
    implements Enumeration {
        Vertex _vertex;
        boolean _didVertex;

        PathEnumeration(Vertex vertex) {
            this._vertex = vertex;
            this._didVertex = false;
        }

        public boolean hasMoreElements() {
            return this._vertex != null && (!this._didVertex || this._vertex._prevEdge != null);
        }

        public Object nextElement() {
            if (this._vertex == null) {
                return null;
            }
            if (!this._didVertex) {
                this._didVertex = true;
                return this._vertex._vertex;
            }
            this._didVertex = false;
            EdgeI edgeI = this._vertex._prevEdge;
            this._vertex = this._vertex._prevVertex;
            return edgeI;
        }
    }
}

