/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.sp;

import drasys.or.cont.OrderedSet;
import drasys.or.graph.AddI;
import drasys.or.graph.DuplicateEdgeException;
import drasys.or.graph.DuplicateVertexException;
import drasys.or.graph.EdgeValue;
import drasys.or.graph.EdgeValueI;
import drasys.or.graph.GraphI;
import drasys.or.graph.InvalidPropertyException;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.sp.AllPairsI;
import drasys.or.graph.sp.Dijkstra;
import drasys.or.graph.sp.SingleVertexI;
import drasys.or.matrix.SizableMatrixI;
import java.util.Enumeration;

public class Iterate
implements AllPairsI {
    GraphI _graph;
    OrderedSet _origins;
    OrderedSet _destinations;
    SingleVertexI _algorithm;

    public Iterate(GraphI graphI) {
        this._graph = graphI;
        this._algorithm = new Dijkstra(graphI);
        this._init();
    }

    public Iterate(GraphI graphI, SingleVertexI singleVertexI) {
        this._graph = graphI;
        this._algorithm = singleVertexI;
        this._init();
    }

    private void _init() {
        this._origins = new OrderedSet(this._graph.sizeOfVertices());
        this._destinations = new OrderedSet(this._graph.sizeOfVertices());
    }

    public AddI fillGraph(AddI addI) throws InvalidPropertyException, VertexNotFoundException, DuplicateEdgeException, DuplicateVertexException {
        return this.fillGraph(addI, Integer.MAX_VALUE, 0);
    }

    public AddI fillGraph(AddI addI, int n, int n2) throws InvalidPropertyException, VertexNotFoundException, DuplicateEdgeException, DuplicateVertexException {
        VertexI vertexI;
        Enumeration enumeration;
        Object e;
        Enumeration enumeration2;
        Object object;
        Object object2;
        Enumeration enumeration3 = this._origins.elements();
        while (enumeration3.hasMoreElements()) {
            object2 = enumeration3.nextElement();
            if (addI.getVertex(object2) != null) continue;
            addI.addVertex(this._graph.getVertex(object2));
        }
        object2 = this._destinations.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (addI.getVertex(object) != null) continue;
            addI.addVertex(this._graph.getVertex(object));
        }
        if (n > 0) {
            this._algorithm.setMaxPaths(n);
            this._algorithm.setCandidate(false);
            object = this._destinations.elements();
            while (object.hasMoreElements()) {
                this._algorithm.setCandidate(object.nextElement(), true);
            }
            enumeration2 = this._origins.elements();
            while (enumeration2.hasMoreElements()) {
                e = enumeration2.nextElement();
                this._algorithm.generatePathsFrom(e);
                enumeration = this._algorithm.candidates();
                while (enumeration.hasMoreElements()) {
                    vertexI = (VertexI)enumeration.nextElement();
                    addI.addEdge(e, vertexI.getKey(), new EdgeValue(this._algorithm.getEdgeValue(vertexI)));
                }
            }
        }
        if (n2 > 0) {
            this._algorithm.setMaxPaths(n2);
            this._algorithm.setCandidate(false);
            object = this._origins.elements();
            while (object.hasMoreElements()) {
                this._algorithm.setCandidate(object.nextElement(), true);
            }
            enumeration2 = this._destinations.elements();
            while (enumeration2.hasMoreElements()) {
                e = enumeration2.nextElement();
                this._algorithm.generatePathsTo(e);
                enumeration = this._algorithm.candidates();
                while (enumeration.hasMoreElements()) {
                    vertexI = (VertexI)enumeration.nextElement();
                    addI.addEdge(vertexI.getKey(), e, new EdgeValue(this._algorithm.getEdgeValue(vertexI)));
                }
            }
        }
        return addI;
    }

    public void fillMatrix(SizableMatrixI sizableMatrixI, SizableMatrixI sizableMatrixI2, SizableMatrixI sizableMatrixI3) throws InvalidPropertyException, VertexNotFoundException {
        this.fillMatrix(sizableMatrixI, sizableMatrixI2, sizableMatrixI3, Integer.MAX_VALUE, 0);
    }

    public void fillMatrix(SizableMatrixI sizableMatrixI, SizableMatrixI sizableMatrixI2, SizableMatrixI sizableMatrixI3, int n, int n2) throws InvalidPropertyException, VertexNotFoundException {
        VertexI vertexI;
        Enumeration enumeration;
        int n3;
        Object object;
        if (sizableMatrixI != null) {
            sizableMatrixI.setSize(this._origins.size(), this._destinations.size());
        }
        if (sizableMatrixI2 != null) {
            sizableMatrixI2.setSize(this._origins.size(), this._destinations.size());
        }
        if (sizableMatrixI3 != null) {
            sizableMatrixI3.setSize(this._origins.size(), this._destinations.size());
        }
        if (sizableMatrixI != null) {
            sizableMatrixI.setElements(Double.POSITIVE_INFINITY);
        }
        if (sizableMatrixI2 != null) {
            sizableMatrixI2.setElements(Double.POSITIVE_INFINITY);
        }
        if (sizableMatrixI3 != null) {
            sizableMatrixI3.setElements(Double.POSITIVE_INFINITY);
        }
        Enumeration enumeration2 = this._origins.elements();
        while (enumeration2.hasMoreElements()) {
            object = enumeration2.nextElement();
            int n4 = this._origins.getIndex(object);
            int n5 = this._destinations.getIndex(object);
            if (n4 < 0 || n5 < 0) continue;
            if (sizableMatrixI != null) {
                sizableMatrixI.setElementAt(n4, n5, 0.0);
            }
            if (sizableMatrixI2 != null) {
                sizableMatrixI2.setElementAt(n4, n5, 0.0);
            }
            if (sizableMatrixI3 == null) continue;
            sizableMatrixI3.setElementAt(n4, n5, 0.0);
        }
        if (n > 0) {
            this._algorithm.setMaxPaths(n);
            this._algorithm.setCandidate(false);
            object = this._destinations.elements();
            while (object.hasMoreElements()) {
                this._algorithm.setCandidate(object.nextElement(), true);
            }
            Enumeration enumeration3 = this._origins.elements();
            while (enumeration3.hasMoreElements()) {
                Object e = enumeration3.nextElement();
                n3 = this._origins.getIndex(e);
                this._algorithm.generatePathsFrom(e);
                enumeration = this._algorithm.candidates();
                while (enumeration.hasMoreElements()) {
                    vertexI = (VertexI)enumeration.nextElement();
                    int n6 = this._destinations.getIndex(vertexI.getKey());
                    EdgeValueI edgeValueI = this._algorithm.getEdgeValue(vertexI);
                    if (sizableMatrixI != null) {
                        sizableMatrixI.setElementAt(n3, n6, edgeValueI.getCost(false));
                    }
                    if (sizableMatrixI2 != null) {
                        sizableMatrixI2.setElementAt(n3, n6, edgeValueI.getTime(false));
                    }
                    if (sizableMatrixI3 == null) continue;
                    sizableMatrixI3.setElementAt(n3, n6, edgeValueI.getDistance(false));
                }
            }
        }
        if (n2 > 0) {
            this._algorithm.setMaxPaths(n2);
            this._algorithm.setCandidate(false);
            object = this._origins.elements();
            while (object.hasMoreElements()) {
                this._algorithm.setCandidate(object.nextElement(), true);
            }
            Enumeration enumeration4 = this._destinations.elements();
            while (enumeration4.hasMoreElements()) {
                Object e = enumeration4.nextElement();
                n3 = this._destinations.getIndex(e);
                this._algorithm.generatePathsTo(e);
                enumeration = this._algorithm.candidates();
                while (enumeration.hasMoreElements()) {
                    vertexI = (VertexI)enumeration.nextElement();
                    EdgeValueI edgeValueI = this._algorithm.getEdgeValue(vertexI);
                    int n7 = this._origins.getIndex(vertexI.getKey());
                    sizableMatrixI.setElementAt(n7, n3, edgeValueI.getCost(false));
                    if (sizableMatrixI2 != null) {
                        sizableMatrixI2.setElementAt(n7, n3, edgeValueI.getTime(false));
                    }
                    if (sizableMatrixI3 == null) continue;
                    sizableMatrixI3.setElementAt(n7, n3, edgeValueI.getDistance(false));
                }
            }
        }
    }

    public VertexI[] getDestinationVertices() {
        VertexI[] vertexIArray = new VertexI[this._destinations.size()];
        Enumeration enumeration = this._destinations.elements();
        Enumeration enumeration2 = this._destinations.indices();
        while (enumeration.hasMoreElements()) {
            vertexIArray[((Integer)enumeration2.nextElement()).intValue()] = this._graph.getVertex(enumeration.nextElement());
        }
        return vertexIArray;
    }

    public VertexI[] getOriginVertices() {
        VertexI[] vertexIArray = new VertexI[this._origins.size()];
        Enumeration enumeration = this._origins.elements();
        Enumeration enumeration2 = this._origins.indices();
        while (enumeration.hasMoreElements()) {
            vertexIArray[((Integer)enumeration2.nextElement()).intValue()] = this._graph.getVertex(enumeration.nextElement());
        }
        return vertexIArray;
    }

    public void setDestination(Object object, boolean bl) throws VertexNotFoundException {
        if (!bl) {
            this._destinations.removeElement(object);
        } else {
            VertexI vertexI = this._graph.getVertex(object);
            if (vertexI == null) {
                throw new VertexNotFoundException();
            }
            this._destinations.addElement(vertexI.getKey());
        }
    }

    public void setDestination(boolean bl) {
        if (!bl) {
            this._destinations.removeAllElements();
        } else if (this._destinations.size() != this._graph.sizeOfVertices()) {
            Enumeration enumeration = this._graph.vertices();
            while (enumeration.hasMoreElements()) {
                VertexI vertexI = (VertexI)enumeration.nextElement();
                this._destinations.addElement(vertexI.getKey());
            }
        }
    }

    public void setOrigin(Object object, boolean bl) throws VertexNotFoundException {
        if (!bl) {
            this._origins.removeElement(object);
        } else {
            VertexI vertexI = this._graph.getVertex(object);
            if (vertexI == null) {
                throw new VertexNotFoundException();
            }
            this._origins.addElement(vertexI.getKey());
        }
    }

    public void setOrigin(boolean bl) {
        if (!bl) {
            this._origins.removeAllElements();
        } else if (this._origins.size() != this._graph.sizeOfVertices()) {
            Enumeration enumeration = this._graph.vertices();
            while (enumeration.hasMoreElements()) {
                VertexI vertexI = (VertexI)enumeration.nextElement();
                this._origins.addElement(vertexI.getKey());
            }
        }
    }

    public void setProperties(PropertiesI propertiesI) {
        this._algorithm.setProperties(propertiesI);
    }
}

