/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.tsp;

import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ConstructI;
import drasys.or.graph.tsp.ImproveI;
import drasys.or.graph.tsp.TourNotFoundException;
import java.util.Vector;

public class Composite
implements ConstructI {
    ImproveI _improve;
    ConstructI _construct;

    public Composite(ConstructI constructI, ImproveI improveI) {
        this._improve = improveI;
        this._construct = constructI;
    }

    public Composite(ConstructI constructI, ImproveI improveI, GraphI graphI) {
        this._improve = improveI;
        this._construct = constructI;
        this.setGraph(graphI);
    }

    public double constructClosedTour() throws TourNotFoundException {
        double d = this._construct.constructClosedTour();
        if (this._improve != null) {
            Vector vector = this._construct.getTour();
            d = this._improve.improveClosedTour(vector);
        }
        return d;
    }

    public double constructOpenTour() throws TourNotFoundException {
        double d = this._construct.constructOpenTour();
        if (this._improve != null) {
            Vector vector = this._construct.getTour();
            d = this._improve.improveOpenTour(vector);
        }
        return d;
    }

    public double constructOpenTour(Object object, Object object2) throws TourNotFoundException, VertexNotFoundException {
        double d = this._construct.constructOpenTour(object, object2);
        if (this._improve != null) {
            Vector vector = this._construct.getTour();
            d = this._improve.improveOpenTour(vector, true, true);
        }
        return d;
    }

    public double constructOpenTourFrom(Object object) throws TourNotFoundException, VertexNotFoundException {
        double d = this._construct.constructOpenTourFrom(object);
        if (this._improve != null) {
            Vector vector = this._construct.getTour();
            d = this._improve.improveOpenTour(vector, true, false);
        }
        return d;
    }

    public double constructOpenTourTo(Object object) throws TourNotFoundException, VertexNotFoundException {
        double d = this._construct.constructOpenTourTo(object);
        if (this._improve != null) {
            Vector vector = this._construct.getTour();
            this._improve.improveOpenTour(vector, false, true);
        }
        return d;
    }

    public ConstructI getConstructAlgorithm() {
        return this._construct;
    }

    public double getCost() {
        return this._improve != null ? this._improve.getCost() : this._construct.getCost();
    }

    public ImproveI getImproveAlgorithm() {
        return this._improve;
    }

    public Vector getTour() {
        return this._improve != null ? this._improve.getTour() : this._construct.getTour();
    }

    public Vector rotateClosedTour(Vector vector, Object object) throws VertexNotFoundException {
        return this._construct.rotateClosedTour(vector, object);
    }

    public void selectVertex(Object object, boolean bl) throws VertexNotFoundException {
        this._construct.selectVertex(object, bl);
    }

    public void selectVertex(boolean bl) {
        this._construct.selectVertex(bl);
    }

    public void selectVertex(boolean[] blArray) {
        this._construct.selectVertex(blArray);
    }

    public void setEdgeKey(Object object) {
        if (this._improve != null) {
            this._improve.setEdgeKey(object);
        }
        this._construct.setEdgeKey(object);
    }

    public void setGraph(GraphI graphI) {
        if (this._improve != null) {
            this._improve.setGraph(graphI);
        }
        this._construct.setGraph(graphI);
    }

    public void setProperties(PropertiesI propertiesI) {
        if (this._improve != null) {
            this._improve.setProperties(propertiesI);
        }
        this._construct.setProperties(propertiesI);
    }
}

