/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.tsp;

import drasys.or.graph.EdgeI;
import drasys.or.graph.ElementI;
import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesAdapter;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.TSPError;
import java.util.Enumeration;
import java.util.Vector;

public abstract class TSPBase {
    int _size;
    int _changeCount;
    VertexI[] _vertices;
    int[] _bestTour;
    double _bestCost;
    GraphI _graph;
    boolean _closed;
    boolean _symmetric;
    boolean _allAreDirected;
    boolean[] _selected;
    int _fromSelectedIdx;
    int _toSelectedIdx;
    PropertiesI _properties = new PropertiesAdapter();
    Object _edgeKey;

    TSPBase() {
        this._graph = null;
        this._vertices = null;
        this._bestTour = null;
        this._edgeKey = null;
        this._selected = null;
    }

    TSPBase(GraphI graphI) {
        this._vertices = null;
        this._bestTour = null;
        this.setGraph(graphI);
        this._edgeKey = null;
    }

    protected void checkChangeCount() {
        if (this._graph.getChangeCount() != this._changeCount) {
            throw new TSPError("The graph has changed since it was set.");
        }
    }

    protected int countVertices() {
        this.checkChangeCount();
        int n = 0;
        int n2 = 0;
        while (n2 < this._selected.length) {
            if (this._selected[n2]) {
                ++n;
            }
            ++n2;
        }
        this._size = n;
        return this._size;
    }

    public final double forwardCost(int n, int n2) {
        if (n == n2 || n == -1 || n2 == -1) {
            return 0.0;
        }
        boolean bl = false;
        EdgeI edgeI = this._graph.getMutableEdge(this._vertices[n], this._vertices[n2], this._edgeKey);
        if (edgeI != null && this._properties.isEdgeRestricted(edgeI, bl)) {
            edgeI = null;
        }
        if (edgeI == null && !this._allAreDirected) {
            bl = true;
            edgeI = this._graph.getMutableEdge(this._vertices[n2], this._vertices[n], this._edgeKey);
            if (edgeI != null && edgeI.isDirected()) {
                edgeI = null;
            }
            if (edgeI != null && this._properties.isEdgeRestricted(edgeI, bl)) {
                edgeI = null;
            }
        }
        if (edgeI == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this._properties.getEdgeCost(edgeI, bl);
    }

    public double getCost() {
        if (this._bestTour == null) {
            throw new TSPError("No solution has been created");
        }
        return this._bestCost;
    }

    public Vector getTour() {
        this.checkChangeCount();
        if (this._bestTour == null) {
            throw new TSPError("No solution has been created");
        }
        if (this._bestTour.length != this._size) {
            throw new TSPError("Internal Error");
        }
        Vector<ElementI> vector = new Vector<ElementI>((this._bestTour.length + 1) * 2);
        VertexI vertexI = this._vertices[this._bestTour[0]];
        vector.addElement(vertexI);
        int n = 1;
        while (n < this._bestTour.length) {
            VertexI vertexI2 = this._vertices[this._bestTour[n]];
            vector.addElement(this._graph.getEdge(vertexI, vertexI2, this._edgeKey));
            vector.addElement(vertexI2);
            vertexI = vertexI2;
            ++n;
        }
        if (this._closed) {
            vector.addElement(this._graph.getEdge(vertexI, this._vertices[this._bestTour[0]], this._edgeKey));
            vector.addElement(this._vertices[this._bestTour[0]]);
        }
        return vector;
    }

    protected void initVertices(int n, int n2) {
        this.checkChangeCount();
        this._fromSelectedIdx = -1;
        this._toSelectedIdx = -1;
        int n3 = 0;
        Enumeration enumeration = this._graph.vertices();
        while (enumeration.hasMoreElements()) {
            VertexI vertexI = (VertexI)enumeration.nextElement();
            int n4 = vertexI.getIndex();
            if (n4 == n) {
                this._fromSelectedIdx = n3;
                this._vertices[n3++] = vertexI;
                continue;
            }
            if (n4 == n2) {
                this._toSelectedIdx = n3;
                this._vertices[n3++] = vertexI;
                continue;
            }
            if (!this._selected[n4]) continue;
            this._vertices[n3++] = vertexI;
        }
        this._size = n3;
    }

    protected void initVertices(Vector vector) {
        this.checkChangeCount();
        boolean[] blArray = new boolean[this._graph.sizeOfVertices()];
        int n = 0;
        int n2 = vector.firstElement() == vector.lastElement() ? vector.size() - 2 : vector.size();
        int n3 = 0;
        while (n3 < n2) {
            VertexI vertexI = (VertexI)vector.elementAt(n3);
            this._vertices[n++] = vertexI;
            if (blArray[vertexI.getIndex()]) {
                throw new TSPError("The tour has duplicate vertices");
            }
            blArray[vertexI.getIndex()] = true;
            n3 += 2;
        }
        this._size = n;
    }

    public final double reverseCost(int n, int n2) {
        return this.forwardCost(n2, n);
    }

    public Vector rotateClosedTour(Vector vector, Object object) throws VertexNotFoundException {
        if (vector.firstElement() != vector.lastElement()) {
            throw new TSPError("The tour is not closed");
        }
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (((VertexI)vector.elementAt(n2)).getKey().equals(object)) {
                n = n2;
                break;
            }
            n2 += 2;
        }
        if (n == -1) {
            throw new VertexNotFoundException();
        }
        Vector vector2 = new Vector(vector.size());
        int n3 = n;
        while (n3 < vector.size() - 1) {
            vector2.addElement(vector.elementAt(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 <= n) {
            vector2.addElement(vector.elementAt(n4));
            ++n4;
        }
        return vector2;
    }

    public void setEdgeKey(Object object) {
        this._edgeKey = object;
    }

    public void setGraph(GraphI graphI) {
        this._graph = graphI;
        if (this._graph == null) {
            return;
        }
        this._changeCount = graphI.getChangeCount();
        this._allAreDirected = this._graph.sizeOfEdges() == this._graph.sizeOfDirectedEdges();
        this._symmetric = true;
        if (!this._graph.isSymmetric()) {
            this._symmetric = false;
        }
        if (!this._properties.isSymmetric()) {
            this._symmetric = false;
        }
        int n = this._graph.sizeOfVertices();
        this._vertices = new VertexI[n];
        this._selected = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this._selected[n2] = true;
            ++n2;
        }
    }

    public void setProperties(PropertiesI propertiesI) {
        this._properties = propertiesI;
    }
}

