/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.blas;

import drasys.or.ComplexI;
import drasys.or.linear.blas.BLAS2;
import drasys.or.linear.blas.BLAS2I;
import drasys.or.linear.blas.BlasException;
import drasys.or.util.Smp;

public class SmpBLAS2
implements BLAS2I {
    Smp _smp = new Smp(100);
    BLAS2I _blas2 = null;
    BlasException _exception = null;

    public SmpBLAS2() {
        this._blas2 = new BLAS2();
    }

    public SmpBLAS2(BLAS2I bLAS2I) {
        this._blas2 = bLAS2I;
    }

    public void cgemv(int n, int n2, ComplexI complexI, float[] fArray, int n3, int n4, int n5, float[] fArray2, int n6, int n7, ComplexI complexI2, float[] fArray3, int n8, int n9) throws BlasException {
        int[] nArray = this._smp.balanceTasks(n, n2);
        if (nArray.length < 2) {
            this._blas2.cgemv(n, n2, complexI, fArray, n3, n4, n5, fArray2, n6, n7, complexI2, fArray3, n8, n9);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n10 = 0;
        int n11 = nArray[0];
        while (n10 < nArray.length) {
            n11 = nArray[n10];
            runnableArray[n10] = new CgemvJob(n11, n2, complexI, fArray, n3, n4, n5, fArray2, n6, n7, complexI2, fArray3, n8, n9);
            n3 += n11 * n4;
            n8 += n11 * n9;
            ++n10;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void cgerc(int n, int n2, ComplexI complexI, float[] fArray, int n3, int n4, float[] fArray2, int n5, int n6, float[] fArray3, int n7, int n8, int n9) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n9 < n8) {
            nArray = this._smp.balanceTasks(n, n2);
            if (nArray.length < 2) {
                this._blas2.cgerc(n, n2, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n10 = 0;
            int n11 = nArray[0];
            while (n10 < nArray.length) {
                n11 = nArray[n10];
                runnableArray[n10] = new CgercJob(n11, n2, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                n7 += n11 * n8;
                n5 += n11 * n6;
                ++n10;
            }
        } else {
            nArray = this._smp.balanceTasks(n2, n);
            if (nArray.length < 2) {
                this._blas2.cgerc(n, n2, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n12 = 0;
            int n13 = nArray[0];
            while (n12 < nArray.length) {
                n13 = nArray[n12];
                runnableArray[n12] = new CgercJob(n, n13, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                n7 += n13 * n9;
                n3 += n13 * n4;
                ++n12;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void cgeru(int n, int n2, ComplexI complexI, float[] fArray, int n3, int n4, float[] fArray2, int n5, int n6, float[] fArray3, int n7, int n8, int n9) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n9 < n8) {
            nArray = this._smp.balanceTasks(n, n2);
            if (nArray.length < 2) {
                this._blas2.cgeru(n, n2, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n10 = 0;
            int n11 = nArray[0];
            while (n10 < nArray.length) {
                n11 = nArray[n10];
                runnableArray[n10] = new CgeruJob(n11, n2, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                n7 += n11 * n8;
                n5 += n11 * n6;
                ++n10;
            }
        } else {
            nArray = this._smp.balanceTasks(n2, n);
            if (nArray.length < 2) {
                this._blas2.cgeru(n, n2, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n12 = 0;
            int n13 = nArray[0];
            while (n12 < nArray.length) {
                n13 = nArray[n12];
                runnableArray[n12] = new CgeruJob(n, n13, complexI, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                n7 += n13 * n9;
                n3 += n13 * n4;
                ++n12;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void dgemv(int n, int n2, double d, double[] dArray, int n3, int n4, int n5, double[] dArray2, int n6, int n7, double d2, double[] dArray3, int n8, int n9) throws BlasException {
        int[] nArray = this._smp.balanceTasks(n, n2);
        if (nArray.length < 2) {
            this._blas2.dgemv(n, n2, d, dArray, n3, n4, n5, dArray2, n6, n7, d2, dArray3, n8, n9);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n10 = 0;
        int n11 = nArray[0];
        while (n10 < nArray.length) {
            n11 = nArray[n10];
            runnableArray[n10] = new DgemvJob(n11, n2, d, dArray, n3, n4, n5, dArray2, n6, n7, d2, dArray3, n8, n9);
            n3 += n11 * n4;
            n8 += n11 * n9;
            ++n10;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void dger(int n, int n2, double d, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, int n7, int n8, int n9) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n9 < n8) {
            nArray = this._smp.balanceTasks(n, n2);
            if (nArray.length < 2) {
                this._blas2.dger(n, n2, d, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n10 = 0;
            int n11 = nArray[0];
            while (n10 < nArray.length) {
                n11 = nArray[n10];
                runnableArray[n10] = new DgerJob(n11, n2, d, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                n7 += n11 * n8;
                n5 += n11 * n6;
                ++n10;
            }
        } else {
            nArray = this._smp.balanceTasks(n2, n);
            if (nArray.length < 2) {
                this._blas2.dger(n, n2, d, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n12 = 0;
            int n13 = nArray[0];
            while (n12 < nArray.length) {
                n13 = nArray[n12];
                runnableArray[n12] = new DgerJob(n, n13, d, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                n7 += n13 * n9;
                n3 += n13 * n4;
                ++n12;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public Smp getSmp() {
        return this._smp;
    }

    public void setSmp(Smp smp) {
        this._smp = smp;
    }

    public void sgemv(int n, int n2, float f, float[] fArray, int n3, int n4, int n5, float[] fArray2, int n6, int n7, float f2, float[] fArray3, int n8, int n9) throws BlasException {
        int[] nArray = this._smp.balanceTasks(n, n2);
        if (nArray.length < 2) {
            this._blas2.sgemv(n, n2, f, fArray, n3, n4, n5, fArray2, n6, n7, f2, fArray3, n8, n9);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n10 = 0;
        int n11 = nArray[0];
        while (n10 < nArray.length) {
            n11 = nArray[n10];
            runnableArray[n10] = new SgemvJob(n11, n2, f, fArray, n3, n4, n5, fArray2, n6, n7, f2, fArray3, n8, n9);
            n3 += n11 * n4;
            n8 += n11 * n9;
            ++n10;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void sger(int n, int n2, float f, float[] fArray, int n3, int n4, float[] fArray2, int n5, int n6, float[] fArray3, int n7, int n8, int n9) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n9 < n8) {
            nArray = this._smp.balanceTasks(n, n2);
            if (nArray.length < 2) {
                this._blas2.sger(n, n2, f, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n10 = 0;
            int n11 = nArray[0];
            while (n10 < nArray.length) {
                n11 = nArray[n10];
                runnableArray[n10] = new SgerJob(n11, n2, f, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                n7 += n11 * n8;
                n5 += n11 * n6;
                ++n10;
            }
        } else {
            nArray = this._smp.balanceTasks(n2, n);
            if (nArray.length < 2) {
                this._blas2.sger(n, n2, f, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n12 = 0;
            int n13 = nArray[0];
            while (n12 < nArray.length) {
                n13 = nArray[n12];
                runnableArray[n12] = new SgerJob(n, n13, f, fArray, n3, n4, fArray2, n5, n6, fArray3, n7, n8, n9);
                n7 += n13 * n9;
                n3 += n13 * n4;
                ++n12;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zgemv(int n, int n2, ComplexI complexI, double[] dArray, int n3, int n4, int n5, double[] dArray2, int n6, int n7, ComplexI complexI2, double[] dArray3, int n8, int n9) throws BlasException {
        int[] nArray = this._smp.balanceTasks(n, n2);
        if (nArray.length < 2) {
            this._blas2.zgemv(n, n2, complexI, dArray, n3, n4, n5, dArray2, n6, n7, complexI2, dArray3, n8, n9);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n10 = 0;
        int n11 = nArray[0];
        while (n10 < nArray.length) {
            n11 = nArray[n10];
            runnableArray[n10] = new ZgemvJob(n11, n2, complexI, dArray, n3, n4, n5, dArray2, n6, n7, complexI2, dArray3, n8, n9);
            n3 += n11 * n4;
            n8 += n11 * n9;
            ++n10;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zgerc(int n, int n2, ComplexI complexI, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, int n7, int n8, int n9) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n9 < n8) {
            nArray = this._smp.balanceTasks(n, n2);
            if (nArray.length < 2) {
                this._blas2.zgerc(n, n2, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n10 = 0;
            int n11 = nArray[0];
            while (n10 < nArray.length) {
                n11 = nArray[n10];
                runnableArray[n10] = new ZgercJob(n11, n2, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                n7 += n11 * n8;
                n5 += n11 * n6;
                ++n10;
            }
        } else {
            nArray = this._smp.balanceTasks(n2, n);
            if (nArray.length < 2) {
                this._blas2.zgerc(n, n2, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n12 = 0;
            int n13 = nArray[0];
            while (n12 < nArray.length) {
                n13 = nArray[n12];
                runnableArray[n12] = new ZgercJob(n, n13, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                n7 += n13 * n9;
                n3 += n13 * n4;
                ++n12;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zgeru(int n, int n2, ComplexI complexI, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, int n7, int n8, int n9) throws BlasException {
        Runnable[] runnableArray;
        int[] nArray;
        if (n9 < n8) {
            nArray = this._smp.balanceTasks(n, n2);
            if (nArray.length < 2) {
                this._blas2.zgeru(n, n2, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n10 = 0;
            int n11 = nArray[0];
            while (n10 < nArray.length) {
                n11 = nArray[n10];
                runnableArray[n10] = new ZgeruJob(n11, n2, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                n7 += n11 * n8;
                n5 += n11 * n6;
                ++n10;
            }
        } else {
            nArray = this._smp.balanceTasks(n2, n);
            if (nArray.length < 2) {
                this._blas2.zgeru(n, n2, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                return;
            }
            runnableArray = new Runnable[nArray.length];
            int n12 = 0;
            int n13 = nArray[0];
            while (n12 < nArray.length) {
                n13 = nArray[n12];
                runnableArray[n12] = new ZgeruJob(n, n13, complexI, dArray, n3, n4, dArray2, n5, n6, dArray3, n7, n8, n9);
                n7 += n13 * n9;
                n3 += n13 * n4;
                ++n12;
            }
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    private class DgemvJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double _alpha;
        double _beta;
        double[] _A;
        double[] _x;
        double[] _y;

        DgemvJob(int n, int n2, double d, double[] dArray, int n3, int n4, int n5, double[] dArray2, int n6, int n7, double d2, double[] dArray3, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = d;
            this._beta = d2;
            this._A = dArray;
            this._begA = n3;
            this._incAi = n4;
            this._incAj = n5;
            this._x = dArray2;
            this._begx = n6;
            this._incx = n7;
            this._y = dArray3;
            this._begy = n8;
            this._incy = n9;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.dgemv(this._m, this._n, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._x, this._begx, this._incx, this._beta, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class DgerJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double _alpha;
        double[] _A;
        double[] _x;
        double[] _y;

        DgerJob(int n, int n2, double d, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, int n7, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = d;
            this._A = dArray3;
            this._begA = n7;
            this._incAi = n8;
            this._incAj = n9;
            this._x = dArray;
            this._begx = n3;
            this._incx = n4;
            this._y = dArray2;
            this._begy = n5;
            this._incy = n6;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.dger(this._m, this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._A, this._begA, this._incAi, this._incAj);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class SgemvJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float _alpha;
        float _beta;
        float[] _A;
        float[] _x;
        float[] _y;

        SgemvJob(int n, int n2, float f, float[] fArray, int n3, int n4, int n5, float[] fArray2, int n6, int n7, float f2, float[] fArray3, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = f;
            this._beta = f2;
            this._A = fArray;
            this._begA = n3;
            this._incAi = n4;
            this._incAj = n5;
            this._x = fArray2;
            this._begx = n6;
            this._incx = n7;
            this._y = fArray3;
            this._begy = n8;
            this._incy = n9;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.sgemv(this._m, this._n, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._x, this._begx, this._incx, this._beta, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class SgerJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float _alpha;
        float[] _A;
        float[] _x;
        float[] _y;

        SgerJob(int n, int n2, float f, float[] fArray, int n3, int n4, float[] fArray2, int n5, int n6, float[] fArray3, int n7, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = f;
            this._A = fArray3;
            this._begA = n7;
            this._incAi = n8;
            this._incAj = n9;
            this._x = fArray;
            this._begx = n3;
            this._incx = n4;
            this._y = fArray2;
            this._begy = n5;
            this._incy = n6;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.sger(this._m, this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._A, this._begA, this._incAi, this._incAj);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class ZgemvJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        ComplexI _beta;
        double[] _A;
        double[] _x;
        double[] _y;

        ZgemvJob(int n, int n2, ComplexI complexI, double[] dArray, int n3, int n4, int n5, double[] dArray2, int n6, int n7, ComplexI complexI2, double[] dArray3, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = complexI;
            this._beta = complexI2;
            this._A = dArray;
            this._begA = n3;
            this._incAi = n4;
            this._incAj = n5;
            this._x = dArray2;
            this._begx = n6;
            this._incx = n7;
            this._y = dArray3;
            this._begy = n8;
            this._incy = n9;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.zgemv(this._m, this._n, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._x, this._begx, this._incx, this._beta, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class ZgercJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        double[] _A;
        double[] _x;
        double[] _y;

        ZgercJob(int n, int n2, ComplexI complexI, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, int n7, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = complexI;
            this._A = dArray3;
            this._begA = n7;
            this._incAi = n8;
            this._incAj = n9;
            this._x = dArray;
            this._begx = n3;
            this._incx = n4;
            this._y = dArray2;
            this._begy = n5;
            this._incy = n6;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.zgerc(this._m, this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._A, this._begA, this._incAi, this._incAj);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class ZgeruJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        double[] _A;
        double[] _x;
        double[] _y;

        ZgeruJob(int n, int n2, ComplexI complexI, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, int n7, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = complexI;
            this._A = dArray3;
            this._begA = n7;
            this._incAi = n8;
            this._incAj = n9;
            this._x = dArray;
            this._begx = n3;
            this._incx = n4;
            this._y = dArray2;
            this._begy = n5;
            this._incy = n6;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.zgeru(this._m, this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._A, this._begA, this._incAi, this._incAj);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class CgemvJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        ComplexI _beta;
        float[] _A;
        float[] _x;
        float[] _y;

        CgemvJob(int n, int n2, ComplexI complexI, float[] fArray, int n3, int n4, int n5, float[] fArray2, int n6, int n7, ComplexI complexI2, float[] fArray3, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = complexI;
            this._beta = complexI2;
            this._A = fArray;
            this._begA = n3;
            this._incAi = n4;
            this._incAj = n5;
            this._x = fArray2;
            this._begx = n6;
            this._incx = n7;
            this._y = fArray3;
            this._begy = n8;
            this._incy = n9;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.cgemv(this._m, this._n, this._alpha, this._A, this._begA, this._incAi, this._incAj, this._x, this._begx, this._incx, this._beta, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class CgercJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        float[] _A;
        float[] _x;
        float[] _y;

        CgercJob(int n, int n2, ComplexI complexI, float[] fArray, int n3, int n4, float[] fArray2, int n5, int n6, float[] fArray3, int n7, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = complexI;
            this._A = fArray3;
            this._begA = n7;
            this._incAi = n8;
            this._incAj = n9;
            this._x = fArray;
            this._begx = n3;
            this._incx = n4;
            this._y = fArray2;
            this._begy = n5;
            this._incy = n6;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.cgerc(this._m, this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._A, this._begA, this._incAi, this._incAj);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }

    private class CgeruJob
    implements Runnable {
        int _m;
        int _n;
        int _begA;
        int _incAi;
        int _incAj;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        float[] _A;
        float[] _x;
        float[] _y;

        CgeruJob(int n, int n2, ComplexI complexI, float[] fArray, int n3, int n4, float[] fArray2, int n5, int n6, float[] fArray3, int n7, int n8, int n9) {
            this._m = n;
            this._n = n2;
            this._alpha = complexI;
            this._A = fArray3;
            this._begA = n7;
            this._incAi = n8;
            this._incAj = n9;
            this._x = fArray;
            this._begx = n3;
            this._incx = n4;
            this._y = fArray2;
            this._begy = n5;
            this._incy = n6;
        }

        public void run() {
            try {
                SmpBLAS2.this._blas2.cgeru(this._m, this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._A, this._begA, this._incAi, this._incAj);
            }
            catch (BlasException blasException) {
                SmpBLAS2.this._exception = blasException;
            }
        }
    }
}

