/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.ContiguousMatrixI;
import drasys.or.matrix.ContiguousVector;
import drasys.or.matrix.ContiguousVectorI;
import drasys.or.matrix.Matrix;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.SizableMatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public abstract class ContiguousMatrix
extends Matrix
implements ContiguousMatrixI,
SizableMatrixI {
    int _sizeOfRows = 0;
    int _sizeOfColumns = 0;
    int _capacityOfRows = 0;
    int _capacityOfColumns = 0;
    double[] _values = null;

    public ContiguousMatrix(int n, int n2, int n3, int n4) {
        this._sizeOfRows = n;
        this._sizeOfColumns = n2;
        this._capacityOfRows = Math.max(n, n3);
        this._capacityOfColumns = Math.max(n2, n4);
        this._values = Array.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
    }

    public ContiguousMatrix(MatrixI matrixI) {
        this._capacityOfRows = this._sizeOfRows = matrixI.sizeOfRows();
        this._capacityOfColumns = this._sizeOfColumns = matrixI.sizeOfColumns();
        this._values = Array.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
    }

    public ContiguousMatrix(VectorI vectorI) {
        this._capacityOfRows = this._sizeOfRows = vectorI.size();
        this._capacityOfColumns = this._sizeOfColumns = vectorI.size();
        this._values = Array.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(vectorElementI.getIndex(), vectorElementI.getIndex(), vectorElementI.getValue());
        }
    }

    public ContiguousMatrix(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            double[] dArray2 = dArray[n2];
            if (dArray2 != null && dArray2.length > n) {
                n = dArray2.length;
            }
            ++n2;
        }
        this._capacityOfRows = this._sizeOfRows = dArray.length;
        this._capacityOfColumns = this._sizeOfColumns = n;
        this._values = Array.resize(this._capacityOfRows * this._capacityOfColumns, this._values);
    }

    public abstract void addColumn(VectorI var1);

    public abstract void addRow(VectorI var1);

    public int capacityOfColumns() {
        return this._capacityOfColumns;
    }

    public int capacityOfRows() {
        return this._capacityOfRows;
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return this.submatrix(0, this.sizeOfRows(), n, n + 1).elements();
    }

    public ContiguousVectorI columnVector(int n) {
        return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, n), this.getRowIncrement());
    }

    public ContiguousVectorI diagonalVector() {
        return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, 0), this.getRowIncrement() + this.getColumnIncrement());
    }

    public Enumeration elements() {
        return new Enum(this._values, this.sizeOfRows(), this.sizeOfColumns(), 0, this.getRowIncrement(), this.getColumnIncrement());
    }

    public abstract int getColumnIncrement();

    public abstract int getOffset(int var1, int var2);

    public abstract int getRowIncrement();

    public double[] getValueArray() {
        return this._values;
    }

    public boolean isNull(int n, int n2) {
        return false;
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        return this.submatrix(n, n + 1, 0, this.sizeOfColumns()).elements();
    }

    public ContiguousVectorI rowVector(int n) {
        return new ContiguousVector.Sub(this._values, this.sizeOfColumns(), this.getOffset(n, 0), this.getColumnIncrement());
    }

    public abstract void setCapacity(int var1, int var2);

    public void setElements(double d) {
        Array.copy(this._values.length, this._values, 0, 1, d);
    }

    public abstract void setSize(int var1, int var2);

    public int sizeOfColumns() {
        return this._sizeOfColumns;
    }

    public int sizeOfElements() {
        return this._sizeOfRows * this._sizeOfColumns;
    }

    public int sizeOfRows() {
        return this._sizeOfRows;
    }

    public ContiguousMatrixI submatrix(int n, int n2) {
        return new Sub(this._values, this.sizeOfRows() - n, this.sizeOfColumns() - n2, this.getOffset(n, n2), this.getRowIncrement(), this.getColumnIncrement());
    }

    public ContiguousMatrixI submatrix(int n, int n2, int n3, int n4) {
        return new Sub(this._values, n2 - n, n4 - n3, this.getOffset(n, n3), this.getRowIncrement(), this.getColumnIncrement());
    }

    public double sum(int n, int n2, int n3, int n4) {
        int n5 = this.getOffset(n, n3);
        double d = 0.0;
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 < 1 || n7 < 1) {
            return d;
        }
        int n8 = this.getRowIncrement();
        int n9 = this.getColumnIncrement();
        if (n9 < n8) {
            int n10 = 0;
            while (n10 < n6) {
                d += Array.sum(n7, this._values, n5, n9);
                ++n10;
                n5 += n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n7) {
                d += Array.sum(n6, this._values, n5, n8);
                ++n11;
                n5 += n9;
            }
        }
        return d;
    }

    public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
        int n5 = this.getOffset(n, n3);
        double d2 = 0.0;
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 < 1 || n7 < 1) {
            return d2;
        }
        int n8 = this.getRowIncrement();
        int n9 = this.getColumnIncrement();
        if (n9 < n8) {
            int n10 = 0;
            while (n10 < n6) {
                d2 += Array.sumOfSquaredDifferences(n7, this._values, n5, n9, d);
                ++n10;
                n5 += n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n7) {
                d2 += Array.sumOfSquaredDifferences(n6, this._values, n5, n8, d);
                ++n11;
                n5 += n9;
            }
        }
        return d2;
    }

    public double sumOfSquares(int n, int n2, int n3, int n4) {
        int n5 = this.getOffset(n, n3);
        double d = 0.0;
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 < 1 || n7 < 1) {
            return d;
        }
        int n8 = this.getRowIncrement();
        int n9 = this.getColumnIncrement();
        if (n9 < n8) {
            int n10 = 0;
            while (n10 < n6) {
                d += Array.sumOfSquares(n7, this._values, n5, n9);
                ++n10;
                n5 += n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n7) {
                d += Array.sumOfSquares(n6, this._values, n5, n8);
                ++n11;
                n5 += n9;
            }
        }
        return d;
    }

    static class Enum
    implements Enumeration,
    MatrixElementI {
        int _k;
        int _m;
        int _n;
        int _inci;
        int _incj;
        int _beg;
        int _i = 0;
        int _j = 0;
        boolean _rowMajor = false;
        double[] _values;
        int _mrow;
        int _mcol;
        int _mcoef;
        double _mvalue;

        public Enum(double[] dArray, int n, int n2, int n3, int n4, int n5) {
            this._k = this._beg = n3;
            this._values = dArray;
            if (n5 < n4) {
                this._rowMajor = true;
                this._m = n;
                this._n = n2;
                this._inci = n4;
                this._incj = n5;
            } else {
                this._m = n2;
                this._n = n;
                this._inci = n5;
                this._incj = n4;
            }
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._i < this._m;
        }

        public Object nextElement() {
            if (this._i >= this._m) {
                return null;
            }
            if (this._rowMajor) {
                this._mrow = this._i;
                this._mcol = this._j;
            } else {
                this._mrow = this._j;
                this._mcol = this._i;
            }
            this._mcoef = this._k;
            this._mvalue = this._values[this._mcoef];
            if (++this._j == this._n) {
                this._j = 0;
                ++this._i;
                this._k = this._beg + this._i * this._inci;
            } else {
                this._k += this._incj;
            }
            return this;
        }

        public void setValue(double d) {
            this._values[this._mcoef] = this._mvalue = d;
        }
    }

    public static class Sub
    extends Matrix
    implements ContiguousMatrixI {
        int _m;
        int _n;
        int _beg;
        int _inci;
        int _incj;
        double[] _values;

        public Sub(double[] dArray, int n, int n2, int n3, int n4, int n5) {
            this._values = dArray;
            this._m = n;
            this._n = n2;
            this._beg = n3;
            this._inci = n4;
            this._incj = n5;
        }

        public Enumeration columnElements(int n) {
            if (n < 0 || n >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._n);
            }
            return this.submatrix(0, this.sizeOfRows(), n, n + 1).elements();
        }

        public ContiguousVectorI columnVector(int n) {
            return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, n), this.getRowIncrement());
        }

        public ContiguousVectorI diagonalVector() {
            return new ContiguousVector.Sub(this._values, this.sizeOfRows(), this.getOffset(0, 0), this.getRowIncrement() + this.getColumnIncrement());
        }

        public double elementAt(int n, int n2) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            if (n2 < 0 || n2 >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._n);
            }
            return this._values[this.getOffset(n, n2)];
        }

        public Enumeration elements() {
            return new Enum(this._values, this.sizeOfRows(), this.sizeOfColumns(), this._beg, this.getRowIncrement(), this.getColumnIncrement());
        }

        public double[][] getArray() {
            double[][] dArray = new double[this._m][this._n];
            int n = 0;
            while (n < dArray.length) {
                double[] dArray2 = dArray[n];
                if (dArray2 != null) {
                    Array.copy(dArray2.length, dArray2, 0, 1, this._values, this.getOffset(n, 0), this._inci);
                }
                ++n;
            }
            return dArray;
        }

        public int getColumnIncrement() {
            return this._incj;
        }

        public int getOffset(int n, int n2) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            if (n2 < 0 || n2 >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._n);
            }
            return this._beg + n * this._inci + n2 * this._incj;
        }

        public int getRowIncrement() {
            return this._inci;
        }

        public double[] getValueArray() {
            return this._values;
        }

        public boolean isColumnMajor() {
            return this._inci < this._incj;
        }

        public boolean isNull(int n, int n2) {
            return false;
        }

        public boolean isRowMajor() {
            return this._incj < this._inci;
        }

        public Enumeration rowElements(int n) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            return this.submatrix(n, n + 1, 0, this._n).elements();
        }

        public ContiguousVectorI rowVector(int n) {
            return new ContiguousVector.Sub(this._values, this.sizeOfColumns(), this.getOffset(n, 0), this.getColumnIncrement());
        }

        public void setElementAt(int n, int n2, double d) {
            if (n < 0 || n >= this._m) {
                throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._m);
            }
            if (n2 < 0 || n2 >= this._n) {
                throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._n);
            }
            this._values[this.getOffset((int)n, (int)n2)] = d;
        }

        public void setElements(double d) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this._beg;
            if (this._inci < this._incj) {
                n4 = this._m;
                n3 = this._inci;
                n2 = this._incj;
                n = this._beg + this._n * this._incj;
            } else {
                n4 = this._n;
                n3 = this._incj;
                n2 = this._inci;
                n = this._beg + this._m * this._inci;
            }
            while (n5 < n) {
                Array.copy(n4, this._values, n5, n3, d);
                n5 += n2;
            }
        }

        public int sizeOfColumns() {
            return this._n;
        }

        public int sizeOfElements() {
            return this._m * this._n;
        }

        public int sizeOfRows() {
            return this._m;
        }

        public ContiguousMatrixI submatrix(int n, int n2) {
            return new Sub(this._values, this.sizeOfRows() - n, this.sizeOfColumns() - n2, this.getOffset(n, n2), this.getRowIncrement(), this.getColumnIncrement());
        }

        public ContiguousMatrixI submatrix(int n, int n2, int n3, int n4) {
            return new Sub(this._values, n2 - n, n4 - n3, this.getOffset(n, n3), this.getRowIncrement(), this.getColumnIncrement());
        }

        public double sum(int n, int n2, int n3, int n4) {
            int n5 = this.getOffset(n, n3);
            double d = 0.0;
            int n6 = n2 - n;
            int n7 = n4 - n3;
            if (n6 < 1 || n7 < 1) {
                return d;
            }
            if (this._incj < this._inci) {
                int n8 = 0;
                while (n8 < n6) {
                    d += Array.sum(n7, this._values, n5, this._incj);
                    ++n8;
                    n5 += this._inci;
                }
            } else {
                int n9 = 0;
                while (n9 < n7) {
                    d += Array.sum(n6, this._values, n5, this._inci);
                    ++n9;
                    n5 += this._incj;
                }
            }
            return d;
        }

        public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
            int n5 = this.getOffset(n, n3);
            double d2 = 0.0;
            int n6 = n2 - n;
            int n7 = n4 - n3;
            if (n6 < 1 || n7 < 1) {
                return d2;
            }
            if (this._incj < this._inci) {
                int n8 = 0;
                while (n8 < n6) {
                    d2 += Array.sum(n7, this._values, n5, this._incj);
                    ++n8;
                    n5 += this._inci;
                }
            } else {
                int n9 = 0;
                while (n9 < n7) {
                    d2 += Array.sumOfSquaredDifferences(n6, this._values, n5, this._inci, d);
                    ++n9;
                    n5 += this._incj;
                }
            }
            return d2;
        }

        public double sumOfSquares(int n, int n2, int n3, int n4) {
            int n5 = this.getOffset(n, n3);
            double d = 0.0;
            int n6 = n2 - n;
            int n7 = n4 - n3;
            if (n6 < 1 || n7 < 1) {
                return d;
            }
            if (this._incj < this._inci) {
                int n8 = 0;
                while (n8 < n6) {
                    d += Array.sum(n7, this._values, n5, this._incj);
                    ++n8;
                    n5 += this._inci;
                }
            } else {
                int n9 = 0;
                while (n9 < n7) {
                    d += Array.sumOfSquares(n6, this._values, n5, this._inci);
                    ++n9;
                    n5 += this._incj;
                }
            }
            return d;
        }
    }
}

