/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.RealContainer;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import java.io.Serializable;
import java.util.Enumeration;

public abstract class Matrix
extends RealContainer
implements MatrixI,
Serializable {
    public Matrix() {
    }

    public Matrix(double d) {
        super(d);
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this.sizeOfColumns()) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this.sizeOfColumns());
        }
        return new _ColumnEnum(n);
    }

    public abstract double elementAt(int var1, int var2);

    public Enumeration elements() {
        return new _Enum();
    }

    public boolean equals(MatrixI matrixI) {
        if (this.sizeOfRows() != matrixI.sizeOfRows()) {
            return false;
        }
        if (this.sizeOfColumns() != matrixI.sizeOfColumns()) {
            return false;
        }
        if (this.sizeOfElements() == this.sizeOfRows() * this.sizeOfColumns()) {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                if (this.equals(matrixI.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex()), matrixElementI.getValue())) continue;
                return false;
            }
        } else if (matrixI.sizeOfElements() == matrixI.sizeOfRows() * matrixI.sizeOfColumns()) {
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                if (this.equals(this.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex()), matrixElementI.getValue())) continue;
                return false;
            }
        } else {
            Object object;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                object = (MatrixElementI)enumeration.nextElement();
                if (this.equals(matrixI.elementAt(object.getRowIndex(), object.getColumnIndex()), object.getValue())) continue;
                return false;
            }
            object = matrixI.elements();
            while (object.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)object.nextElement();
                if (this.equals(this.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex()), matrixElementI.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof MatrixI) {
            return this.equals((MatrixI)object);
        }
        return false;
    }

    public double[][] getArray() {
        int n = this.sizeOfRows();
        int n2 = this.sizeOfColumns();
        double[][] dArray = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4] = this.elementAt(n3, n4);
                ++n4;
            }
            ++n3;
        }
        return dArray;
    }

    public abstract boolean isColumnMajor();

    public abstract boolean isNull(int var1, int var2);

    public abstract boolean isRowMajor();

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this.sizeOfRows()) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this.sizeOfRows());
        }
        return new _RowEnum(n);
    }

    public void setColumn(int n, VectorI vectorI) {
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(vectorElementI.getIndex(), n, vectorElementI.getValue());
        }
    }

    public void setDiagonal(VectorI vectorI) {
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n = vectorElementI.getIndex();
            this.setElementAt(n, n, vectorElementI.getValue());
        }
    }

    public abstract void setElementAt(int var1, int var2, double var3);

    public abstract void setElements(double var1);

    public void setElements(MatrixI matrixI) {
        Enumeration enumeration = matrixI.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            this.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), matrixElementI.getValue());
        }
    }

    public void setRow(int n, VectorI vectorI) {
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(n, vectorElementI.getIndex(), vectorElementI.getValue());
        }
    }

    public abstract int sizeOfColumns();

    public abstract int sizeOfElements();

    public abstract int sizeOfRows();

    public double sum() {
        return this.sum(0, this.sizeOfRows(), 0, this.sizeOfColumns());
    }

    public double sum(int n) {
        return this.sum(n, this.sizeOfRows(), n, this.sizeOfColumns());
    }

    public double sum(int n, int n2, int n3, int n4) {
        double d = 0.0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n3;
            while (n6 < n4) {
                d += this.elementAt(n5, n6);
                ++n6;
            }
            ++n5;
        }
        return d;
    }

    public double sumOfSquaredDifferences(double d) {
        return this.sumOfSquaredDifferences(0, this.sizeOfRows(), 0, this.sizeOfColumns(), d);
    }

    public double sumOfSquaredDifferences(int n, double d) {
        return this.sumOfSquaredDifferences(n, this.sizeOfRows(), n, this.sizeOfColumns(), d);
    }

    public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
        double d2 = 0.0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n3;
            while (n6 < n4) {
                double d3 = d - this.elementAt(n5, n6);
                d2 += d3 * d3;
                ++n6;
            }
            ++n5;
        }
        return d2;
    }

    public double sumOfSquares() {
        return this.sumOfSquares(0, this.sizeOfRows(), 0, this.sizeOfColumns());
    }

    public double sumOfSquares(int n) {
        return this.sumOfSquares(n, this.sizeOfRows(), n, this.sizeOfColumns());
    }

    public double sumOfSquares(int n, int n2, int n3, int n4) {
        double d = 0.0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n3;
            while (n6 < n4) {
                double d2 = this.elementAt(n5, n6);
                d += d2 * d2;
                ++n6;
            }
            ++n5;
        }
        return d;
    }

    public String toString() {
        String string = "Matrix[" + this.sizeOfRows() + "][" + this.sizeOfColumns() + "] = \n";
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            string = String.valueOf(string) + "[" + matrixElementI.getRowIndex() + "][" + matrixElementI.getColumnIndex() + "] " + matrixElementI.getValue() + "\n";
        }
        return string;
    }

    private class _Enum
    implements Enumeration,
    MatrixElementI {
        int _i;
        int _j;
        int _mi;
        int _mj;

        _Enum() {
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return Matrix.this.elementAt(this._mi, this._mj);
        }

        public boolean hasMoreElements() {
            return this._i < Matrix.this.sizeOfRows();
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                return null;
            }
            this._mi = this._i++;
            this._mj = this._j++;
            if (this._j >= Matrix.this.sizeOfColumns()) {
                this._j = 0;
            }
            return this;
        }

        public void setValue(double d) {
            Matrix.this.setElementAt(this._mi, this._mj, d);
        }
    }

    private class _RowEnum
    implements Enumeration,
    MatrixElementI {
        int _j = 0;
        int _mi;
        int _mj;

        public _RowEnum(int n) {
            this._mi = n;
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return Matrix.this.elementAt(this._mi, this._mj);
        }

        public boolean hasMoreElements() {
            return this._j < Matrix.this.sizeOfColumns();
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                return null;
            }
            this._mj = this._j++;
            return this;
        }

        public void setValue(double d) {
            Matrix.this.setElementAt(this._mi, this._mj, d);
        }
    }

    private class _ColumnEnum
    implements Enumeration,
    MatrixElementI {
        int _i = 0;
        int _mi;
        int _mj;

        public _ColumnEnum(int n) {
            this._mj = n;
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return Matrix.this.elementAt(this._mi, this._mj);
        }

        public boolean hasMoreElements() {
            return this._i < Matrix.this.sizeOfRows();
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                return null;
            }
            this._mi = this._i++;
            return this;
        }

        public void setValue(double d) {
            Matrix.this.setElementAt(this._mi, this._mj, d);
        }
    }
}

