/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.mp;

import drasys.or.mp.ConstraintI;
import drasys.or.mp.MpError;
import java.io.Serializable;

public class Constraint
implements ConstraintI,
Serializable {
    int _rowIndex = 0;
    byte _type = (byte)11;
    String _name = null;
    double _lowerRange = 0.0;
    double _upperRange = 0.0;
    double _rightHandSide = 0.0;

    Constraint(int n, String string) {
        this._name = string;
        this._rowIndex = n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstraintI)) {
            return false;
        }
        ConstraintI constraintI = (ConstraintI)object;
        if (this._type != constraintI.getType()) {
            return false;
        }
        if (this._type == 14) {
            if (this._lowerRange != constraintI.getLowerRange()) {
                return false;
            }
            if (this._upperRange != constraintI.getUpperRange()) {
                return false;
            }
        } else if (this._rightHandSide != constraintI.getRightHandSide()) {
            return false;
        }
        return true;
    }

    public double getLowerRange() {
        return this._lowerRange;
    }

    public String getName() {
        return this._name;
    }

    public double getRightHandSide() {
        return this._rightHandSide;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public byte getType() {
        return this._type;
    }

    public double getUpperRange() {
        return this._upperRange;
    }

    public ConstraintI setLowerRange(double d) {
        this._lowerRange = d;
        return this;
    }

    public ConstraintI setRightHandSide(double d) {
        this._rightHandSide = d;
        return this;
    }

    public ConstraintI setType(byte by) {
        if (by != 10 && by != 11 && by != 12 && by != 13 && by != 14) {
            throw new MpError("Invalid constraint type: " + by);
        }
        this._type = by;
        return this;
    }

    public ConstraintI setUpperRange(double d) {
        this._upperRange = d;
        return this;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "[" + this._rowIndex + "]";
        if (this._name != null) {
            string = String.valueOf(string) + ", " + this._name;
        }
        string = String.valueOf(string) + ", " + Constraint.typeToString(this._type);
        string = String.valueOf(string) + ", Rhs=" + this._rightHandSide;
        string = String.valueOf(string) + ", LoRng=" + this._lowerRange;
        string = String.valueOf(string) + ", UpRng=" + this._upperRange;
        return string;
    }

    public static String typeToString(byte by) {
        switch (by) {
            case 10: {
                return "FREE";
            }
            case 11: {
                return "LESS";
            }
            case 13: {
                return "EQUAL";
            }
            case 14: {
                return "RANGE";
            }
            case 12: {
                return "GREATER";
            }
        }
        return "UNKNOWN-" + by;
    }
}

