/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.mp.util;

import drasys.or.mp.ConstraintI;
import drasys.or.mp.DuplicateException;
import drasys.or.mp.InvalidException;
import drasys.or.mp.NotFoundException;
import drasys.or.mp.SizableProblemI;
import drasys.or.mp.SyntaxException;
import drasys.or.mp.VariableI;
import drasys.or.mp.util.ProblemReaderI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class MPSReader
extends BufferedReader
implements ProblemReaderI {
    private static final int RHS = 0;
    private static final int ROWS = 1;
    private static final int INIT = 2;
    private static final int RANGES = 3;
    private static final int BOUNDS = 4;
    private static final int COLUMNS = 5;
    int _state = 2;
    int _lineNo = 0;
    String _line;
    boolean _gotRHS = false;
    boolean _insideIntMarker = false;
    SizableProblemI _problem;
    private String _objName = null;
    VariableI _currentVariable = null;
    String _rhsName = null;
    String _rngName = null;
    String _bndName = null;

    public MPSReader(Reader reader) {
        super(reader);
    }

    public MPSReader(Reader reader, int n) {
        super(reader, n);
    }

    private SizableProblemI _getProblem(SizableProblemI sizableProblemI) throws IOException, DuplicateException, SyntaxException, NotFoundException, InvalidException {
        String string;
        int n = 0;
        while ((string = this.readLine()) != null) {
            if (!this.parseLine(sizableProblemI, ++n, string)) break;
        }
        return sizableProblemI;
    }

    private void addRow(String string, String string2) throws DuplicateException, SyntaxException {
        if (string2.equals("N")) {
            if (this._objName == null) {
                this._objName = string;
                return;
            }
            if (string.equals(this._objName)) {
                return;
            }
            ConstraintI constraintI = this._problem.newConstraint(string);
            constraintI.setType((byte)20);
        } else if (string2.equals("G")) {
            ConstraintI constraintI = this._problem.newConstraint(string);
            constraintI.setType((byte)12);
        } else if (string2.equals("L")) {
            ConstraintI constraintI = this._problem.newConstraint(string);
            constraintI.setType((byte)11);
        } else if (string2.equals("E")) {
            ConstraintI constraintI = this._problem.newConstraint(string);
            constraintI.setType((byte)13);
        } else {
            throw new SyntaxException("A ROWS type field must be 'N', 'G', 'L' or 'E'.");
        }
    }

    public boolean parseComment(SizableProblemI sizableProblemI, int n, String string) throws SyntaxException {
        String[] stringArray = this.tokenize(string.substring(1));
        if (stringArray == null || stringArray.length < 2) {
            return true;
        }
        if (!stringArray[0].toUpperCase().equals("METADATUM")) {
            return true;
        }
        if (stringArray[2].charAt(0) == '\"') {
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                if (string.charAt(n3) == '\"') {
                    int n4 = n3 + 1;
                    while (n4 < n2) {
                        if (string.charAt(n4) == '\"') {
                            sizableProblemI.getMetadata().put(stringArray[1], string.substring(n3 + 1, n4));
                            return true;
                        }
                        ++n4;
                    }
                    throw new SyntaxException("Quoted string is not closed.");
                }
                ++n3;
            }
            throw new SyntaxException("Quoted string is not opened.");
        }
        sizableProblemI.getMetadata().put(stringArray[1], stringArray[2]);
        return true;
    }

    public boolean parseLine(SizableProblemI sizableProblemI, int n, String string) throws IOException, DuplicateException, SyntaxException, NotFoundException, InvalidException {
        this._line = string;
        this._problem = sizableProblemI;
        this._lineNo = n;
        if (string == null || string.length() < 1) {
            return true;
        }
        if (this._line.charAt(0) == '*') {
            return this.parseComment(sizableProblemI, n, string);
        }
        String[] stringArray = this.tokenize(this._line);
        if (stringArray == null) {
            return true;
        }
        int n2 = stringArray.length;
        if (n2 < 1) {
            return true;
        }
        if (string.length() >= 6 && stringArray[0].equals("NAME") && string.charAt(0) != ' ') {
            this._state = 2;
            int n3 = 4;
            while (n3 < string.length() && string.charAt(n3) == ' ') {
                ++n3;
            }
            int n4 = string.length();
            while (n4 > n3 && string.charAt(n4 - 1) == ' ') {
                --n4;
            }
            String string2 = string.substring(n3, n4);
            if (n2 >= 2) {
                this._problem.getMetadata().put("lp.name", string2);
            }
        } else if (stringArray[0].equals("ROWS") && string.charAt(0) != ' ') {
            this._state = 1;
        } else if (stringArray[0].equals("COLUMNS") && string.charAt(0) != ' ') {
            this._state = 5;
            this._insideIntMarker = false;
        } else if (stringArray[0].equals("RHS") && string.charAt(0) != ' ') {
            this._state = 0;
        } else if (stringArray[0].equals("RANGES") && string.charAt(0) != ' ') {
            this._state = 3;
        } else if (stringArray[0].equals("BOUNDS") && string.charAt(0) != ' ') {
            this._state = 4;
        } else {
            if (stringArray[0].equals("ENDATA") && string.charAt(0) != ' ') {
                return false;
            }
            if (this._state == 2) {
                return true;
            }
            if (this._state == 1) {
                if (n2 != 2) {
                    throw new SyntaxException("A ROWS definition must have two fields.");
                }
                this.addRow(stringArray[1], stringArray[0]);
            } else if (this._state == 5) {
                if (n2 != 3 && n2 != 5) {
                    throw new SyntaxException("A COLUMNS definition must have three or five fields.");
                }
                if (stringArray[1].equals("'MARKER'")) {
                    if (stringArray[2].equals("'INTORG'")) {
                        if (this._insideIntMarker) {
                            throw new SyntaxException("Got 'INTORG' in integer section.");
                        }
                        this._insideIntMarker = true;
                    } else if (stringArray[2].equals("'INTEND'")) {
                        if (!this._insideIntMarker) {
                            throw new SyntaxException("Got 'INTEND' in continuous section.");
                        }
                        this._insideIntMarker = false;
                    }
                } else {
                    byte by = this._insideIntMarker ? (byte)22 : 21;
                    this.setColumn(stringArray[0], stringArray[1], new Double(stringArray[2]), by);
                    if (n2 == 5) {
                        this.setColumn(stringArray[0], stringArray[3], new Double(stringArray[4]), by);
                    }
                }
            } else if (this._state == 0) {
                if (n2 != 3 && n2 != 5) {
                    throw new SyntaxException("A RHS definition must have three or five fields.");
                }
                this.setRHS(stringArray[0], stringArray[1], new Double(stringArray[2]));
                if (n2 == 5) {
                    this.setRHS(stringArray[0], stringArray[3], new Double(stringArray[4]));
                }
            } else if (this._state == 3) {
                if (n2 != 3 && n2 != 5) {
                    throw new SyntaxException("A RANGE definition must have three or five fields.");
                }
                this.setRange(stringArray[0], stringArray[1], new Double(stringArray[2]));
                if (n2 == 5) {
                    this.setRange(stringArray[0], stringArray[3], new Double(stringArray[4]));
                }
            } else if (this._state == 4) {
                if (n2 == 3) {
                    this.setBound(stringArray[1], stringArray[2], stringArray[0], 0.0);
                } else if (n2 == 4) {
                    this.setBound(stringArray[1], stringArray[2], stringArray[0], new Double(stringArray[3]));
                } else {
                    throw new SyntaxException("The BOUND definition has the wrong number of tokens.");
                }
            }
        }
        return true;
    }

    public SizableProblemI readProblem(SizableProblemI sizableProblemI) throws IOException, SyntaxException {
        try {
            return this._getProblem(sizableProblemI);
        }
        catch (SyntaxException syntaxException) {
            String string = " -- Syntax Exception --";
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + syntaxException.getMessage();
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + "At line " + this._lineNo + ": " + this._line;
            throw new SyntaxException(string, this._lineNo, this._line);
        }
        catch (DuplicateException duplicateException) {
            String string = " -- Duplicate Exception --";
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + duplicateException.getMessage();
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + "At line " + this._lineNo + ": " + this._line;
            throw new SyntaxException(string, this._lineNo, this._line);
        }
        catch (NotFoundException notFoundException) {
            String string = " -- Not Found Exception --";
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + notFoundException.getMessage();
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + "At line " + this._lineNo + ": " + this._line;
            throw new SyntaxException(string, this._lineNo, this._line);
        }
        catch (InvalidException invalidException) {
            String string = " -- Invalid Exception --";
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + invalidException.getMessage();
            string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            string = String.valueOf(string) + "At line " + this._lineNo + ": " + this._line;
            throw new SyntaxException(string, this._lineNo, this._line);
        }
    }

    private void setBound(String string, String string2, String string3, double d) throws SyntaxException, NotFoundException, InvalidException {
        VariableI variableI = this._problem.getVariable(string2);
        if (variableI == null) {
            throw new NotFoundException("Can't find column: " + string2);
        }
        if (this._bndName == null) {
            this._bndName = string;
        }
        if (string3.equals("LO")) {
            if (variableI.getType() == 22 && (double)((int)d) != d) {
                throw new InvalidException("A 'LO' bound for an integer variable must be integer.");
            }
            variableI.setLowerBound(d);
        } else if (string3.equals("UP")) {
            if (variableI.getType() == 22 && (double)((int)d) != d) {
                throw new InvalidException("An 'UP' bound for an integer variable must be integer.");
            }
            variableI.setUpperBound(d);
        } else if (string3.equals("FX")) {
            variableI.setLowerBound(d);
            variableI.setUpperBound(d);
        } else if (string3.equals("FR")) {
            variableI.setUpperBound(Double.POSITIVE_INFINITY);
            variableI.setLowerBound(Double.NEGATIVE_INFINITY);
        } else if (string3.equals("MI")) {
            variableI.setUpperBound(Double.NEGATIVE_INFINITY);
        } else if (string3.equals("PL")) {
            variableI.setUpperBound(Double.POSITIVE_INFINITY);
        } else if (string3.equals("BV")) {
            variableI.setLowerBound(0.0);
            variableI.setUpperBound(1.0);
            variableI.setType((byte)23);
        } else if (string3.equals("LI")) {
            if ((double)((int)d) != d) {
                throw new InvalidException("An 'LI' bound must be integer.");
            }
            variableI.setType((byte)22);
            variableI.setLowerBound(d);
        } else if (string3.equals("UI")) {
            if ((double)((int)d) != d) {
                throw new InvalidException("A 'UI' bound must be integer.");
            }
            variableI.setType((byte)22);
            variableI.setUpperBound(d);
        } else {
            throw new SyntaxException("A BOUNDS type field must be 'LO', 'UP', 'FX', 'FR', 'MI', 'PL', 'BV', 'LI' or 'UI'.");
        }
    }

    private void setColumn(String string, String string2, double d, byte by) throws NotFoundException, DuplicateException {
        if (this._currentVariable == null || !string.equals(this._currentVariable.getName())) {
            this._currentVariable = this._problem.newVariable(string);
            this._currentVariable.setType(by);
        }
        if (this._objName != null && string2.equals(this._objName)) {
            this._currentVariable.setObjectiveCoefficient(d);
        } else {
            ConstraintI constraintI = this._problem.getConstraint(string2);
            if (constraintI == null) {
                throw new NotFoundException("Can't find row '" + string2 + "'.");
            }
            this._problem.setCoefficientAt(constraintI.getRowIndex(), this._currentVariable.getColumnIndex(), d);
        }
    }

    private void setRHS(String string, String string2, double d) throws NotFoundException, DuplicateException {
        if (this._rhsName == null) {
            this._rhsName = string;
        }
        if (string.equals(this._rhsName)) {
            ConstraintI constraintI = this._problem.getConstraint(string2);
            if (constraintI == null) {
                throw new NotFoundException("Can't find row '" + string2 + "'.");
            }
            constraintI.setRightHandSide(d);
        } else {
            this.setColumn(string, string2, d, (byte)20);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setRange(String string, String string2, double d) throws NotFoundException, DuplicateException {
        if (this._rngName == null) {
            this._rngName = string;
        }
        if (string.equals(this._rngName)) {
            ConstraintI constraintI = this._problem.getConstraint(string2);
            if (constraintI == null) {
                throw new NotFoundException("Can't find row '" + string2 + "'.");
            }
            if (constraintI.getType() == 14) {
                return;
            }
            if (constraintI.getType() == 11) {
                constraintI.setUpperRange(constraintI.getRightHandSide());
                constraintI.setLowerRange(constraintI.getRightHandSide() - Math.abs(d));
                constraintI.setType((byte)14);
                return;
            } else if (constraintI.getType() == 12) {
                constraintI.setUpperRange(constraintI.getRightHandSide() + Math.abs(d));
                constraintI.setLowerRange(constraintI.getRightHandSide());
                constraintI.setType((byte)14);
                return;
            } else {
                if (constraintI.getType() != 13) throw new Error("Unknown type in range: " + constraintI.getName() + " = " + constraintI.getType());
                if (d >= 0.0) {
                    constraintI.setUpperRange(constraintI.getRightHandSide() + d);
                    constraintI.setLowerRange(constraintI.getRightHandSide());
                    constraintI.setType((byte)14);
                    return;
                } else {
                    constraintI.setUpperRange(constraintI.getRightHandSide());
                    constraintI.setLowerRange(constraintI.getRightHandSide() + d);
                    constraintI.setType((byte)14);
                }
            }
            return;
        } else {
            this.setColumn(string, string2, d, (byte)20);
        }
    }

    private String[] tokenize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }
}

