/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.nonlinear;

import drasys.or.nonlinear.AccuracyException;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.IntegrationI;
import java.io.Serializable;

public class Simpsons
implements IntegrationI,
Serializable {
    int _maxIt = 25;
    double _epsilon = 1.0E-6;

    public double getEpsilon() {
        return this._epsilon;
    }

    public int getMaxIterations() {
        return this._maxIt;
    }

    public double integrate(FunctionI functionI, double d, double d2) throws AccuracyException {
        double d3;
        double d4;
        double d5;
        double d6;
        if (d == d2) {
            return 0.0;
        }
        if (d2 < d) {
            d6 = d;
            d5 = d2;
        } else {
            d5 = d;
            d6 = d2;
        }
        double d7 = d6 - d5;
        double d8 = d4 = 0.5 * d7 * (functionI.function(d5) + functionI.function(d6));
        double d9 = d3 = (4.0 * d4 - d8) / 3.0;
        int n = 1;
        int n2 = 0;
        while (n2 < this._maxIt) {
            double d10 = d7 / (double)n;
            double d11 = d5 + 0.5 * d10;
            double d12 = 0.0;
            int n3 = 0;
            while (n3 < n) {
                d12 += functionI.function(d11);
                d11 += d10;
                ++n3;
            }
            d3 = (4.0 * (d4 = 0.5 * (d4 + d7 * d12 / (double)n)) - d8) / 3.0;
            if (Math.abs(d3 - d9) <= this._epsilon * Math.abs(d9)) {
                return d3;
            }
            d9 = d3;
            d8 = d4;
            n <<= 1;
            ++n2;
        }
        throw new AccuracyException("Can't find the answer to the specified accuracy");
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    public void setMaxIterations(int n) {
        this._maxIt = n;
    }
}

