/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.prob.LinearCongruential;
import drasys.or.prob.RandomI;
import java.io.Serializable;

public class BaysDurhamShuffle
implements RandomI,
Serializable {
    int _sizeOfBits;
    long _last;
    long[] _array;
    RandomI _random;

    public BaysDurhamShuffle() {
        this._random = new LinearCongruential(System.currentTimeMillis());
        this.init();
    }

    public BaysDurhamShuffle(long l) {
        this._random = new LinearCongruential(l);
        this.init();
    }

    public BaysDurhamShuffle(RandomI randomI) {
        this._random = randomI;
        this.init();
    }

    private void init() {
        this._sizeOfBits = this._random.sizeOfBits();
        this._array = new long[32];
        int n = 0;
        while (n < 8) {
            this._random.next();
            ++n;
        }
        int n2 = 0;
        while (n2 < 32) {
            this._array[n2] = this._random.next();
            ++n2;
        }
        this._last = this._random.next();
    }

    public long next() {
        int n = (int)(this._last >>> this._sizeOfBits - 5 & 0x1FL);
        this._last = this._array[n];
        this._array[n] = this._random.next();
        return this._last;
    }

    public double nextDouble() {
        return (double)((this.next() >>> this._sizeOfBits - 26 << 27) + (this.next() >>> this._sizeOfBits - 27)) / 9.007199254740992E15;
    }

    public void setSeed(long l) {
        this._random.setSeed(l);
        this.init();
    }

    public int sizeOfBits() {
        return this._sizeOfBits;
    }
}

