/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.FunctionsI;
import drasys.or.InvalidArgumentError;
import drasys.or.nonlinear.Bisection;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.NonlinearException;
import drasys.or.prob.BinomialDistributionBase;
import drasys.or.prob.DiscreteDistributionI;
import drasys.or.prob.IncompleteBeta;
import drasys.or.prob.ProbError;

public class BinomialDistribution
extends BinomialDistributionBase
implements DiscreteDistributionI,
FunctionI {
    Bisection _solver;

    public BinomialDistribution(double d, int n) {
        super(d, n);
    }

    public BinomialDistribution(double d, int n, long l) {
        super(d, n, l);
    }

    public BinomialDistribution(double d, int n, FunctionsI functionsI) {
        super(d, n, functionsI);
    }

    public double cdf(int n) {
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        if (n >= this._n) {
            return 1.0;
        }
        return 1.0 - new IncompleteBeta(n + 1, this._n - n).function(this._p);
    }

    public static double computeProportion(int n, int n2, double d) {
        try {
            return new Bisection().solve(new IncompleteBeta(n2 + 1, n - n2), 0.0, 1.0, 1.0 - d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("Nonlinear:" + nonlinearException.getMessage());
        }
    }

    public double function(double d) {
        if (d >= (double)this._n) {
            return 1.0;
        }
        return 1.0 - new IncompleteBeta(d + 1.0, (double)this._n - d).function(this._p);
    }

    public int inverseCdf(double d) {
        double d2;
        if (d < 0.0) {
            throw new ProbError("The 'probability' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("The 'probability' can't be greater than '1.0'.");
        }
        if (d == 1.0) {
            return this._n;
        }
        if (this._solver == null) {
            this._solver = new Bisection();
        }
        try {
            d2 = this._solver.solve(this, 0.0, this._n, d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("Nonlinear:" + nonlinearException.getMessage());
        }
        int n = (int)d2;
        int n2 = (int)Math.ceil(d2);
        double d3 = Math.abs(d - this.cdf(n));
        double d4 = Math.abs(d - this.cdf(n2));
        return d4 < d3 ? n2 : n;
    }

    public double probability(int n, int n2) {
        if (n2 < n) {
            throw new InvalidArgumentError("The x2 must be greater than x1.");
        }
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        if (n == 0) {
            return this.cdf(n2);
        }
        return this.cdf(n2) - this.cdf(n - 1);
    }
}

