/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.InvalidArgumentError;
import drasys.or.nonlinear.Bisection;
import drasys.or.nonlinear.EquationSolutionI;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.NonlinearException;
import drasys.or.prob.ContinuousDistribution;
import drasys.or.prob.IncompleteGamma;
import drasys.or.prob.ProbError;

public class ChiSquareDistribution
extends ContinuousDistribution
implements FunctionI {
    double _n;
    double _k;
    double _n2;
    double _n22;
    IncompleteGamma _igamma;
    static final double MAX = 10000.0;
    static EquationSolutionI _solver;

    public ChiSquareDistribution(double d) {
        if (d < 1.0) {
            throw new InvalidArgumentError("The degreesOfFreedom can't be less than '1.0'.");
        }
        this._n = d;
        this._n2 = 0.5 * this._n;
        this._n22 = 0.5 * (this._n - 2.0);
        this._igamma = new IncompleteGamma(this._n2);
        this._k = Math.log(1.0) - Math.log(2.0) * this._n2 - this._igamma.lnGamma(this._n2);
    }

    public double cdf(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 10000.0) {
            return 1.0;
        }
        return this._igamma.function(0.5 * d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChiSquareDistribution)) {
            return false;
        }
        ChiSquareDistribution chiSquareDistribution = (ChiSquareDistribution)object;
        return chiSquareDistribution._n == this._n;
    }

    public double function(double d) {
        return this.cdf(d);
    }

    public double inverseCdf(double d) {
        double d2;
        if (d < 0.0) {
            throw new ProbError("The 'probability' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("The 'probability' can't be greater than '1.0'.");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= this.cdf(10000.0)) {
            return 10000.0;
        }
        if (_solver == null) {
            _solver = new Bisection();
        }
        try {
            d2 = _solver.solve(this, 0.0, 10000.0, d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("Nonlinear:" + nonlinearException.getMessage());
        }
        return d2;
    }

    public double mean() {
        return this._n;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new InvalidArgumentError("'x' can't be negative.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        return Math.exp(this._k + Math.log(d) * this._n22 + -0.5 * d);
    }

    public double probability(double d, double d2) {
        if (d2 < d) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (d == d2) {
            return 0.0;
        }
        return this.cdf(d2) - this.cdf(d);
    }

    public double std() {
        if (this._n <= 4.0) {
            throw new ProbError("Can't compute the std for degreesOfFreedom <= 4.0");
        }
        return Math.sqrt(this.variance());
    }

    public String toString() {
        return "ChiSquareDistribution(degreesOfFreedom = " + this._n + ")";
    }

    public double variance() {
        return 2.0 * this._n;
    }
}

