/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.Functions;
import drasys.or.InvalidArgumentError;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.Integration;
import drasys.or.nonlinear.IntegrationI;
import drasys.or.nonlinear.NonlinearException;
import drasys.or.prob.ContinuousDistribution;
import drasys.or.prob.ContinuousDistributionI;
import drasys.or.prob.ProbError;

public class GammaDistribution
extends ContinuousDistribution
implements ContinuousDistributionI,
FunctionI {
    double _alpha;
    double _beta;
    double _coef;
    IntegrationI _integration;

    public GammaDistribution() {
        this.setParameters(1.0, 1.0);
    }

    public GammaDistribution(double d, double d2) {
        this.setParameters(d, d2);
    }

    public GammaDistribution(double d, double d2, long l) {
        super(l);
        this.setParameters(d, d2);
    }

    public GammaDistribution(double d, double d2, IntegrationI integrationI) {
        this._integration = integrationI;
        this.setParameters(d, d2);
    }

    public double alpha() {
        return this._alpha;
    }

    public double beta() {
        return this._beta;
    }

    public double cdf(double d) {
        double d2;
        if (d <= 0.0) {
            return 0.0;
        }
        if (this._integration == null) {
            this._integration = new Integration();
        }
        try {
            d2 = this._integration.integrate(this, 0.0, d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError(nonlinearException.getMessage());
        }
        return d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GammaDistribution)) {
            return false;
        }
        GammaDistribution gammaDistribution = (GammaDistribution)object;
        return gammaDistribution._alpha == this._alpha && gammaDistribution._beta == this._beta;
    }

    public double function(double d) {
        return this.pdf(d);
    }

    public double getRandomScaler() {
        double d;
        if (this._alpha < 1.0 || (double)((int)this._alpha) != this._alpha) {
            throw new ProbError("Can only generate random gamma scalers for integer alpha values greater than zero.");
        }
        if (this._alpha <= 10.0) {
            int n = (int)this._alpha;
            double d2 = 1.0;
            int n2 = 0;
            while (n2 < n) {
                d2 *= this._random.nextDouble();
                ++n2;
            }
            return -this._beta * Math.log(d2);
        }
        double d3 = this._alpha - 1.0;
        while (true) {
            double d4;
            double d5;
            double d6;
            if ((d6 = (d5 = this._random.nextDouble() * 2.0 - 1.0) * d5 + (d4 = this._random.nextDouble() * 2.0 - 1.0) * d4) > 1.0 || d6 == 0.0) {
                continue;
            }
            double d7 = d4 / d5;
            double d8 = Math.sqrt(2.0 * d3 + 1.0);
            d = d8 * d7 + d3;
            if (d <= 0.0) continue;
            double d9 = (1.0 + d7 * d7) * Math.exp(d3 * Math.log(d / d3) - d8 * d7);
            if (!(this._random.nextDouble() > d9)) break;
        }
        return this._beta * d;
    }

    public double mean() {
        return this._beta * this._alpha;
    }

    public double pdf(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return this._coef * Math.pow(d, this._alpha) * Math.exp(-d / this._beta);
    }

    public double probability(double d, double d2) {
        double d3;
        if (d2 < d) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (d < 0.0) {
            throw new InvalidArgumentError("X1 can not be less than zero.");
        }
        if (d == d2) {
            return 0.0;
        }
        if (this._integration == null) {
            this._integration = new Integration();
        }
        try {
            d3 = this._integration.integrate(this, d, d2);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError(nonlinearException.getMessage());
        }
        return d3;
    }

    public void setParameters(double d, double d2) {
        if (d <= 0.0) {
            throw new InvalidArgumentError("The alpha parameter for the gamma distribution must be strictly greater than -1.");
        }
        if (d2 <= 0.0) {
            throw new InvalidArgumentError("The beta parameter for the gamma distribution must be strictly greater than 0.");
        }
        this._alpha = d;
        this._beta = d2;
        double d3 = d + 1.0;
        this._coef = Math.exp(-new Functions().lnGamma(d3)) / Math.pow(d2, d3);
    }

    public void setParameters(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new InvalidArgumentError("The alpha parameter for the gamma distribution must be strictly greater than -1.");
        }
        if (d <= 0.0) {
            throw new InvalidArgumentError("The beta parameter for the gamma distribution must be strictly greater than 0.");
        }
        this._alpha = d;
        this._beta = d2;
        this._coef = d3;
    }

    public double std() {
        return this._beta * Math.sqrt(this._alpha);
    }

    public String toString() {
        return "GammaDistribution(alpha = " + this._alpha + ", beta = " + this._beta + ")";
    }

    public double variance() {
        return this._beta * this._beta * this._alpha;
    }
}

