/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.Functions;
import drasys.or.nonlinear.FunctionI;
import drasys.or.prob.ProbError;

public class IncompleteBeta
extends Functions
implements FunctionI {
    int _maxIt = 150;
    double _epsilon = 1.0E-6;
    double _a;
    double _b;
    double _k;
    double _t;
    double _s;
    double _o;
    double _q;
    double _l;
    double _p;
    double _r;
    double _m;

    public IncompleteBeta(double d, double d2) {
        this._a = d;
        this._b = d2;
        this._t = (d + 1.0) / (d + d2 + 2.0);
        this._k = this.lnGamma(d + d2) - this.lnGamma(d) - this.lnGamma(d2);
        this._s = d + d2;
        this._o = d - 1.0;
        this._q = d + 1.0;
        this._l = this._s / this._q;
        this._p = d2 - 1.0;
        this._r = d2 + 1.0;
        this._m = this._s / this._r;
    }

    private double f1(double d) {
        double d2 = 1.0;
        double d3 = 1.0 - d * this._l;
        double d4 = d3 = 1.0 / d3;
        int n = 1;
        while (n <= this._maxIt) {
            double d5 = n;
            double d6 = 2.0 * d5;
            double d7 = d5 * (this._b - d5) * d / ((this._o + d6) * (this._a + d6));
            d3 = 1.0 + d7 * d3;
            d2 = 1.0 + d7 / d2;
            d3 = 1.0 / d3;
            d4 *= d3 * d2;
            d7 = -(this._a + d5) * (this._s + d5) * d / ((this._a + d6) * (this._q + d6));
            d3 = 1.0 + d7 * d3;
            d2 = 1.0 + d7 / d2;
            d3 = 1.0 / d3;
            double d8 = d3 * d2;
            d4 *= d8;
            if (Math.abs(d8 - 1.0) < this._epsilon) {
                return d4;
            }
            ++n;
        }
        throw new ProbError("Can't solve BetaCF to _epsilonilon.");
    }

    private double f2(double d) {
        double d2 = 1.0;
        double d3 = 1.0 - d * this._m;
        double d4 = d3 = 1.0 / d3;
        int n = 1;
        while (n <= this._maxIt) {
            double d5 = n;
            double d6 = 2.0 * d5;
            double d7 = d5 * (this._a - d5) * d / ((this._p + d6) * (this._b + d6));
            d3 = 1.0 + d7 * d3;
            d2 = 1.0 + d7 / d2;
            d3 = 1.0 / d3;
            d4 *= d3 * d2;
            d7 = -(this._b + d5) * (this._s + d5) * d / ((this._b + d6) * (this._r + d6));
            d3 = 1.0 + d7 * d3;
            d2 = 1.0 + d7 / d2;
            d3 = 1.0 / d3;
            double d8 = d3 * d2;
            d4 *= d8;
            if (Math.abs(d8 - 1.0) < this._epsilon) {
                return d4;
            }
            ++n;
        }
        throw new ProbError("Can't solve BetaCF to _epsilonilon.");
    }

    public double function(double d) throws ProbError {
        double d2;
        if (d < 0.0) {
            throw new ProbError("'x' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("'x' can't be greater than '1.0'.");
        }
        double d3 = d2 = d == 0.0 || d == 1.0 ? 0.0 : Math.exp(this._k + Math.log(d) * this._a + Math.log(1.0 - d) * this._b);
        if (d < this._t) {
            return d2 * this.f1(d) / this._a;
        }
        return 1.0 - d2 * this.f2(1.0 - d) / this._b;
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    public void setMaxIterations(int n) {
        this._maxIt = n;
    }
}

