/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat;

import drasys.or.alg.QuickSort;
import drasys.or.matrix.VectorI;
import drasys.or.prob.BinomialDistribution;
import drasys.or.prob.ProbError;

public class PopulationMedian {
    int _x;
    int _s1;
    double _median;
    double _lastConf = Double.NEGATIVE_INFINITY;
    double[] _sample;
    BinomialDistribution _bd;

    public PopulationMedian(VectorI vectorI) {
        this._sample = vectorI.getArray();
        this._bd = new BinomialDistribution(0.5, this._sample.length);
        new QuickSort().sort(this._sample);
        if ((this._sample.length & 1) == 1) {
            this._s1 = this._sample.length / 2;
            this._median = this._sample[this._s1];
        } else {
            this._s1 = this._sample.length / 2 - 1;
            this._median = 0.5 * (this._sample[this._s1] + this._sample[this._s1 + 1]);
        }
    }

    private void getInv(double d) {
        int n = this._bd.inverseCdf(0.5 * (1.0 - d));
        if (n > this._s1) {
            throw new ProbError("The confidence level is too low.");
        }
        this._lastConf = d;
        this._x = n;
    }

    public double getLowerBound(double d) {
        if (this._lastConf != d) {
            this.getInv(d);
        }
        return this._sample[this._x];
    }

    public double getMedian() {
        return this._median;
    }

    public double getUpperBound(double d) {
        if (this._lastConf != d) {
            this.getInv(d);
        }
        return this._sample[this._sample.length - this._x - 1];
    }

    public double size() {
        return this._sample.length;
    }
}

