/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat.model;

import drasys.or.matrix.FunctionMatrix;
import drasys.or.matrix.MatrixI;

public class PolynomialMatrix
extends FunctionMatrix {
    private MatrixI _matrix;
    private int _n;
    private int _d;

    public PolynomialMatrix(MatrixI matrixI, int n) {
        if (n < 1) {
            throw new Error("The degree must be greater than zero.");
        }
        this._d = n;
        this._matrix = matrixI;
        this._sizeOfRows = matrixI.sizeOfRows();
        this._n = matrixI.sizeOfColumns();
        this._sizeOfColumns = this._n * this._d;
    }

    public double functionElementAt(int n, int n2) {
        if (n2 < this._n) {
            return this._matrix.elementAt(n, n2);
        }
        int n3 = 1 + n2 / this._n;
        double d = this._matrix.elementAt(n, n2 % this._n);
        if (n3 == 2) {
            return d * d;
        }
        if (n3 == 3) {
            return d * d * d;
        }
        return Math.pow(d, n3);
    }

    public int getTermIndex(int n, int n2) {
        if (n >= this._n) {
            throw new Error("The column index (" + n + ") exceeds the size of the underlying matrix (" + this._n + ").");
        }
        if (n2 > this._d) {
            throw new Error("The degree (" + n2 + ") expeeds the degree of the model (" + this._d + ").");
        }
        if (n2 < 1) {
            throw new Error("The degree (" + n2 + ") can't be less than one.");
        }
        if (n2 == 1) {
            return n;
        }
        return this._n * (n2 - 1) + n;
    }
}

