/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vrp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.vecmath.Point2d;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.SystemsList;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.vrp.planning.VrpManager;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(author="zp", name="TSP Planner Daemon", version="0.1", icon="pt/lsts/neptus/plugins/vrp/stars.png")
@LayerPriority(priority=51)
public class WaypointPlanner
extends ConsolePanel
implements Renderer2DPainter,
IEditorMenuExtension,
StateRendererInteraction {
    @NeptusProperty(name="Depth", description="Depth of the first generated plan")
    public double planDepth = 1.0;
    @NeptusProperty(name="Distance between generated plans", description="The z offeset between plans, in case more than one plans are generated")
    public double planDistance = 0.0;
    private static final long serialVersionUID = 1L;
    protected Vector<LocationType> points = new Vector();
    protected Vector<Vector<Point2d>> solution = new Vector();
    protected Vector<String> availableVehicles = new Vector();
    protected AbstractAction openAction;
    protected AbstractAction saveAction;
    protected AbstractAction newAction;
    protected AbstractAction solveAction;
    protected AbstractAction createAction;
    protected AbstractAction clearAction;
    protected File workingFile = null;
    protected InteractionAdapter adapter;
    protected boolean alreadyInited = false;

    public WaypointPlanner(ConsoleLayout console) {
        super(console);
        this.adapter = new InteractionAdapter(console);
        this.setVisibility(false);
        this.openAction = new AbstractAction("Load waypoint list"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WaypointPlanner.this.openList();
            }
        };
        this.saveAction = new AbstractAction("Save waypoint list"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WaypointPlanner.this.saveList();
            }
        };
        this.newAction = new AbstractAction("Create waypoint list", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/planning/planning.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WaypointPlanner.this.newList();
            }
        };
        this.solveAction = new AbstractAction("Solve TSP", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/planning/planning.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WaypointPlanner.this.solve();
            }
        };
        this.createAction = new AbstractAction("Generate Neptus Plans", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/planning/planning.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WaypointPlanner.this.generatePlans();
            }
        };
    }

    private void openList() {
        JFileChooser chooser = new JFileChooser("conf/waypoints");
        int option = chooser.showOpenDialog((Component)this.getConsole());
        chooser.setMultiSelectionEnabled(false);
        if (option == 0) {
            NeptusLog.pub().info((Object)("<###>open " + chooser.getSelectedFile()));
            this.workingFile = chooser.getSelectedFile();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.workingFile));
                this.points.clear();
                this.solution = null;
                String line = reader.readLine();
                while (line != null) {
                    if (!line.startsWith("#")) {
                        String[] ll = line.split(" ");
                        double lat = CoordinateUtil.parseLatitudeCoordToDoubleValue((String)ll[0]);
                        double lon = CoordinateUtil.parseLongitudeCoordToDoubleValue((String)ll[1]);
                        LocationType l = new LocationType();
                        l.setLatitudeDegs(lat);
                        l.setLongitudeDegs(lon);
                        this.points.add(l);
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception e) {
                GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
                NeptusLog.pub().error((Object)e);
            }
            this.repaint();
        }
    }

    private void saveList() {
        JFileChooser chooser = this.workingFile != null ? new JFileChooser(this.workingFile) : new JFileChooser("conf/waypoints");
        int option = chooser.showSaveDialog((Component)this.getConsole());
        if (option == 0) {
            File f = chooser.getSelectedFile();
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(f));
                writer.write("# Waypoint list generated by Neptus on " + new Date() + "\n");
                for (LocationType lt : this.points) {
                    double[] lld = lt.getAbsoluteLatLonDepth();
                    writer.write(CoordinateUtil.latitudeAsPrettyString((double)lld[0], (boolean)false) + " ");
                    writer.write(CoordinateUtil.longitudeAsPrettyString((double)lld[1], (boolean)false) + "\n");
                }
                writer.close();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    private void newList() {
        this.workingFile = null;
        this.points.clear();
        this.repaint();
    }

    private void solve() {
        this.availableVehicles.clear();
        MissionType mission = this.getConsole().getMission();
        if (mission == null) {
            GuiUtils.errorMessage((Component)this.getConsole(), (String)"TSP Plan generator", (String)"No mission has been set.");
            return;
        }
        Vector tmp = this.getConsole().getSubPanelsOfClass(SystemsList.class);
        if (!tmp.isEmpty()) {
            this.availableVehicles.addAll(((SystemsList)tmp.get(0)).getSelectedSystems(true));
        }
        if (this.availableVehicles.isEmpty() && this.getConsole().getMainSystem() != null) {
            this.availableVehicles.add(this.getConsole().getMainSystem());
        }
        Point2d zero = new Point2d(0.0, 0.0);
        Vector<Point2d> pts = new Vector<Point2d>();
        for (LocationType l : this.points) {
            pts.add(new Point2d(l.getOffsetFrom((LocationType)mission.getHomeRef())));
        }
        this.solution = VrpManager.computePathsSingleDepot(zero, pts, this.availableVehicles.size());
    }

    private void generatePlans() {
        this.solve();
        String planid = JOptionPane.showInputDialog((Component)this.getConsole(), (Object)"Enter desired plan prefix");
        if (planid == null) {
            return;
        }
        MissionType mission = this.getConsole().getMission();
        for (int i = 0; i < this.availableVehicles.size(); ++i) {
            String vname = this.availableVehicles.get(i);
            Vector<Point2d> p = this.solution.get(i);
            PlanCreator creator = new PlanCreator(this.getConsole().getMission());
            LocationType loc = new LocationType((LocationType)this.getConsole().getMission().getHomeRef());
            for (Point2d pt : p) {
                creator.setLocation(loc);
                creator.move(pt.x, pt.y);
                creator.addManeuver("Goto");
            }
            PlanType plan = creator.getPlan();
            if (planid.toString().length() > 0) {
                plan.setId(planid.toString() + "_" + vname);
            }
            plan.setVehicle(vname);
            mission.addPlan(plan);
        }
        this.getConsole().getMission().save(false);
        this.getConsole().updateMissionListeners();
    }

    public void initSubPanel() {
        if (this.alreadyInited) {
            return;
        }
        this.alreadyInited = true;
        this.addMenuItem(I18n.text((String)"Settings") + ">" + I18n.text((String)"TSP Settings"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)WaypointPlanner.this, (Frame)WaypointPlanner.this.getConsole(), (boolean)true);
            }
        });
        Vector panels = this.getConsole().getSubPanelsOfInterface(CustomInteractionSupport.class);
        for (CustomInteractionSupport cis : panels) {
            cis.addInteraction((StateRendererInteraction)this);
        }
        Vector renders = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : renders) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, "TSP Painter");
        }
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        for (LocationType l : this.points) {
            Point2D pt = renderer.getScreenPosition(l);
            if (pt == null) continue;
            g.setColor(Color.white);
            g.fill(new Ellipse2D.Double(pt.getX() - 3.0, pt.getY() - 3.0, 6.0, 6.0));
            g.setColor(Color.black);
            g.draw(new Ellipse2D.Double(pt.getX() - 3.0, pt.getY() - 3.0, 6.0, 6.0));
        }
    }

    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        final LocationType l = new LocationType(loc);
        Vector<JMenuItem> menus = new Vector<JMenuItem>();
        JMenu tspSolver = new JMenu("TSP Solver");
        menus.add(tspSolver);
        AbstractAction add = new AbstractAction("Add waypoint"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WaypointPlanner.this.points.add(new LocationType(l));
            }
        };
        tspSolver.add(new JMenuItem(add));
        AbstractAction clear = new AbstractAction("Clear waypoints"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WaypointPlanner.this.points.clear();
            }
        };
        if (!this.points.isEmpty()) {
            tspSolver.add(new JMenuItem(clear));
        }
        for (int i = 0; i < this.points.size(); ++i) {
            LocationType lt = this.points.get(i);
            if (!(lt.getDistanceInMeters(loc) < 1.5)) continue;
            final int index = i;
            AbstractAction remove = new AbstractAction("Remove waypoint"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    WaypointPlanner.this.points.remove(index);
                }
            };
            tspSolver.add(new JMenuItem(remove));
            break;
        }
        tspSolver.addSeparator();
        tspSolver.add(new JMenuItem(this.openAction));
        tspSolver.add(new JMenuItem(this.saveAction));
        tspSolver.add(new JMenuItem(this.createAction));
        return menus;
    }

    public Image getIconImage() {
        return ImageUtils.getImage((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass()));
    }

    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    public boolean isExclusive() {
        return true;
    }

    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add("Generate Plans").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    WaypointPlanner.this.generatePlans();
                }
            });
            popup.add("Clear Waypoints").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    WaypointPlanner.this.points.clear();
                }
            });
            popup.add("Load Waypoints").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    WaypointPlanner.this.openList();
                }
            });
            popup.add("Save Waypoints").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    WaypointPlanner.this.saveList();
                }
            });
            popup.add("Settings").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PropertiesEditor.editProperties((PropertiesProvider)WaypointPlanner.this, (Frame)WaypointPlanner.this.getConsole(), (boolean)true);
                }
            });
            popup.show((Component)source, event.getX(), event.getY());
        } else {
            LocationType clicked = source.getRealWorldLocation((Point2D)event.getPoint());
            for (int i = 0; i < this.points.size(); ++i) {
                LocationType lt = this.points.get(i);
                if (!(lt.getDistanceInMeters(clicked) < 1.5)) continue;
                this.points.remove(i);
                return;
            }
            this.points.add(clicked);
        }
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseDragged(event, source);
    }

    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
    }

    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        this.adapter.setActive(mode, source);
    }

    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }

    public void cleanSubPanel() {
    }
}

