/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vrp.planning;

import java.util.ArrayList;
import javax.vecmath.Point2d;

class CHull {
    CHull() {
    }

    static double distance(Point2d p1, Point2d p2, Point2d p3) {
        double x1 = p1.x;
        double x2 = p2.x;
        double x3 = p3.x;
        double y1 = p1.y;
        double y2 = p2.y;
        double y3 = p3.y;
        return x1 * y2 + x3 * y1 + x2 * y3 - x3 * y2 - x2 * y1 - x1 * y3;
    }

    static ArrayList<Point2d> cHull(ArrayList<Point2d> array) {
        int size = array.size();
        if (size < 2) {
            return null;
        }
        Point2d l = array.get(0);
        Point2d r = array.get(size - 1);
        ArrayList<Point2d> path = new ArrayList<Point2d>();
        path.add(l);
        CHull.cHull(array, l, r, path, 50);
        path.add(r);
        CHull.cHull(array, r, l, path, 50);
        return path;
    }

    static void cHull(ArrayList<Point2d> points, Point2d l, Point2d r, ArrayList<Point2d> path, int i) {
        if (i == 0) {
            return;
        }
        if (points.size() < 3) {
            return;
        }
        double maxDist = 0.0;
        Point2d p = null;
        for (Point2d pt : points) {
            double tmp;
            if (pt == l || pt == r || !((tmp = CHull.distance(l, r, pt)) > maxDist)) continue;
            maxDist = tmp;
            p = pt;
        }
        if (p == null) {
            return;
        }
        ArrayList<Point2d> left = new ArrayList<Point2d>();
        ArrayList<Point2d> right = new ArrayList<Point2d>();
        left.add(l);
        right.add(p);
        for (Point2d pt : points) {
            if (CHull.distance(l, p, pt) > 0.0) {
                left.add(pt);
                continue;
            }
            if (!(CHull.distance(p, r, pt) > 0.0)) continue;
            right.add(pt);
        }
        left.add(p);
        right.add(r);
        CHull.cHull(left, l, p, path, i - 1);
        path.add(p);
        CHull.cHull(right, p, r, path, i - 1);
    }

    static ArrayList<Point2d> resizePath(int n, ArrayList<Point2d> path, ArrayList<Point2d> points, Point2d fixed) {
        int size = path.size();
        if (path.size() > n) {
            while (size > n) {
                double incaux = 0.0;
                for (int x = 1; x < path.size(); ++x) {
                    if (x == path.size() - 1) {
                        incaux += path.get(x).distanceSquared(path.get(0));
                        continue;
                    }
                    incaux += path.get(x).distanceSquared(path.get(x + 1));
                }
                double maxaux = incaux;
                int index = 0;
                if (path.get(0) == fixed) {
                    maxaux = 0.0;
                }
                for (int i = 1; i < path.size(); ++i) {
                    incaux = 0.0;
                    for (int x = 0; x < path.size(); ++x) {
                        if (x == i) continue;
                        if (x == path.size() - 1) {
                            incaux += path.get(x).distanceSquared(path.get(0));
                            continue;
                        }
                        incaux += path.get(x).distanceSquared(path.get(x + 1));
                    }
                    if (!(incaux > maxaux) || path.get(i) == fixed) continue;
                    maxaux = incaux;
                    index = i;
                }
                path.remove(index);
                size = path.size();
            }
        }
        return path;
    }
}

