/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vrp.planning;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JPanel;
import javax.vecmath.Point2d;
import pt.lsts.neptus.plugins.vrp.planning.CHull;

class DrawPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    DrawPanel() {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int size = 60;
        int rad = 4;
        Random r = new Random();
        ArrayList<Point2d> array = new ArrayList<Point2d>(size);
        for (int i = 0; i < size; ++i) {
            double x = (double)r.nextInt(350) + 15.23453;
            double y = (double)r.nextInt(350) + 15.345345;
            array.add(new Point2d(x, y));
            g2.draw(new Ellipse2D.Double(x - 2.0, y - 2.0, rad, rad));
        }
        Collections.sort(array, new Comparator<Point2d>(){

            @Override
            public int compare(Point2d pt1, Point2d pt2) {
                double r = pt1.x - pt2.x;
                if (r != 0.0) {
                    if (r < 0.0) {
                        return -1;
                    }
                    return 1;
                }
                if (pt1.y - pt2.y < 0.0) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList<Point2d> hull = CHull.cHull(array);
        Iterator<Point2d> itr = hull.iterator();
        Point2d prev = itr.next();
        Point2d curr = null;
        while (itr.hasNext()) {
            curr = itr.next();
            g2.drawLine((int)prev.x, (int)prev.y, (int)curr.x, (int)curr.y);
            prev = curr;
        }
        curr = hull.get(0);
        g2.drawLine((int)prev.x, (int)prev.y, (int)curr.x, (int)curr.y);
        Point2d base = hull.get(0);
        hull = CHull.resizePath(4, hull, array, hull.get(0));
        itr = hull.iterator();
        prev = itr.next();
        curr = null;
        g2.setColor(Color.RED);
        g2.draw(new Ellipse2D.Double(base.x, base.y, rad, rad));
        while (itr.hasNext()) {
            curr = itr.next();
            g2.drawLine((int)prev.x, (int)prev.y, (int)curr.x, (int)curr.y);
            prev = curr;
        }
        curr = hull.get(0);
        g2.drawLine((int)prev.x, (int)prev.y, (int)curr.x, (int)curr.y);
    }
}

