/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vrp.planning;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point2d;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vrp.planning.VrpManager;

public class VrpFrame
extends JFrame {
    private static final long serialVersionUID = -3268652136882271864L;

    public VrpFrame() {
        this.setSize(400, 400);
        this.setLocation(100, 100);
        this.setDefaultCloseOperation(3);
        int size = 70;
        Vector<Point2d> array = new Vector<Point2d>(size);
        double x = 20.23453;
        double y = 20.345345;
        Point2d depot = new Point2d(x, y);
        for (int i = 0; i < size; ++i) {
            Random r = new Random();
            x = (double)r.nextInt(350) + 15.23453;
            y = (double)r.nextInt(350) + 15.345345;
            array.add(new Point2d(x, y));
        }
        long time = System.nanoTime();
        Vector<Vector<Point2d>> paths = VrpManager.computePathsSingleDepot(depot, array, 5);
        long time2 = System.nanoTime();
        NeptusLog.pub().info((Object)("<###>Time:" + (double)(time2 - time) * 1.0E-9));
        VrpDrawPanel dp = new VrpDrawPanel(depot, array, paths);
        Container cp = this.getContentPane();
        cp.add(dp);
    }

    public static void main(String[] args) {
        VrpFrame frame = new VrpFrame();
        frame.setVisible(true);
    }

    public class VrpDrawPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Color[] colors = new Color[]{Color.black, Color.green, Color.yellow, Color.red, Color.blue, Color.gray, Color.orange, Color.pink};
        Point2d depot;
        Vector<Point2d> array;
        Vector<Vector<Point2d>> paths;

        public VrpDrawPanel(Point2d d, Vector<Point2d> a, Vector<Vector<Point2d>> p) {
            this.depot = d;
            this.array = a;
            this.paths = p;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int rad = 4;
            Graphics2D g2 = (Graphics2D)g;
            for (Point2d p : this.array) {
                g2.draw(new Ellipse2D.Double(p.x - 2.0, p.y - 2.0, rad, rad));
            }
            int i = 0;
            for (Vector<Point2d> path : this.paths) {
                g2.setColor(this.colors[i++]);
                Iterator<Point2d> itr = path.iterator();
                Point2d prev = itr.next();
                g2.drawLine((int)this.depot.x, (int)this.depot.y, (int)prev.x, (int)prev.y);
                Point2d curr = null;
                while (itr.hasNext()) {
                    curr = itr.next();
                    g2.drawLine((int)prev.x, (int)prev.y, (int)curr.x, (int)curr.y);
                    prev = curr;
                }
            }
        }
    }
}

