/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vrp.planning;

import drasys.or.graph.DuplicateVertexException;
import drasys.or.graph.EdgeI;
import drasys.or.graph.MatrixGraph;
import drasys.or.graph.PointGraph;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ThreeOpt;
import drasys.or.graph.tsp.TwoOpt;
import drasys.or.graph.tsp.Us;
import drasys.or.graph.vrp.BestOf;
import drasys.or.graph.vrp.ClarkeWright;
import drasys.or.graph.vrp.Composite;
import drasys.or.graph.vrp.ImproveWithTSP;
import drasys.or.graph.vrp.SolutionNotFoundException;
import drasys.or.graph.vrp.VRPException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Point2d;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vrp.planning.CHull;
import pt.lsts.neptus.plugins.vrp.planning.Customer;
import pt.lsts.neptus.plugins.vrp.planning.PointIdoubleI;

public class VrpManager {
    Customer[] customers = null;
    public static double dist = 0.0;

    public static Vector<Vector<Point2d>> computePathsSingleDepot(Point2d depot, Vector<Point2d> pointList, int n_vehicles) {
        Vector<Vector<Point2d>> returnVector = new Vector<Vector<Point2d>>();
        int sizeVisitPoints = pointList.size();
        PointGraph pointGraph = new PointGraph();
        PointIdoubleI[] arrayVRP = new PointIdoubleI[sizeVisitPoints + 1];
        String key = "Depot";
        arrayVRP[0] = new PointIdoubleI(1.0, depot);
        try {
            pointGraph.addVertex(key, arrayVRP[0]);
        }
        catch (DuplicateVertexException e) {
            e.printStackTrace();
        }
        try {
            for (int i = 1; i < sizeVisitPoints + 1; ++i) {
                pointGraph.addVertex(new Integer(i), new PointIdoubleI(1.0, pointList.get(i - 1)));
            }
        }
        catch (DuplicateVertexException e) {
            e.printStackTrace();
        }
        MatrixGraph graph = new MatrixGraph(pointGraph, null);
        graph.setSymmetric(false);
        BestOf bestOf = new BestOf();
        int iterations = 10;
        int strength = 4;
        TwoOpt subalgorithm = new TwoOpt();
        try {
            bestOf.addConstruct(new ClarkeWright(iterations, strength, subalgorithm));
        }
        catch (VRPException e) {
            e.printStackTrace();
        }
        ImproveWithTSP improve = new ImproveWithTSP(new ThreeOpt());
        Composite vrp = new Composite(bestOf, improve);
        vrp.setCostConstraint(Double.MAX_VALUE);
        vrp.setCapacityConstraint(5000.0);
        vrp.setGraph(graph);
        Vector[] tours = null;
        try {
            NeptusLog.pub().debug((Object)"solver called");
            vrp.constructClosedTours("Depot");
            NeptusLog.pub().debug((Object)"passed");
            tours = vrp.getTours();
        }
        catch (SolutionNotFoundException e) {
            NeptusLog.pub().debug((Object)"solution not found");
            e.printStackTrace();
        }
        catch (VertexNotFoundException e) {
            NeptusLog.pub().debug((Object)"vertex not found");
            e.printStackTrace();
        }
        double meters = 0.0;
        if (n_vehicles == tours.length) {
            NeptusLog.pub().info((Object)"solved - One path for each vehicle");
        }
        for (int i = 0; i < tours.length; ++i) {
            Vector<Point2d> path = new Vector<Point2d>();
            Enumeration e = tours[i].elements();
            e.nextElement();
            while (e.hasMoreElements()) {
                EdgeI edge = (EdgeI)e.nextElement();
                PointIdoubleI customer1 = (PointIdoubleI)edge.getToVertex().getValue();
                PointIdoubleI customer2 = (PointIdoubleI)edge.getFromVertex().getValue();
                meters += customer1.distanceTo(customer2);
                path.add(customer1.getPoint2d());
                e.nextElement();
            }
            returnVector.add(path);
        }
        String msg = "Vehicles - " + tours.length + ", ";
        msg = msg + "Distance(Km) - " + meters / 1000.0;
        NeptusLog.pub().info((Object)msg);
        dist = meters;
        double rangeConstraint = meters;
        double step = rangeConstraint / (double)n_vehicles;
        rangeConstraint -= step;
        int last = -1;
        while (returnVector.size() != n_vehicles) {
            vrp.setCostConstraint(rangeConstraint);
            NeptusLog.pub().debug((Object)("range:" + rangeConstraint));
            NeptusLog.pub().debug((Object)("step:" + step));
            NeptusLog.pub().debug((Object)("Vehicles:" + returnVector.size()));
            NeptusLog.pub().debug((Object)("Last:" + last));
            try {
                NeptusLog.pub().debug((Object)"solver was called");
                vrp.constructClosedTours("Depot");
                NeptusLog.pub().debug((Object)"passed");
                tours = vrp.getTours();
                if (last == 0) {
                    last = 1;
                }
            }
            catch (SolutionNotFoundException e) {
                NeptusLog.pub().debug((Object)"solution not found : increasing distance");
                if (last != 0) {
                    step /= 2.0;
                }
                rangeConstraint += step;
                last = 0;
            }
            catch (VertexNotFoundException e) {
                NeptusLog.pub().debug((Object)"Vertex not found");
                e.printStackTrace();
            }
            returnVector.clear();
            for (int i = 0; i < tours.length; ++i) {
                Vector<Point2d> path = new Vector<Point2d>();
                Enumeration e = tours[i].elements();
                e.nextElement();
                while (e.hasMoreElements()) {
                    EdgeI edge = (EdgeI)e.nextElement();
                    PointIdoubleI customer1 = (PointIdoubleI)edge.getToVertex().getValue();
                    PointIdoubleI customer2 = (PointIdoubleI)edge.getFromVertex().getValue();
                    meters += customer1.distanceTo(customer2);
                    path.add(customer1.getPoint2d());
                    e.nextElement();
                }
                returnVector.add(path);
            }
            if (last == 0) continue;
            if (returnVector.size() > n_vehicles) {
                if (last < 0) {
                    step /= 2.0;
                }
                rangeConstraint += step;
                last = 1;
            }
            if (returnVector.size() >= n_vehicles) continue;
            if (last > 0) {
                step /= 2.0;
            }
            rangeConstraint -= step;
            last = -1;
        }
        dist = meters;
        return returnVector;
    }

    public static Vector<Vector<Point2d>> computePathsSingleDepot3(Point2d depot, Vector<Point2d> pointList, int n_vehicles) {
        int x;
        int i;
        int sizeVisitPoints = pointList.size();
        PointGraph pointGraph = new PointGraph();
        PointIdoubleI[] arrayVRP = new PointIdoubleI[sizeVisitPoints + 1];
        ArrayList<Point2d> arrayCHull = new ArrayList<Point2d>(sizeVisitPoints + 1);
        arrayCHull.add(0, depot);
        for (i = 1; i <= sizeVisitPoints; ++i) {
            arrayCHull.add(i, pointList.get(i - 1));
        }
        Collections.sort(arrayCHull, new Comparator<Point2d>(){

            @Override
            public int compare(Point2d pt1, Point2d pt2) {
                double r = pt1.x - pt2.x;
                if (r != 0.0) {
                    if (r < 0.0) {
                        return -1;
                    }
                    return 1;
                }
                if (pt1.y - pt2.y < 0.0) {
                    return -1;
                }
                return 1;
            }
        });
        for (i = 0; i <= sizeVisitPoints; ++i) {
            if (arrayCHull.get(i) != depot) continue;
            NeptusLog.pub().info((Object)"found depot");
        }
        ArrayList<Point2d> hull = CHull.cHull(arrayCHull);
        boolean depot_out_hull = false;
        for (int i2 = 0; i2 < hull.size(); ++i2) {
            if (hull.get(i2) != depot) continue;
            depot_out_hull = true;
        }
        Object key = "Depot";
        arrayVRP[0] = new PointIdoubleI(0.0, depot);
        try {
            pointGraph.addVertex(key, arrayVRP[0]);
        }
        catch (DuplicateVertexException e) {
            e.printStackTrace();
        }
        if (depot_out_hull) {
            NeptusLog.pub().debug((Object)"depot is out");
            hull = CHull.resizePath(n_vehicles + 1, hull, arrayCHull, depot);
            try {
                for (int i3 = 1; i3 < sizeVisitPoints + 1; ++i3) {
                    arrayVRP = new PointIdoubleI[sizeVisitPoints + 1];
                    key = new Integer(i3);
                    arrayVRP[i3] = new PointIdoubleI(0.0, pointList.get(i3 - 1));
                    for (x = 0; x < hull.size(); ++x) {
                        if (hull.get(x) != arrayVRP[i3].getPoint2d()) continue;
                        NeptusLog.pub().debug((Object)"found listpoint in hull");
                        arrayVRP[i3].setLoad(1.0);
                    }
                    pointGraph.addVertex(key, arrayVRP[i3]);
                }
            }
            catch (DuplicateVertexException e) {
                e.printStackTrace();
            }
        } else {
            NeptusLog.pub().debug((Object)"depot is in");
            hull = CHull.resizePath(n_vehicles, hull, arrayCHull, null);
            arrayVRP = new PointIdoubleI[sizeVisitPoints + 1];
            try {
                for (int i4 = 1; i4 < sizeVisitPoints + 1; ++i4) {
                    key = new Integer(i4);
                    arrayVRP[i4] = new PointIdoubleI(0.0, pointList.get(i4 - 1));
                    for (x = 0; x < hull.size(); ++x) {
                        if (hull.get(x) != arrayVRP[i4].getPoint2d()) continue;
                        NeptusLog.pub().debug((Object)"found listpoint in hull");
                        arrayVRP[i4].setLoad(1.0);
                    }
                    pointGraph.addVertex(key, arrayVRP[i4]);
                }
            }
            catch (DuplicateVertexException e) {
                e.printStackTrace();
            }
        }
        MatrixGraph graph = new MatrixGraph(pointGraph, null);
        graph.setSymmetric(false);
        BestOf bestOf = new BestOf();
        int iterations = 10;
        int strength = 4;
        Us subalgorithm = new Us(5);
        try {
            bestOf.addConstruct(new ClarkeWright(iterations, strength, subalgorithm));
        }
        catch (VRPException e) {
            e.printStackTrace();
        }
        ImproveWithTSP improve = new ImproveWithTSP(new ThreeOpt());
        Composite vrp = new Composite(bestOf, improve);
        vrp.setCostConstraint(Double.MAX_VALUE);
        vrp.setCapacityConstraint(1.0);
        vrp.setGraph(graph);
        Vector[] tours = null;
        try {
            NeptusLog.pub().debug((Object)"solver called");
            vrp.constructClosedTours("Depot");
            NeptusLog.pub().debug((Object)"passed");
            tours = vrp.getTours();
        }
        catch (SolutionNotFoundException e) {
            e.printStackTrace();
        }
        catch (VertexNotFoundException e) {
            e.printStackTrace();
        }
        if (n_vehicles == tours.length) {
            NeptusLog.pub().debug((Object)"Solved - One path for each vehicle");
        }
        Vector<Vector<Point2d>> returnVector = new Vector<Vector<Point2d>>();
        for (int i5 = 0; i5 < tours.length; ++i5) {
            Vector<Point2d> path = new Vector<Point2d>();
            Enumeration e = tours[i5].elements();
            e.nextElement();
            while (e.hasMoreElements()) {
                EdgeI edge = (EdgeI)e.nextElement();
                PointIdoubleI customer1 = (PointIdoubleI)edge.getToVertex().getValue();
                path.add(customer1.getPoint2d());
                e.nextElement();
            }
            returnVector.add(path);
        }
        if (returnVector.size() != n_vehicles) {
            return null;
        }
        return returnVector;
    }

    public static int totalDist(Vector<?>[] tours) throws SolutionNotFoundException {
        int meters = 0;
        for (int i = 0; i < tours.length; ++i) {
            Enumeration<?> e = tours[i].elements();
            e.nextElement();
            while (e.hasMoreElements()) {
                EdgeI edge = (EdgeI)e.nextElement();
                Customer customer1 = (Customer)edge.getToVertex().getValue();
                Customer customer2 = (Customer)edge.getFromVertex().getValue();
                meters = (int)((double)meters + customer1.distanceTo(customer2));
                e.nextElement();
            }
        }
        return meters;
    }
}

