/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.protocol.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URL;

public class DataResourceConnection
extends ResourceConnection {
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private static final String BASE_64 = "base64";
    private static final String CHARSET_PARAM = "charset";
    private byte[] data;
    private ArrayList headers = new ArrayList();
    private HashMap header_map = new HashMap();
    private String content_type = "text/plain";
    private String encoding = "US-ASCII";
    private int content_length = -1;

    protected DataResourceConnection(String string) throws MalformedURLException {
        super((URI)new URL("data:" + string));
        this.parseContent(string);
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
        return byteArrayInputStream;
    }

    public String getContentType() {
        return this.content_type;
    }

    public void connect() throws IOException {
    }

    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            this.content_length = -1;
        }
        return this.content_length;
    }

    public String getContentEncoding() {
        return this.encoding;
    }

    public String getHeaderField(int n) {
        String string = null;
        if (n < this.headers.size()) {
            string = (String)this.headers.get(n);
        }
        return string;
    }

    public String getHeaderField(String string) {
        return (String)this.header_map.get(string);
    }

    private void addParam(String string) {
        this.headers.add(string);
        int n = string.indexOf(61);
        if (string.startsWith(CHARSET_PARAM)) {
            this.encoding = string.substring(n + 1);
        }
        this.header_map.put(string.substring(0, n), string.substring(n + 1));
    }

    private void parseContent(String string) {
        int n = string.indexOf(44);
        if (n != 0) {
            boolean bl = false;
            String string2 = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            try {
                String string3 = stringTokenizer.nextToken();
                if (string3.indexOf(61) == -1) {
                    if (string3.equalsIgnoreCase(BASE_64)) {
                        this.encoding = BASE_64;
                        bl = true;
                    } else {
                        this.content_type = string3;
                    }
                } else {
                    this.addParam(string3);
                }
                while (!bl && stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3.equalsIgnoreCase(BASE_64)) {
                        this.encoding = BASE_64;
                        bl = true;
                        continue;
                    }
                    this.addParam(string3);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        try {
            String string4 = string.substring(n + 1);
            string4 = URLDecoder.decode(string4);
            this.data = string4.getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.content_type.equals(DEFAULT_CONTENT_TYPE)) {
            this.content_length = this.data.length;
        }
    }
}

