/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.resolve.file;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.ietf.uri.URN;
import org.ietf.uri.UnresolvableURIException;
import org.ietf.uri.UnsupportedServiceException;
import org.ietf.uri.resolve.UnknownNIDException;
import vlc.net.resolve.file.GroupResource;
import vlc.net.resolve.file.InvalidRegexException;
import vlc.net.resolve.file.NoSuchGroupException;

public class NamespaceResolver {
    private String nid;
    private RE grp_regex;
    private String replacement;
    private HashMap groups_list;
    private GroupResource current_group;

    public NamespaceResolver(String string) {
        this.nid = string;
        this.groups_list = new HashMap();
    }

    String getNID() {
        return this.nid;
    }

    void setNidRegex(String string) throws InvalidRegexException {
        boolean bl = true;
        char c = string.charAt(0);
        String string2 = "^" + c + "(.*)" + c + "(.*)" + c + "(.*)" + "$";
        try {
            RE rE = new RE((Object)string2, 0, RESyntax.RE_SYNTAX_POSIX_EXTENDED);
            REMatch[] rEMatchArray = rE.getAllMatches((Object)string);
            if (rEMatchArray.length == 0) {
                System.out.println("Invalid RE syntax");
                throw new InvalidRegexException("Invalid pattern");
            }
            string = rEMatchArray[0].substituteInto("$1");
            this.replacement = rEMatchArray[0].substituteInto("$2");
            String string3 = rEMatchArray[0].substituteInto("$3");
            boolean bl2 = string3 != null && string3.equals("i");
            this.grp_regex = bl2 ? new RE((Object)string, 0, RESyntax.RE_SYNTAX_POSIX_EXTENDED) : new RE((Object)string, 2, RESyntax.RE_SYNTAX_POSIX_EXTENDED);
            int n = this.replacement.length();
            char[] cArray = new char[n];
            this.replacement.getChars(0, n, cArray, 0);
            --n;
            for (int i = 0; i < n; ++i) {
                if (cArray[i] != '\\') continue;
                if (!Character.isDigit(cArray[i + 1]) || cArray[i + 1] == '0') {
                    throw new InvalidRegexException("Illegal Back reference of '" + cArray[i + 1] + "'");
                }
                cArray[i] = 36;
            }
            this.replacement = String.valueOf(cArray);
        }
        catch (REException rEException) {
            System.out.println("Exception: " + (Object)((Object)rEException));
        }
    }

    void addGroup(String string) {
        if (string == null) {
            throw new NullPointerException("Empty group list");
        }
        GroupResource groupResource = new GroupResource(string);
        this.groups_list.put(string, groupResource);
        this.current_group = groupResource;
    }

    void addResource(String string, String string2) throws NoSuchGroupException, InvalidRegexException {
        if (this.current_group == null) {
            throw new NoSuchGroupException();
        }
        this.current_group.addResource(string, string2);
    }

    public String decode(URN uRN) throws UnknownNIDException, UnresolvableURIException {
        String string = uRN.getNamespace();
        if (!this.nid.equals(string)) {
            throw new UnsupportedServiceException();
        }
        string = this.extractGroupName(uRN.toExternalForm());
        GroupResource groupResource = (GroupResource)this.groups_list.get(string);
        if (groupResource == null) {
            throw new UnknownNIDException();
        }
        String string2 = null;
        try {
            string2 = groupResource.resolveSingle(uRN.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnresolvableURIException();
        }
        return string2;
    }

    public String[] decodeList(URN uRN) throws UnknownNIDException {
        String string = uRN.getNamespace();
        if (!this.nid.equals(string)) {
            throw new UnsupportedServiceException();
        }
        string = this.extractGroupName(uRN.toExternalForm());
        GroupResource groupResource = (GroupResource)this.groups_list.get(string);
        if (groupResource == null) {
            throw new UnknownNIDException();
        }
        String[] stringArray = groupResource.resolveAll(uRN.toExternalForm());
        return stringArray;
    }

    private String extractGroupName(String string) {
        REMatch rEMatch = this.grp_regex.getMatch((Object)string);
        return rEMatch.substituteInto(this.replacement);
    }

    public String toString() {
        return "Namespace resolver for " + this.nid;
    }
}

