/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.resolve.thttp;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import org.ietf.uri.HttpResourceConnection;
import org.ietf.uri.MalformedURNException;
import org.ietf.uri.NoURNBindingsException;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URIResourceFactory;
import org.ietf.uri.URL;
import org.ietf.uri.URN;
import org.ietf.uri.URNResolverService;
import org.ietf.uri.UnsupportedServiceException;
import org.ietf.uri.resolve.ConfigErrorException;
import org.ietf.uri.resolve.UnknownNIDException;
import vlc.net.resolve.thttp.FileParser;
import vlc.net.resolve.thttp.NamespaceResolver;
import vlc.net.resolve.thttp.ResourceDescriptor;

public class Resolver
implements URNResolverService {
    private static final String SERVER_FILE = "thttp_urn.conf";
    private static final String URN_SERVER_PROP = "urn.resolver.thttp.servers";
    private static final String URN_SYSTEM_PROP = "urn.resolver.thttp.path";
    private static final String INVALID_RESPONSE = "The server sent an Invalid response code for THTTP Queries";
    private static HashMap namespace_resolvers;
    private URIResourceFactory resource_factory = null;

    public void init() throws ConfigErrorException {
        try {
            InputStream inputStream = null;
            String string = System.getProperty(URN_SYSTEM_PROP);
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                if (!string.endsWith("/")) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(SERVER_FILE);
                java.net.URL uRL = new java.net.URL(stringBuffer.toString());
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                uRLConnection.getContentType();
                uRLConnection.getContentEncoding();
                uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
            } else {
                inputStream = ClassLoader.getSystemResourceAsStream(SERVER_FILE);
            }
            if (inputStream != null) {
                namespace_resolvers = FileParser.parseBindingsFile(inputStream);
                inputStream.close();
            } else {
                namespace_resolvers = new HashMap();
            }
        }
        catch (IOException iOException) {
            throw new NoURNBindingsException("Static init URN Bindings:\n" + iOException);
        }
    }

    public boolean checkService(int n) {
        return n != 9 && n != 5 && n != 6;
    }

    public boolean canResolve(String string) {
        String string2 = System.getProperty(URN_SYSTEM_PROP);
        if (string2 != null) {
            return true;
        }
        return namespace_resolvers.get(string) != null;
    }

    public void setResourceFactory(URIResourceFactory uRIResourceFactory) {
        this.resource_factory = uRIResourceFactory;
    }

    private Object getI2LResponse(HttpResourceConnection httpResourceConnection) throws IOException, MalformedURLException {
        URL uRL = null;
        HttpResourceConnection.setFollowRedirects((boolean)false);
        httpResourceConnection.connect();
        int n = httpResourceConnection.getResponseCode();
        if (n / 100 != 3) {
            throw new IOException(INVALID_RESPONSE);
        }
        String string = httpResourceConnection.getHeaderField("Location");
        uRL = new URL(string);
        return uRL;
    }

    private Object getI2LsResponse(HttpResourceConnection httpResourceConnection) throws IOException, MalformedURLException {
        URL[] uRLArray = null;
        HttpResourceConnection.setFollowRedirects((boolean)false);
        httpResourceConnection.connect();
        int n = httpResourceConnection.getResponseCode();
        if (n / 100 != 2) {
            throw new IOException(INVALID_RESPONSE);
        }
        String string = httpResourceConnection.getContentType();
        if (string.equals("text/uri-list")) {
            String[] stringArray = (String[])httpResourceConnection.getContent();
            if (stringArray == null || stringArray.length == 0) {
                throw new IOException(INVALID_RESPONSE);
            }
            ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    arrayList.add(new URL(stringArray[i]));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            URL[] uRLArray2 = new URL[]{};
            uRLArray = arrayList.toArray(uRLArray2);
        } else if (string.equals("text/html") || string.equals("application/html")) {
            System.out.println("Got a HTML THTTP Response!");
        }
        return uRLArray;
    }

    private Object getI2RResponse(HttpResourceConnection httpResourceConnection) throws IOException, MalformedURLException {
        HttpResourceConnection.setFollowRedirects((boolean)true);
        return httpResourceConnection;
    }

    private Object getI2RsResponse(HttpResourceConnection httpResourceConnection) throws IOException, MalformedURLException {
        HttpResourceConnection.setFollowRedirects((boolean)true);
        ResourceConnection[] resourceConnectionArray = new ResourceConnection[]{httpResourceConnection};
        return resourceConnectionArray;
    }

    private Object getI2NsResponse(HttpResourceConnection httpResourceConnection) throws IOException, MalformedURLException {
        URN[] uRNArray = null;
        HttpResourceConnection.setFollowRedirects((boolean)false);
        httpResourceConnection.connect();
        int n = httpResourceConnection.getResponseCode();
        if (n / 100 != 2) {
            throw new IOException(INVALID_RESPONSE);
        }
        String string = httpResourceConnection.getContentType();
        if (string.equals("text/uri-list")) {
            String[] stringArray = (String[])httpResourceConnection.getContent();
            if (stringArray == null || stringArray.length == 0) {
                throw new IOException(INVALID_RESPONSE);
            }
            ArrayList<URN> arrayList = new ArrayList<URN>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    arrayList.add(new URN(stringArray[i]));
                    continue;
                }
                catch (MalformedURNException malformedURNException) {
                    // empty catch block
                }
            }
            URN[] uRNArray2 = new URN[]{};
            uRNArray = arrayList.toArray(uRNArray2);
        } else if (string.equals("text/html") || string.equals("application/html")) {
            System.out.println("Got a HTML THTTP Response!");
        }
        return uRNArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(URN uRN, int n) throws UnsupportedServiceException {
        String string = uRN.getNamespace();
        NamespaceResolver namespaceResolver = (NamespaceResolver)namespace_resolvers.get(string);
        Object object = null;
        if (namespaceResolver != null) {
            try {
                ResourceDescriptor resourceDescriptor = namespaceResolver.decode(uRN, n);
                ResourceConnection resourceConnection = null;
                StringBuffer stringBuffer = resourceDescriptor.path;
                synchronized (stringBuffer) {
                    resourceDescriptor.path.append(uRN.toExternalForm());
                    int n2 = resourceDescriptor.path.length();
                    resourceConnection = this.resource_factory.requestResource("http", resourceDescriptor.server, resourceDescriptor.port, resourceDescriptor.path.toString());
                    resourceDescriptor.path.delete(resourceDescriptor.pathLength, n2);
                }
                stringBuffer = (HttpResourceConnection)resourceConnection;
                switch (n) {
                    case 1: {
                        object = this.getI2LResponse((HttpResourceConnection)stringBuffer);
                        break;
                    }
                    case 2: {
                        object = this.getI2LsResponse((HttpResourceConnection)stringBuffer);
                        break;
                    }
                    case 3: {
                        object = this.getI2RResponse((HttpResourceConnection)stringBuffer);
                        break;
                    }
                    case 4: {
                        object = this.getI2RsResponse((HttpResourceConnection)stringBuffer);
                        break;
                    }
                    case 7: {
                        object = uRN;
                        break;
                    }
                    case 8: {
                        object = this.getI2NsResponse((HttpResourceConnection)stringBuffer);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (UnknownNIDException unknownNIDException) {}
        } else {
            System.out.println("Null namespace resolver - not good!");
        }
        return object;
    }

    public Object[] decodeList(URN uRN, int n) throws UnsupportedServiceException {
        String string = uRN.getNamespace();
        return null;
    }
}

