/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.browser;

import javax.swing.JLabel;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.util.ErrorReporter;

public class DownloadProgressListener
implements ProgressListener {
    private JLabel statusLabel;
    private ErrorReporter reporter;

    public DownloadProgressListener(JLabel jLabel, ErrorReporter errorReporter) {
        this.statusLabel = jLabel;
        this.reporter = errorReporter;
    }

    public void connectionEstablished(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void handshakeInProgress(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void downloadStarted(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void downloadUpdate(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        URI uRI = resourceConnection.getURI();
        StringBuffer stringBuffer = new StringBuffer(uRI.toExternalForm());
        stringBuffer.append(" (");
        stringBuffer.append(progressEvent.getValue());
        stringBuffer.append(")");
        this.statusLabel.setText(stringBuffer.toString());
    }

    public void downloadEnded(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        URI uRI = resourceConnection.getURI();
        String string = uRI.toExternalForm() + " complete.";
        this.statusLabel.setText(string);
        this.reporter.messageReport(string);
    }

    public void downloadError(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
        this.reporter.errorReport(progressEvent.getMessage(), null);
    }
}

