/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;

public class SwingConsoleWindow
extends JFrame
implements ActionListener,
ErrorHandler {
    private JTextArea errorField;
    private JButton clearButton;
    private Locator docLocator;

    public SwingConsoleWindow() {
        super("Xj3D Console");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.errorField = new JTextArea(20, 60);
        JScrollPane jScrollPane = new JScrollPane(this.errorField);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        container.add((Component)jPanel, "South");
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(this);
        jPanel.add(this.clearButton);
        this.setSize(600, 400);
        this.setLocation(80, 80);
        this.messageReport("Xj3D Version: 1_0\n");
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public void partialReport(String string) {
        this.errorField.append(string);
    }

    public void messageReport(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('\n');
        this.errorField.append(stringBuffer.toString());
    }

    public void warningReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Warning: ");
        if (this.docLocator != null) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append(exception.getMessage());
                stringBuffer.append('\n');
            } else {
                stringBuffer.append("No message provided\n");
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void errorReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Error: ");
        if (this.docLocator != null) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append(exception.getMessage());
                stringBuffer.append('\n');
            } else {
                stringBuffer.append(exception.toString());
            }
            exception.getStackTrace();
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void fatalErrorReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Fatal Error: ");
        if (this.docLocator != null) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append(exception.getMessage());
                stringBuffer.append('\n');
            } else {
                stringBuffer.append("No message provided\n");
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clearButton) {
            this.errorField.setText("");
        }
    }
}

