/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.browser;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class TextAreaOutputStream
extends OutputStream {
    private JTextArea ta;
    private String name;

    public TextAreaOutputStream(String string, JTextArea jTextArea) {
        this.name = string;
        this.ta = jTextArea;
    }

    private void autoScroll() {
        try {
            int n = this.ta.getLineCount();
            Rectangle rectangle = this.ta.modelToView(n - 1);
            if (rectangle != null) {
                rectangle.y = n * rectangle.height;
                this.ta.scrollRectToVisible(rectangle);
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Bad location in console window");
        }
    }

    public void write(int n) throws IOException {
        this.ta.append(String.valueOf((char)n));
        this.autoScroll();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 2) {
            this.ta.append(this.name);
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }
}

