/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.j3d.ui.navigation.ViewpointData;
import org.j3d.ui.navigation.ViewpointSelectionListener;
import org.j3d.util.ImageLoader;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.ViewpointCellRenderer;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;

public class ViewpointToolbar
extends JPanel
implements ActionListener,
ItemListener,
ViewpointStatusListener,
NavigationStateListener {
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private static final String DEFAULT_HOME_BUTTON = "images/navigation/ButtonHome.gif";
    private static final String DEFAULT_FITWORLD_BUTTON = "images/navigation/ButtonFit.gif";
    private static final String DEFAULT_LOOKAT_BUTTON = "images/navigation/ButtonLookat.gif";
    private static final String DEFAULT_NEXT_BUTTON = "images/navigation/ButtonForward.gif";
    private static final String DEFAULT_PREV_BUTTON = "images/navigation/ButtonBack.gif";
    private static final String HOME_BUTTON_PROPERTY = "HOME.button";
    private static final String FITWORLD_BUTTON_PROPERTY = "FITWORLD.button";
    private static final String LOOKAT_BUTTON_PROPERTY = "LOOKAT.button";
    private static final String NEXT_BUTTON_PROPERTY = "NEXTVIEW.button";
    private static final String PREVIOUS_BUTTON_PROPERTY = "PREVIOUSVIEW.button";
    private ViewpointSelectionListener viewpointListener;
    private JComboBox viewpoints;
    private DefaultComboBoxModel viewpointModel;
    private JButton nextViewpoint;
    private JButton prevViewpoint;
    private JButton homeViewpoint;
    private JButton fitworldViewpoint;
    private JButton lookatViewpoint;
    private ArrayList vdata;
    private boolean noInitialVPS;
    private VRMLViewpointNodeType defaultVP;
    private VRMLClock clock;
    private BrowserCore browserCore;

    public ViewpointToolbar() {
        this(null, null, DEFAULT_PROPERTIES);
    }

    public ViewpointToolbar(Properties properties) {
        this(null, null, properties);
    }

    public ViewpointToolbar(BrowserCore browserCore, Properties properties) {
        this(null, browserCore, properties);
    }

    public ViewpointToolbar(ViewpointData[] viewpointDataArray, BrowserCore browserCore, Properties properties) {
        this.browserCore = browserCore;
        this.vdata = new ArrayList();
        if (properties == null) {
            properties = DEFAULT_PROPERTIES;
        }
        this.viewpointModel = viewpointDataArray != null ? new DefaultComboBoxModel<ViewpointData>(viewpointDataArray) : new DefaultComboBoxModel();
        this.viewpoints = new JComboBox(this.viewpointModel);
        this.viewpoints.setRenderer(new ViewpointCellRenderer());
        this.viewpoints.setEditable(false);
        this.viewpoints.setLightWeightPopupEnabled(false);
        this.viewpoints.setMinimumSize(new Dimension(60, 10));
        this.viewpoints.setToolTipText("Select a Viewpoint");
        this.viewpoints.addItemListener(this);
        Icon icon = ImageLoader.loadIcon((String)properties.getProperty(NEXT_BUTTON_PROPERTY, DEFAULT_NEXT_BUTTON));
        this.nextViewpoint = new JButton(icon);
        this.nextViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.nextViewpoint.setToolTipText("Next Viewpoint");
        this.nextViewpoint.addActionListener(this);
        icon = ImageLoader.loadIcon((String)properties.getProperty(PREVIOUS_BUTTON_PROPERTY, DEFAULT_PREV_BUTTON));
        this.prevViewpoint = new JButton(icon);
        this.prevViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.prevViewpoint.setToolTipText("Previous Viewpoint");
        this.prevViewpoint.addActionListener(this);
        icon = ImageLoader.loadIcon((String)properties.getProperty(HOME_BUTTON_PROPERTY, DEFAULT_HOME_BUTTON));
        this.homeViewpoint = new JButton(icon);
        this.homeViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.homeViewpoint.addActionListener(this);
        this.homeViewpoint.setToolTipText("Return to current Viewpoint");
        icon = ImageLoader.loadIcon((String)properties.getProperty(LOOKAT_BUTTON_PROPERTY, DEFAULT_LOOKAT_BUTTON));
        this.lookatViewpoint = new JButton(icon);
        this.lookatViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.lookatViewpoint.addActionListener(this);
        this.lookatViewpoint.setToolTipText("LookAt");
        icon = ImageLoader.loadIcon((String)properties.getProperty(FITWORLD_BUTTON_PROPERTY, DEFAULT_FITWORLD_BUTTON));
        this.fitworldViewpoint = new JButton(icon);
        this.fitworldViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.fitworldViewpoint.addActionListener(this);
        this.fitworldViewpoint.setToolTipText("Fit to World");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.add(this.nextViewpoint);
        jPanel.add(this.homeViewpoint);
        jPanel.add(this.lookatViewpoint);
        jPanel.add(this.fitworldViewpoint);
        this.setLayout(new BorderLayout());
        this.add((Component)this.prevViewpoint, "West");
        this.add((Component)this.viewpoints, "Center");
        this.add((Component)jPanel, "East");
    }

    public void navigationStateChanged(int n) {
    }

    public void navigationListChanged(String[] stringArray, int n) {
        boolean bl = false;
        this.lookatViewpoint.setEnabled(false);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("ANY")) {
                bl = true;
                break;
            }
            String string = stringArray[i];
            if (!string.equals("LOOKAT")) continue;
            this.lookatViewpoint.setEnabled(true);
        }
        if (bl) {
            this.lookatViewpoint.setEnabled(true);
        }
    }

    public void clearViewpoints() {
        this.viewpointModel.removeAllElements();
        this.setEnabled(false);
    }

    public void setClock(VRMLClock vRMLClock) {
        this.clock = vRMLClock;
    }

    public void setViewpointSelectionListener(ViewpointSelectionListener viewpointSelectionListener) {
        this.viewpointListener = viewpointSelectionListener;
    }

    public void selectViewpoint(ViewpointData viewpointData) {
        this.viewpoints.setSelectedItem(viewpointData.userData);
    }

    public void nextViewpoint() {
        int n = this.viewpoints.getSelectedIndex();
        if (++n >= this.viewpoints.getItemCount()) {
            n = 0;
        }
        if (this.viewpointModel.getSize() > n) {
            this.viewpoints.setSelectedIndex(n);
        }
    }

    public void previousViewpoint() {
        int n = this.viewpoints.getSelectedIndex();
        if (--n < 0) {
            n = this.viewpoints.getItemCount() - 1;
        }
        if (this.viewpointModel.getSize() > n) {
            this.viewpoints.setSelectedIndex(n);
        }
    }

    public void firstViewpoint() {
        this.viewpoints.setSelectedIndex(0);
    }

    public void lastViewpoint() {
        int n = this.viewpoints.getItemCount() - 1;
        this.viewpoints.setSelectedIndex(n);
    }

    public void appendViewpoint(ViewpointData viewpointData) {
        this.viewpointModel.addElement(viewpointData.userData);
        if (this.viewpoints.getItemCount() == 1) {
            this.viewpoints.setSelectedIndex(0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.viewpoints.getSelectedIndex();
        if (object == this.nextViewpoint) {
            if (++n >= this.viewpoints.getItemCount()) {
                n = 0;
            }
            if (this.viewpointModel.getSize() > n) {
                this.viewpoints.setSelectedIndex(n);
            }
        } else if (object == this.prevViewpoint) {
            if (--n < 0) {
                n = this.viewpoints.getItemCount() - 1;
            }
            if (this.viewpointModel.getSize() > n) {
                this.viewpoints.setSelectedIndex(n);
            }
        } else if (object == this.homeViewpoint) {
            if (this.viewpointModel.getSize() > n) {
                VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)this.viewpoints.getSelectedItem();
                vRMLViewpointNodeType.setBind(true, true, this.clock.getTime());
                if (this.viewpointListener != null) {
                    ViewpointData viewpointData = new ViewpointData(vRMLViewpointNodeType.getDescription(), 0);
                    viewpointData.userData = vRMLViewpointNodeType;
                    this.viewpointListener.viewpointSelected(viewpointData);
                }
            }
        } else if (object == this.fitworldViewpoint) {
            if (this.browserCore != null) {
                this.browserCore.fitToWorld(false);
            }
        } else if (object == this.lookatViewpoint && this.browserCore != null) {
            this.browserCore.setNavigationMode("LOOKAT");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)this.viewpoints.getSelectedItem();
        vRMLViewpointNodeType.setBind(true, true, this.clock.getTime());
        if (this.viewpointListener != null) {
            ViewpointData viewpointData = new ViewpointData(vRMLViewpointNodeType.getDescription(), 0);
            viewpointData.userData = vRMLViewpointNodeType;
            this.viewpointListener.viewpointSelected(viewpointData);
        }
    }

    public void setEnabled(boolean bl) {
        this.viewpoints.setEnabled(bl);
        this.nextViewpoint.setEnabled(bl);
        this.prevViewpoint.setEnabled(bl);
        this.homeViewpoint.setEnabled(bl);
        this.fitworldViewpoint.setEnabled(bl);
        this.lookatViewpoint.setEnabled(bl);
    }

    public void viewpointAdded(VRMLViewpointNodeType vRMLViewpointNodeType, boolean bl) {
        if (bl) {
            this.defaultVP = vRMLViewpointNodeType;
            if (this.viewpointModel.getSize() > 0) {
                return;
            }
        }
        this.viewpointModel.addElement(vRMLViewpointNodeType);
        this.setEnabled(true);
    }

    public void viewpointRemoved(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.viewpointModel.removeElement(vRMLViewpointNodeType);
    }

    public void viewpointBound(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.viewpointModel.setSelectedItem(vRMLViewpointNodeType);
    }

    public void setNewViewpoints(VRMLViewpointNodeType vRMLViewpointNodeType, ArrayList arrayList) {
        this.noInitialVPS = arrayList.size() == 0;
        this.viewpointModel.removeAllElements();
        if (this.noInitialVPS) {
            this.viewpointModel.addElement(this.defaultVP);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            VRMLViewpointNodeType vRMLViewpointNodeType2 = (VRMLViewpointNodeType)iterator.next();
            this.viewpointAdded(vRMLViewpointNodeType2, vRMLViewpointNodeType2.equals(vRMLViewpointNodeType));
        }
        this.setEnabled(!this.noInitialVPS);
    }
}

