/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.browser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.web3d.util.BlockingQueue;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.browser.LoadDetails;

class AsyncWorldLoader
extends Thread {
    private static final String LOAD_URL_FAIL_MSG = "No valid URLs found for loadURL call.";
    private static final String CREATE_FAIL_MSG = "No valid URLs found for createVrmlFromURL call.";
    private static final String SET_FIELD_MSG = "Odd field error in createVrmlFromUrl";
    private ErrorReporter errorReporter;
    private boolean terminate;
    private BlockingQueue loadList;
    private boolean shutdownNow;

    AsyncWorldLoader(BlockingQueue blockingQueue) {
        super("Asynchronous World Loader");
        this.loadList = blockingQueue;
        this.shutdownNow = false;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void abortLoad() {
        this.terminate = true;
    }

    void shutdown() {
        this.terminate = true;
        this.shutdownNow = true;
    }

    public void run() {
        BasicScene basicScene = null;
        while (!this.shutdownNow) {
            Object object;
            LoadDetails loadDetails = (LoadDetails)this.loadList.getNext();
            WorldLoader worldLoader = loadDetails.worldLoader.fetchLoader();
            this.terminate = false;
            for (int i = 0; i < loadDetails.urls.length && !this.terminate; ++i) {
                String string;
                URL uRL;
                if (this.terminate) {
                    loadDetails.worldLoader.releaseLoader(worldLoader);
                    continue;
                }
                try {
                    uRL = new URL(loadDetails.urls[i]);
                    string = loadDetails.urls[i];
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        string = loadDetails.core.getWorldURL() + loadDetails.urls[i];
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        this.errorReporter.warningReport("Invalid URL: " + loadDetails.urls[i], null);
                        string = "<NONE>";
                        continue;
                    }
                }
                if (this.terminate) {
                    loadDetails.worldLoader.releaseLoader(worldLoader);
                    return;
                }
                object = new InputSource(uRL);
                try {
                    basicScene = worldLoader.loadNow(loadDetails.core, (InputSource)object, false, loadDetails.majorVersion, loadDetails.minorVersion);
                }
                catch (IOException iOException) {
                    this.errorReporter.warningReport("I/O Error loading " + string, iOException);
                }
                catch (VRMLParseException vRMLParseException) {
                    this.errorReporter.warningReport("VRML Parse exception loading " + string, vRMLParseException);
                }
                if (basicScene != null) break;
            }
            loadDetails.worldLoader.releaseLoader(worldLoader);
            if (basicScene == null) {
                String string = loadDetails.isLoadURL ? LOAD_URL_FAIL_MSG : CREATE_FAIL_MSG;
                this.errorReporter.warningReport(string, null);
                continue;
            }
            if (this.terminate) continue;
            if (loadDetails.isLoadURL) {
                loadDetails.core.setScene((VRMLScene)basicScene, null);
                continue;
            }
            VRMLNode vRMLNode = basicScene.getRootNode();
            object = (VRMLWorldRootNodeType)vRMLNode;
            VRMLNodeType[] vRMLNodeTypeArray = object.getChildren();
            object.setChildren((VRMLNodeType)null);
            ArrayList arrayList = basicScene.getRoutes();
            int n = arrayList.size();
            for (int i = 0; i < n && !this.terminate; ++i) {
                ROUTE rOUTE = (ROUTE)arrayList.get(i);
                loadDetails.routeManager.addRoute(loadDetails.space, rOUTE);
            }
            if (this.terminate) continue;
            try {
                loadDetails.targetNode.setValue(loadDetails.targetField, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
            }
            catch (VRMLException vRMLException) {
                this.errorReporter.errorReport(SET_FIELD_MSG, vRMLException);
            }
        }
    }
}

