/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.browser;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.scripting.browser.WorldLoaderThreadPool;
import org.web3d.vrml.util.URLChecker;

public abstract class CommonBrowser {
    private final String BROWSER_NAME;
    private static final String BROWSER_VERSION = "1_0";
    protected BrowserCore core;
    protected RouteManager routeManager;
    protected WorldLoaderManager loaderManager;
    protected WorldLoaderThreadPool loaderPool;
    protected FrameStateManager stateManager;
    protected ErrorReporter errorReporter;

    protected CommonBrowser(BrowserCore browserCore, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        if (browserCore == null) {
            throw new IllegalArgumentException("BrowserCore is null");
        }
        if (routeManager == null) {
            throw new IllegalArgumentException("RouteManager is null");
        }
        if (worldLoaderManager == null) {
            throw new IllegalArgumentException("WorldLoader is null");
        }
        if (frameStateManager == null) {
            throw new IllegalArgumentException("FrameStateManager is null");
        }
        this.core = browserCore;
        this.routeManager = routeManager;
        this.stateManager = frameStateManager;
        this.loaderManager = worldLoaderManager;
        this.loaderPool = WorldLoaderThreadPool.getLoaderThreadPool();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        switch (browserCore.getRendererType()) {
            case 1: {
                this.BROWSER_NAME = "Xj3D (Java3D renderer)";
                break;
            }
            case 2: {
                this.BROWSER_NAME = "Xj3D (Null renderer)";
                break;
            }
            case 3: {
                this.BROWSER_NAME = "Xj3D (OpenGL immersive renderer)";
                break;
            }
            case 4: {
                this.BROWSER_NAME = "Xj3D (OpenGL mobile renderer)";
                break;
            }
            default: {
                this.BROWSER_NAME = "Xj3D (Unknown renderer)";
            }
        }
    }

    public String getDescription() {
        return this.core.getDescription();
    }

    public void setDescription(String string) {
        this.core.setDescription(string);
    }

    public String getName() {
        return this.BROWSER_NAME;
    }

    public String getVersion() {
        return BROWSER_VERSION;
    }

    public float getCurrentSpeed() {
        return this.core.getCurrentSpeed();
    }

    public float getCurrentFrameRate() {
        return this.core.getCurrentFrameRate();
    }

    public String getWorldURL() {
        return this.core.getWorldURL();
    }

    public void addRoute(VRMLExecutionSpace vRMLExecutionSpace, VRMLNodeType vRMLNodeType, String string, VRMLNodeType vRMLNodeType2, String string2) throws InvalidFieldException {
        int n = vRMLNodeType.getFieldIndex(string);
        int n2 = vRMLNodeType2.getFieldIndex(string2);
        this.routeManager.addRoute(vRMLExecutionSpace, vRMLNodeType, n, vRMLNodeType2, n2);
    }

    public void deleteRoute(VRMLExecutionSpace vRMLExecutionSpace, VRMLNodeType vRMLNodeType, String string, VRMLNodeType vRMLNodeType2, String string2) throws InvalidFieldException {
        int n = vRMLNodeType.getFieldIndex(string);
        int n2 = vRMLNodeType2.getFieldIndex(string2);
        this.routeManager.removeRoute(vRMLExecutionSpace, vRMLNodeType, n, vRMLNodeType2, n2);
    }

    public void loadURL(String[] stringArray, Map map) {
        String string = this.core.getWorldURL();
        stringArray = this.completeUrl(stringArray);
        this.loaderPool.queueLoadURL(this.core, this.loaderManager, stringArray, map);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (this.errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.loaderPool.setErrorReporter(this.errorReporter);
    }

    protected String[] completeUrl(String[] stringArray) {
        String string = this.core.getWorldURL();
        String[] stringArray2 = null;
        String string2 = null;
        if (string == null) {
            try {
                string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                System.out.println("Error getting user.dir");
            }
            String string3 = "file:///" + string2 + "/";
            stringArray2 = URLChecker.checkURLs(string3, stringArray, false);
        } else {
            stringArray2 = URLChecker.checkURLs(string, stringArray, false);
        }
        return stringArray2;
    }
}

