/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.browser;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.web3d.browser.BrowserCore;
import org.web3d.util.BlockingQueue;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.scripting.browser.AsyncWorldLoader;
import org.web3d.vrml.scripting.browser.LoadDetails;

public class WorldLoaderThreadPool {
    private static final String THREAD_COUNT_PROP = "org.web3d.vrml.nodes.loader.threads";
    private static final int DEFAULT_THREAD_COUNT = 5;
    private BlockingQueue available = new BlockingQueue();
    private AsyncWorldLoader[] loaders;
    private static WorldLoaderThreadPool threadPool;

    private WorldLoaderThreadPool() {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger(WorldLoaderThreadPool.THREAD_COUNT_PROP, 5);
            }
        });
        int n2 = n;
        if (n2 <= 0) {
            n2 = 5;
        }
        if (n2 != 5) {
            System.out.println("org.web3d.vrml.nodes.loader.threads set to: " + n2);
        }
        this.loaders = new AsyncWorldLoader[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            this.loaders[n3] = new AsyncWorldLoader(this.available);
            this.loaders[n3].start();
        }
    }

    public static WorldLoaderThreadPool getLoaderThreadPool() {
        if (threadPool == null) {
            threadPool = new WorldLoaderThreadPool();
        }
        return threadPool;
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        for (int i = 0; i < this.loaders.length; ++i) {
            this.loaders[i].setErrorReporter(errorReporter);
        }
    }

    public void queueLoadURL(BrowserCore browserCore, WorldLoaderManager worldLoaderManager, String[] stringArray, Map map) {
        LoadDetails loadDetails = new LoadDetails();
        loadDetails.isLoadURL = true;
        loadDetails.core = browserCore;
        loadDetails.worldLoader = worldLoaderManager;
        loadDetails.urls = stringArray;
        loadDetails.params = map;
        int n = this.loaders.length;
        while (--n >= 0) {
            if (!this.loaders[n].isAlive()) {
                this.loaders[n] = new AsyncWorldLoader(this.available);
                this.loaders[n].start();
                continue;
            }
            this.loaders[n].abortLoad();
        }
        this.available.add(loadDetails);
    }

    public void queueCreateURL(BrowserCore browserCore, WorldLoaderManager worldLoaderManager, String[] stringArray, VRMLNodeType vRMLNodeType, int n, RouteManager routeManager, VRMLExecutionSpace vRMLExecutionSpace) {
        LoadDetails loadDetails = new LoadDetails();
        loadDetails.isLoadURL = false;
        loadDetails.core = browserCore;
        loadDetails.worldLoader = worldLoaderManager;
        loadDetails.urls = stringArray;
        loadDetails.targetNode = vRMLNodeType;
        loadDetails.targetField = n;
        loadDetails.routeManager = routeManager;
        loadDetails.space = vRMLExecutionSpace;
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        loadDetails.majorVersion = basicScene.getSpecificationMajorVersion();
        loadDetails.minorVersion = basicScene.getSpecificationMinorVersion();
        this.available.add(loadDetails);
    }

    public void shutdown() {
        int n = this.loaders.length;
        while (--n >= 0) {
            this.loaders[n].shutdown();
        }
    }
}

