/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.s57;

import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JDialog;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.tiles.MapPainterProvider;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.s57.S57;
import pt.lsts.s57.S57Factory;
import pt.lsts.s57.S57Query;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.entities.S57Object;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.painters.NeptusS57Painter;
import pt.lsts.s57.ui.MarinerControlsOptionsPanel;
import pt.lsts.s57.ui.OptionsDialog;
import pt.lsts.s57.ui.S57OptionsPanel;
import pt.lsts.s63.S63;
import pt.lsts.s63.ui.S63OptionsPanel;

@MapTileProvider(name="S57 Charts", usePropertiesOrCustomOptionsDialog=false, makeCustomOptionsDialogIndependent=true)
public class S57Chart
implements MapPainterProvider {
    private final S57 s57;
    private S63 s63;
    private final MarinerControls mc;
    private final Map<StateRenderer2D, NeptusS57Painter> painterList = new ConcurrentHashMap<StateRenderer2D, NeptusS57Painter>();

    public S57Chart() {
        File cacheFile = new File(System.getProperty("user.dir") + "/.cache/s57");
        cacheFile.mkdirs();
        this.s57 = S57Factory.build(cacheFile, new File("libJNI/gdal/" + S57Utils.getPlatformPath()));
        try {
            this.s63 = S63.forge(this.s57);
        }
        catch (NoClassDefFoundError e) {
            this.s63 = null;
        }
        this.mc = MarinerControls.forge();
        S57Utils.loadSession(this.s57);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        NeptusS57Painter painterToUse = this.painterList.get(renderer);
        if (painterToUse == null) {
            painterToUse = NeptusS57Painter.forge(this.s57, this.mc);
            this.painterList.put(renderer, painterToUse);
        }
        painterToUse.paint(g, renderer);
    }

    public JDialog getOptionsDialog(JDialog parent, final StateRenderer2D renderer) {
        OptionsDialog dialog = new OptionsDialog(){

            @Override
            public void dispose() {
                super.dispose();
                NeptusS57Painter painterToRemove = (NeptusS57Painter)S57Chart.this.painterList.get(renderer);
                if (painterToRemove != null) {
                    S57Chart.this.s57.removePainter(painterToRemove);
                }
            }
        };
        dialog.setIconImages(ConfigFetch.getIconImagesForFrames());
        dialog.addTab("S57", dialog.getIconMedium("icons/location.png"), new S57OptionsPanel(this.s57, dialog), "Settings for S57 Maps");
        if (this.s63 != null) {
            dialog.addTab("S63", dialog.getIconMedium("icons/location2.png"), new S63OptionsPanel(this.s57, this.s63, dialog), "Settings for S63 Maps");
        }
        dialog.addTab("Mariner Controls", dialog.getIconMedium("icons/cog2.png"), new MarinerControlsOptionsPanel(this.mc, dialog), "Mariner Controls");
        dialog.setRenderer(renderer);
        NeptusS57Painter painterToUse = this.painterList.get(renderer);
        if (painterToUse == null) {
            this.painterList.put(renderer, NeptusS57Painter.forge(this.s57, this.mc));
        }
        return dialog;
    }

    public Collection<LocationType> getDepthSoundings(double latMinDegs, double latMaxDegs, double lonMinDegs, double lonMaxDegs) {
        List<S57Object> objs = S57Query.forge(this.s57).findObjectsInside(latMaxDegs, lonMinDegs, latMinDegs, lonMaxDegs, new String[]{"SOUNDG"});
        ArrayList<LocationType> locs = new ArrayList<LocationType>();
        for (S57Object obj : objs) {
            LocationType loc = obj.getGeometry().getCenter();
            loc.setDepth(obj.getGeometry().getDepth());
            locs.add(loc);
        }
        return locs;
    }

    public static int getMaxLevelOfDetail() {
        return 22;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (NeptusS57Painter pt : this.painterList.values().toArray(new NeptusS57Painter[0])) {
            this.s57.removePainter(pt);
        }
    }
}

