/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.s57;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.s57.S57Chart;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.tiles.MapPainterProvider;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription
public class S57SoundingsExporter
extends ConsolePanel {
    private static final long serialVersionUID = 1653621815781506755L;

    public S57SoundingsExporter(ConsoleLayout cl) {
        super(cl);
    }

    public void cleanSubPanel() {
    }

    public void initSubPanel() {
        this.addMenuItem("Tools>Export Depth soundings", ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector maps = S57SoundingsExporter.this.getConsole().getSubPanelsOfClass(MapPanel.class);
                if (maps.isEmpty()) {
                    GuiUtils.errorMessage((Component)S57SoundingsExporter.this.getConsole(), (String)"Export soundings", (String)"Cannot export soundings because there is no map in the console");
                    return;
                }
                StateRenderer2D renderer = ((MapPanel)maps.firstElement()).getRenderer();
                Map painters = renderer.getWorldMapPainter().getMapPainters();
                ArrayList<LocationType> soundings = new ArrayList<LocationType>();
                for (MapPainterProvider p : painters.values()) {
                    if (!(p instanceof S57Chart)) continue;
                    S57Chart chart = (S57Chart)p;
                    LocationType topLeft = renderer.getTopLeftLocationType().convertToAbsoluteLatLonDepth();
                    LocationType bottomRight = renderer.getBottomRightLocationType().convertToAbsoluteLatLonDepth();
                    soundings.addAll(chart.getDepthSoundings(bottomRight.getLatitudeDegs(), topLeft.getLatitudeDegs(), topLeft.getLongitudeDegs(), bottomRight.getLongitudeDegs()));
                }
                try {
                    File f = new File("soundings.csv");
                    BufferedWriter w = new BufferedWriter(new FileWriter(f));
                    for (LocationType loc : soundings) {
                        w.write(String.format("%.8f,%.8f,%.2f\n", loc.getLatitudeDegs(), loc.getLongitudeDegs(), loc.getDepth()));
                    }
                    w.close();
                    GuiUtils.infoMessage((Component)S57SoundingsExporter.this.getConsole(), (String)"Export soundings", (String)("Exported " + soundings.size() + " soundings to " + f.getAbsolutePath()));
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)S57SoundingsExporter.this.getConsole(), (Exception)ex);
                    ex.printStackTrace();
                }
            }
        });
    }
}

