/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import pt.lsts.s57.S57Factory;
import pt.lsts.s57.S57Listener;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.entities.S57Map;
import pt.lsts.s57.painters.NeptusS57Painter;
import pt.lsts.s57.painters.S57Painter;
import pt.lsts.s57.resources.Resources;

public class S57 {
    private static boolean loadingFolder = false;
    private final Resources resources;
    private Map<String, S57Map> maps = Collections.synchronizedMap(new TreeMap());
    private Map<String, List<File>> folders = Collections.synchronizedMap(new LinkedHashMap());
    private List<S57Painter> painters = new ArrayList<S57Painter>();

    public static S57 build(Resources resources) {
        return new S57(resources);
    }

    private S57(Resources resources) {
        this.resources = resources;
    }

    public boolean addPainter(S57Painter s57Painter) {
        return this.painters.add(s57Painter);
    }

    public boolean removePainter(NeptusS57Painter neptusS57Painter) {
        return this.painters.remove(neptusS57Painter);
    }

    public boolean loadFolders(List<File> list, S57Listener s57Listener) {
        long l = System.nanoTime();
        List list2 = null;
        S57.setLoadingFolder(true);
        for (File file : list) {
            if (file.exists() && file.isDirectory() && !this.folders.containsKey(file.toString())) {
                list2 = (List)FileUtils.listFiles(file, new String[]{"000"}, true);
                if (!list2.isEmpty() && list2 != null) {
                    this.preloadMaps(list2, s57Listener);
                    this.folders.put(file.toString(), list2);
                    continue;
                }
                s57Listener.setMessage("No S57 files found.");
                continue;
            }
            s57Listener.setMessage("Already loaded.");
        }
        this.refreshPainters();
        if (S57Factory.DEBUG) {
            System.out.println(list2.size() + " Maps loaded in " + (double)(System.nanoTime() - l) / 1.0E9 + "s");
        }
        S57.setLoadingFolder(false);
        S57Utils.sessionSaveProperty(this, "s57Folders", this.getFolders());
        return true;
    }

    public void removeFolders(List<String> list, boolean bl) {
        for (String string : list) {
            if (!this.folders.containsKey(string)) continue;
            List<File> list2 = this.folders.remove(string);
            this.removeMaps(list2, bl);
        }
        System.gc();
        this.refreshPainters();
        S57Utils.sessionSaveProperty(this, "s57Folders", this.getFolders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMaps(List<File> list, boolean bl) {
        Map<String, S57Map> map = this.maps;
        synchronized (map) {
            for (File file : list) {
                this.maps.remove(file.getName());
            }
            if (bl) {
                S57Utils.deleteFromCache(this, list);
            }
        }
    }

    public void loadMapObjects(List<S57Map> list) {
        Thread thread = new Thread(new LoadMaps(list));
        thread.start();
    }

    public void unloadMapObjects(List<S57Map> list) {
        Thread thread = new Thread(new UnloadMaps(list));
        thread.start();
    }

    public void preloadMaps(List<File> list, S57Listener s57Listener) {
        int n = 0;
        int n2 = list.size();
        for (File file : list) {
            this.preloadMap(file, s57Listener);
            if (s57Listener != null) {
                s57Listener.publishResult((n + 1) * 100 / n2);
            }
            ++n;
        }
    }

    public void preloadMap(File file, S57Listener s57Listener) {
        String string = file.getName();
        if (!this.maps.containsKey(string)) {
            try {
                S57Map s57Map = S57Map.forge(this.resources, file.toString(), false);
                this.maps.put(string, s57Map);
            }
            catch (IOException iOException) {
                if (S57Factory.DEBUG) {
                    System.out.println("File " + string + " isn't a S57 Map or is corrupted.");
                }
                s57Listener.setMessage("File " + string + " isn't a S57 Map or is corrupted.");
            }
        }
    }

    public void addMaps(List<File> list, S57Listener s57Listener) {
        int n = 0;
        int n2 = list.size();
        for (File file : list) {
            this.addMap(file);
            if (s57Listener != null) {
                s57Listener.publishResult((n + 1) * 100 / n2);
            }
            ++n;
        }
    }

    public void addMap(File file) {
        block3: {
            String string = file.getName();
            if (!this.maps.containsKey(string)) {
                try {
                    S57Map s57Map = S57Map.forge(this.resources, file.toString(), true);
                    this.maps.put(string, s57Map);
                }
                catch (IOException iOException) {
                    if (!S57Factory.DEBUG) break block3;
                    System.out.println("File " + string + " isn't a S57 Map or is corrupted.");
                }
            }
        }
    }

    public void preloadIfCacheExists(List<File> list, S57Listener s57Listener) {
        int n = 0;
        int n2 = list.size();
        for (File file : list) {
            this.preloadIfCacheExists(file, s57Listener);
            s57Listener.publishResult((n + 1) * 100 / n2);
            ++n;
        }
    }

    public void preloadIfCacheExists(File file, S57Listener s57Listener) {
        String string = file.getName();
        File file2 = new File(this.getConfig().getString("s57.cache.folder") + "/" + string + ".dat");
        File file3 = new File(this.getConfig().getString("s57.cache.folder") + "/" + string + ".obj");
        if (file2.exists() && file3.exists() && !this.maps.containsKey(string)) {
            System.out.println(file);
            try {
                S57Map s57Map = S57Map.forge(this.resources, file.toString(), false);
                this.maps.put(string, s57Map);
            }
            catch (IOException iOException) {
                System.out.println("Cache file not found ?????. " + iOException.getMessage());
            }
        }
    }

    public void refreshPainters() {
        for (S57Painter s57Painter : this.painters) {
            s57Painter.setCacheValid(false);
        }
    }

    public List<String> getFolders() {
        return Arrays.asList(this.folders.keySet().toArray(new String[0]));
    }

    public Set<String> list() {
        Set<String> set = this.maps.keySet();
        return set;
    }

    public S57Map getMap(String string) {
        S57Map s57Map = this.maps.get(string);
        if (s57Map != null) {
            return s57Map;
        }
        return null;
    }

    public Map<String, String> getMapMeta(String string) {
        S57Map s57Map = this.getMap(string);
        if (s57Map != null) {
            return s57Map.getMapInfoReadable();
        }
        throw new IllegalArgumentException("Map " + string + " doesn't exist or couldn't be loaded !");
    }

    public static boolean isLoadingFolder() {
        return loadingFolder;
    }

    public static void setLoadingFolder(boolean bl) {
        loadingFolder = bl;
    }

    public Map<String, S57Map> getMaps() {
        return this.maps;
    }

    public List<String> getMapsFromFolder(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<File> list = this.folders.get(string);
        for (File file : list) {
            arrayList.add(file.getName());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public Configuration getConfig() {
        return this.resources.getConfig();
    }

    public Resources getResources() {
        return this.resources;
    }

    private class UnloadMaps
    implements Runnable {
        private List<S57Map> maps;
        private List<S57Map> inUseMaps = new ArrayList<S57Map>();

        public UnloadMaps(List<S57Map> list) {
            this.maps = list;
            for (S57Painter s57Painter : S57.this.painters) {
                List<S57Map> list2 = s57Painter.getCurrentMaps();
                for (S57Map s57Map : list2) {
                    if (this.inUseMaps.contains(s57Map)) continue;
                    this.inUseMaps.add(s57Map);
                }
            }
        }

        @Override
        public void run() {
            for (S57Map s57Map : this.maps) {
                if (this.inUseMaps.contains(s57Map) || !s57Map.unloadMapObjects()) continue;
                S57.this.refreshPainters();
            }
        }
    }

    private class LoadMaps
    implements Runnable {
        private List<S57Map> maps;

        public LoadMaps(List<S57Map> list) {
            this.maps = list;
        }

        @Override
        public void run() {
            for (S57Map s57Map : this.maps) {
                if (!s57Map.loadMapObjects(null)) continue;
                S57.this.refreshPainters();
            }
        }
    }
}

