/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57;

import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.gdal.gdal.gdal;
import org.gdal.ogr.ogr;
import pt.lsts.s57.S57;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.ResourcesFactory;

public class S57Factory {
    public static boolean DEBUG = false;

    private S57Factory() {
    }

    public static S57 build(File file, File file2) {
        try {
            S57Utils.extractResources(file);
            S57Utils.loadNative(file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
        File file3 = new File(file, "resources");
        File file4 = file;
        PropertiesConfiguration propertiesConfiguration = S57Factory.config(file3, file4);
        Resources resources = S57Factory.resources(file3, propertiesConfiguration);
        S57Factory.setupCacheAndSession(propertiesConfiguration);
        gdal.SetConfigOption("S57_CSV", propertiesConfiguration.getString("s57.resources"));
        gdal.SetConfigOption("OGR_S57_OPTIONS", "SPLIT_MULTIPOINT=ON,ADD_SOUNDG_DEPTH=ON");
        ogr.RegisterAll();
        return S57.build(resources);
    }

    private static PropertiesConfiguration config(File file, File file2) {
        PropertiesConfiguration propertiesConfiguration = null;
        try {
            propertiesConfiguration = new PropertiesConfiguration(new File(file, "config.properties").getCanonicalPath());
            propertiesConfiguration.setAutoSave(false);
            propertiesConfiguration.setProperty("s57.resources", new File(file, propertiesConfiguration.getString("s57.resources")).getCanonicalPath());
            propertiesConfiguration.setProperty("s57.svg", new File(file, propertiesConfiguration.getString("s57.svg")).getCanonicalPath());
            propertiesConfiguration.setProperty("s52.resources", new File(file, propertiesConfiguration.getString("s52.resources")).getCanonicalPath());
            propertiesConfiguration.setProperty("s57.cache.folder", new File(file2.getCanonicalPath(), "cache/s57/").toString());
            propertiesConfiguration.setProperty("s63.cache.folder", new File(file2.getCanonicalPath(), "cache/s63/").toString());
            propertiesConfiguration.setProperty("s57.session.file", new File(file2.getCanonicalPath(), "s57.session").toString());
        }
        catch (ConfigurationException configurationException) {
            System.err.println("Error loading config.properties file .. " + configurationException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return propertiesConfiguration;
    }

    private static Resources resources(File file, PropertiesConfiguration propertiesConfiguration) {
        return ResourcesFactory.build(propertiesConfiguration);
    }

    private static void setupCacheAndSession(PropertiesConfiguration propertiesConfiguration) {
        File file = new File(propertiesConfiguration.getString("s57.cache.folder"));
        File file2 = new File(propertiesConfiguration.getString("s63.cache.folder"));
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try {
            FileUtils.cleanDirectory(file2);
        }
        catch (IOException iOException) {
            System.out.println("Problem cleaning s63 cache folder at startup");
        }
        File file3 = new File(propertiesConfiguration.getString("s57.session.file"));
        if (!file3.exists()) {
            try {
                file3.createNewFile();
            }
            catch (IOException iOException) {
                System.out.println("Problem creating session file at startup");
            }
        }
    }
}

