/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57;

import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.s57.S57;
import pt.lsts.s57.entities.S57Map;
import pt.lsts.s57.entities.S57Object;

public class S57Query {
    private final S57 s57;

    public static S57Query forge(S57 s57) {
        return new S57Query(s57);
    }

    public S57Query(S57 s57) {
        this.s57 = s57;
    }

    public List<S57Map> findMapsContains(double d, double d2) {
        ArrayList<S57Map> arrayList = new ArrayList<S57Map>();
        for (S57Map s57Map : this.s57.getMaps().values()) {
            for (S57Object s57Object : s57Map.getCoverage()) {
                boolean bl = s57Object.getGeometry().getPolygon().contains(d, d2);
                if (!bl) continue;
                arrayList.add(s57Map);
            }
        }
        return arrayList;
    }

    public List<S57Map> findMapsContains(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = this.boundingBox(d, d2, d3, d4);
        ArrayList<S57Map> arrayList = new ArrayList<S57Map>();
        for (S57Map s57Map : this.s57.getMaps().values()) {
            for (S57Object s57Object : s57Map.getCoverage()) {
                boolean bl = s57Object.getGeometry().getPolygon().contains(rectangle2D);
                if (!bl) continue;
                arrayList.add(s57Map);
                if (s57Map.isLoaded()) continue;
                s57Map.loadMapObjects(null);
            }
        }
        return arrayList;
    }

    public List<S57Map> findMapsIntersects(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = this.boundingBox(d, d2, d3, d4);
        ArrayList<S57Map> arrayList = new ArrayList<S57Map>();
        for (S57Map s57Map : this.s57.getMaps().values()) {
            for (S57Object s57Object : s57Map.getCoverage()) {
                boolean bl = s57Object.getGeometry().getPolygon().intersects(rectangle2D.getBounds2D());
                if (!bl) continue;
                arrayList.add(s57Map);
            }
        }
        return arrayList;
    }

    public List<S57Object> findObjectsInside(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = this.boundingBox(d, d2, d3, d4);
        ArrayList<S57Object> arrayList = new ArrayList<S57Object>();
        for (S57Map s57Map : this.s57.getMaps().values()) {
            for (S57Object s57Object : s57Map.getCoverage()) {
                boolean bl = s57Object.getGeometry().getPolygon().intersects(rectangle2D);
                if (!bl) continue;
                for (S57Object s57Object2 : s57Map.getObjects()) {
                    boolean bl2 = false;
                    switch (s57Object2.getGeoType()) {
                        case POINT: {
                            LocationType locationType = s57Object2.getGeometry().getLocation();
                            bl2 = rectangle2D.contains(locationType.getLatitudeDegs(), locationType.getLongitudeDegs());
                            System.out.println(s57Object2.getGeometry().getDepth());
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            bl2 = rectangle2D.contains(s57Object2.getGeometry().getPolygon().getBounds2D());
                        }
                    }
                    if (!bl2) continue;
                    arrayList.add(s57Object2);
                }
            }
        }
        return arrayList;
    }

    public List<S57Object> findObjectsInside(double d, double d2, double d3, double d4, String[] stringArray) {
        Rectangle2D rectangle2D = this.boundingBox(d, d2, d3, d4);
        ArrayList<S57Object> arrayList = new ArrayList<S57Object>();
        for (S57Map s57Map : this.s57.getMaps().values()) {
            for (S57Object s57Object : s57Map.getCoverage()) {
                boolean bl = s57Object.getGeometry().getPolygon().intersects(rectangle2D);
                if (!bl) continue;
                for (S57Object s57Object2 : s57Map.getObjects(stringArray)) {
                    boolean bl2 = false;
                    switch (s57Object2.getGeoType()) {
                        case POINT: {
                            LocationType locationType = s57Object2.getGeometry().getLocation();
                            bl2 = rectangle2D.contains(locationType.getLatitudeDegs(), locationType.getLongitudeDegs());
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            bl2 = rectangle2D.contains(s57Object2.getGeometry().getPolygon().getBounds2D());
                        }
                    }
                    if (!bl2) continue;
                    arrayList.add(s57Object2);
                }
            }
        }
        return arrayList;
    }

    private Rectangle2D boundingBox(double d, double d2, double d3, double d4) {
        Path2D.Double double_ = new Path2D.Double(0);
        ((Path2D)double_).moveTo(d, d2);
        ((Path2D)double_).lineTo(d, d4);
        ((Path2D)double_).lineTo(d3, d4);
        ((Path2D)double_).lineTo(d3, d2);
        double_.closePath();
        return double_.getBounds2D();
    }
}

