/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.ogr;
import pt.lsts.s57.S57;
import pt.lsts.s57.ui.LoadS57FolderTask;

public class S57Utils {
    private static final String DRIVER_NAME = "S57";
    private static final String[] RESOURCES_LIST = new String[]{"resources/s52/lookup_tables/PAPER_CHART.dic", "resources/s52/lookup_tables/LINES.dic", "resources/s52/lookup_tables/PLAIN_BOUNDARIES.dic", "resources/s52/lookup_tables/SIMPLIFIED.dic", "resources/s52/lookup_tables/SYMBOLIZED_BOUNDARIES.dic", "resources/s52/symbols/allbitmaps.rah", "resources/s52/symbols/allvectors.sym", "resources/s52/color_tables/allcolors.cta", "resources/s57/s57agencies.csv", "resources/s57/s57attributes_aml.csv", "resources/s57/s57expectedinput.csv", "resources/s57/s57objectclasses_aml.csv", "resources/s57/s57attributes.csv", "resources/s57/s57attributes_iw.csv", "resources/s57/s57objectclasses.csv", "resources/s57/s57objectclasses_iw.csv", "resources/config.properties", "resources/map4.svg"};
    private static final String[] NATIVE_LIBS = new String[]{"resources/gdal/linux/x64/libgdal.so", "resources/gdal/linux/x64/libgdalconstjni.so", "resources/gdal/linux/x64/libgdaljni.so", "resources/gdal/linux/x64/libogrjni.so", "resources/gdal/linux/x64/libosrjni.so", "resources/gdal/linux/x86/libgdal.so", "resources/gdal/linux/x86/libgdalconstjni.so", "resources/gdal/linux/x86/libgdaljni.so", "resources/gdal/linux/x86/libogrjni.so", "resources/gdal/linux/x86/libosrjni.so", "resources/gdal/win/x86/gdal19.dll", "resources/gdal/win/x86/gdalconstjni.dll", "resources/gdal/win/x86/gdaljni.dll", "resources/gdal/win/x86/ogrjni.dll", "resources/gdal/win/x86/osrjni.dll", "resources/gdal/win/x64/gdal19.dll", "resources/gdal/win/x64/gdalconstjni.dll", "resources/gdal/win/x64/gdaljni.dll", "resources/gdal/win/x64/ogrjni.dll", "resources/gdal/win/x64/osrjni.dll"};

    private S57Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractResources(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(RESOURCES_LIST));
        for (String string : arrayList) {
            File file2 = new File(file, string);
            if (file2.exists()) continue;
            InputStream inputStream = S57Utils.class.getResourceAsStream("/" + string);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = FileUtils.openOutputStream(file2);
                IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public static void loadNative(File file) throws IOException {
        String[] stringArray = new String[]{"gdal", "gdalconstjni", "gdaljni", "ogrjni", "osrjni"};
        String string = S57Utils.getPlatformPath();
        for (String string2 : stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string.contains("win")) {
                stringBuilder.append(string2);
                if (string2.equals("gdal")) {
                    stringBuilder.append("19");
                }
                stringBuilder.append(".dll");
            } else {
                stringBuilder.append("lib");
                stringBuilder.append(string2);
                stringBuilder.append(".so");
            }
            File file2 = null;
            try {
                file2 = new File(file.getCanonicalFile(), stringBuilder.toString());
                System.load(file2.getAbsolutePath().toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Native code library failed to load. " + unsatisfiedLinkError);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
    }

    public static String getPlatformPath() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.contains("windows")) {
            string = "win";
        } else if (string.contains("linux")) {
            string = "linux";
        } else {
            throw new IllegalArgumentException("os not supported");
        }
        if (string2.contains("86")) {
            string2 = "x86";
        } else if (string2.contains("64")) {
            string2 = "x64";
        } else {
            throw new IllegalArgumentException("arch not supported " + string2);
        }
        return string + "/" + string2;
    }

    public static DataSource loadDataSource(String string) throws IOException {
        DataSource dataSource = ogr.Open(string, false);
        if (dataSource == null) {
            throw new IOException("Could not open file: " + string);
        }
        Driver driver = dataSource.GetDriver();
        if (!driver.getName().equals(DRIVER_NAME)) {
            dataSource.delete();
            throw new IOException("Data source is not recognised as S-57 format: " + driver.getName());
        }
        return dataSource;
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static int checksum(String string) {
        byte[] byArray = string.getBytes();
        int n = -1;
        n = -1;
        int n2 = -306674912;
        for (byte by : byArray) {
            int n3 = (n ^ by) & 0xFF;
            for (int i = 0; i < 8; ++i) {
                if ((n3 & 1) == 1) {
                    n3 = n3 >>> 1 ^ n2;
                    continue;
                }
                n3 >>>= 1;
            }
            n = n >>> 8 ^ n3;
        }
        return n ^= 0xFFFFFFFF;
    }

    public static String encryptBlowfish(String string, String string2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, secretKeySpec);
            return new String(cipher.doFinal(string.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encryptBlowfish(int n, String string) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes("UTF-8"), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, secretKeySpec);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            return S57Utils.byteArrayToHexString(cipher.doFinal(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] decryptBlowfish(String string, String string2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes(), "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, secretKeySpec);
            byte[] byArray = cipher.doFinal(S57Utils.hexStringToByteArray(string));
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static InputStream decryptBlowfish(File file, byte[] byArray) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, secretKeySpec);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            CipherInputStream cipherInputStream = new CipherInputStream(bufferedInputStream, cipher);
            return cipherInputStream;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void unzipToFile(InputStream inputStream, String string) {
        BufferedOutputStream bufferedOutputStream = null;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                byte[] byArray = new byte[2048];
                FileOutputStream fileOutputStream = new FileOutputStream(string + "/" + zipEntry.getName());
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = zipInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            zipInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static void sessionSaveProperty(S57 s57, String string, List<String> list) {
        File file = new File(s57.getConfig().getString("s57.session.file"));
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(file);
            propertiesConfiguration.setProperty(string, list);
            propertiesConfiguration.save();
        }
        catch (ConfigurationException configurationException) {
            System.out.println("Problem saving property to session file");
        }
    }

    public static void sessionSaveProperty(S57 s57, String string, String string2) {
        File file = new File(s57.getConfig().getString("s57.session.file"));
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(file);
            propertiesConfiguration.setProperty(string, string2);
            propertiesConfiguration.save();
        }
        catch (ConfigurationException configurationException) {
            System.out.println("Problem saving property to session file");
        }
    }

    public static String sessionGet(S57 s57, String string) {
        File file = new File(s57.getConfig().getString("s57.session.file"));
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(file);
            return propertiesConfiguration.getString(string);
        }
        catch (ConfigurationException configurationException) {
            System.out.println("Problem getting session property string");
            return null;
        }
    }

    public static List<Object> sessionGetList(S57 s57, String string) {
        File file = new File(s57.getConfig().getString("s57.session.file"));
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(file);
            return propertiesConfiguration.getList(string);
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
            return null;
        }
    }

    public static void loadSession(S57 s57) {
        File file = new File(s57.getConfig().getString("s57.session.file"));
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(file);
            List<Object> list = propertiesConfiguration.getList("s57Folders");
            if (!list.isEmpty() && list != null) {
                LoadS57FolderTask loadS57FolderTask = new LoadS57FolderTask(list, s57);
                loadS57FolderTask.execute();
            }
        }
        catch (ConfigurationException configurationException) {
            System.out.println("Dialog config file error! " + configurationException.getMessage());
        }
    }

    public static void deleteFromCache(S57 s57, List<File> list) {
        for (File file : list) {
            S57Utils.deleteFromCache(s57, file);
        }
    }

    public static void deleteFromCache(S57 s57, File file) {
        String string = s57.getConfig().getString("s57.cache.folder");
        File file2 = new File(string + "/" + file.getName() + ".dat");
        File file3 = new File(string + "/" + file.getName() + ".obj");
        if (file2.exists()) {
            file2.delete();
        }
        if (file3.exists()) {
            file3.delete();
        }
    }

    public static void cleanS63TempFiles(S57 s57) {
        File[] fileArray;
        String string = s57.getConfig().getString("s63.cache.folder");
        System.out.println(string);
        for (File file : fileArray = new File(string).listFiles()) {
            file.delete();
        }
    }
}

