/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.entities.Attribute;
import pt.lsts.s57.resources.entities.Input;

public class S57Attribute
implements Serializable {
    private static final long serialVersionUID = -2287913572573190345L;
    public static boolean verbose = false;
    private final String acronym;
    private final List<String> value = new ArrayList<String>();
    private final Attribute attributeInfo;
    private final String meaning;

    public static S57Attribute forge(Resources resources, String string, String string2) {
        return new S57Attribute(resources, string, string2);
    }

    private S57Attribute(Resources resources, String string, String string2) {
        String[] stringArray;
        this.acronym = string;
        for (String string3 : stringArray = string2.split(",")) {
            String string4 = string3.trim();
            if (string4.contains("/")) {
                this.value.addAll(Arrays.asList(string4.split("/")));
                continue;
            }
            this.value.add(string4);
        }
        this.attributeInfo = resources.getAttribute(string);
        this.meaning = this.setMeaning(resources);
    }

    private String setMeaning(Resources resources) {
        if (this.value.isEmpty() || this.value.get(0) == "") {
            return "";
        }
        if (this.attributeInfo.getAttributeType().equals("E")) {
            Input input = resources.getInput(this.attributeInfo.getCode(), Integer.valueOf(this.value.get(0)));
            if (input != null) {
                return resources.getInput(this.attributeInfo.getCode(), Integer.valueOf(this.value.get(0))).getMeaning();
            }
            return "";
        }
        if (this.attributeInfo.getAttributeType().equals("L")) {
            String string = "";
            for (String string2 : this.value) {
                Input input;
                if (string2.isEmpty() || (input = resources.getInput(this.attributeInfo.getCode(), Integer.valueOf(string2))) == null) continue;
                string = string + " " + input.getMeaning();
            }
            return string;
        }
        return "";
    }

    public String getAcronym() {
        return this.acronym;
    }

    public List<String> getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        if (this.value.isEmpty()) {
            return true;
        }
        return this.value.size() == 1 && (this.value.get(0).isEmpty() || this.value.get(0).equals(""));
    }

    public String getMeaning() {
        return this.meaning;
    }

    public List<Integer> getValueAsInt() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.attributeInfo.getAttributeType().equals("E") || this.attributeInfo.getAttributeType().equals("L")) {
            for (String string : this.value) {
                if (string.equals("")) continue;
                arrayList.add(Integer.valueOf(string));
            }
            return arrayList;
        }
        return null;
    }

    public Integer getCode() {
        return this.attributeInfo.getCode();
    }

    public String getName() {
        return this.attributeInfo.getName();
    }

    public String getAttributeType() {
        return this.attributeInfo.getAttributeType();
    }

    public String getClassAbbrev() {
        return this.attributeInfo.getClassAbbrev();
    }

    public String toString() {
        return "S57Attribute [acronym=" + this.acronym + ", value=" + this.value + ", attributeInfo=" + this.attributeInfo + "]";
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }
}

