/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gdal.ogr.DataSource;
import pt.lsts.s57.S57Factory;
import pt.lsts.s57.S57Listener;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.entities.S57MapMeta;
import pt.lsts.s57.entities.S57MapObjects;
import pt.lsts.s57.entities.S57Object;
import pt.lsts.s57.resources.Resources;

public class S57Map {
    private final Resources resources;
    private String name;
    private S57MapMeta metaInfo;
    private S57MapObjects objects;
    private boolean loaded = false;
    private boolean loading = false;

    public static S57Map forge(Resources resources, String string, boolean bl) throws IOException {
        return new S57Map(resources, string, bl);
    }

    private S57Map(Resources resources, String string, boolean bl) throws IOException {
        this.resources = resources;
        this.name = new File(string).getName();
        DataSource dataSource = null;
        File file = new File(resources.getConfig().getString("s57.cache.folder") + this.name + ".dat");
        if (file.exists()) {
            this.metaInfo = S57MapMeta.forge(resources, string);
        } else {
            dataSource = S57Utils.loadDataSource(string);
            this.metaInfo = S57MapMeta.forge(resources, string, dataSource);
        }
        if (bl) {
            if (dataSource == null) {
                dataSource = S57Utils.loadDataSource(string);
            }
            this.objects = S57MapObjects.forge(dataSource, resources, this.name);
            this.loaded = true;
        }
        if (dataSource != null) {
            dataSource.delete();
        }
    }

    public boolean loadMapObjects(S57Listener s57Listener) {
        if (this.loaded || this.loading) {
            return false;
        }
        long l = System.nanoTime();
        this.loading = true;
        this.objects = S57MapObjects.forge(this.metaInfo.getAbsolutePath().toString(), this.resources, this.name);
        this.loaded = true;
        this.loading = false;
        if (S57Factory.DEBUG) {
            System.out.println(this.name + " concurrent load done !  " + (double)(System.nanoTime() - l) / 1.0E9 + "s");
        }
        return true;
    }

    public boolean unloadMapObjects() {
        if (!this.loaded || this.loading) {
            return false;
        }
        this.loaded = false;
        this.objects = null;
        return true;
    }

    public List<S57Object> getObjects() {
        if (!this.loaded) {
            this.loadMapObjects(null);
        }
        return this.objects.getObjects();
    }

    public List<S57Object> getObjects(String[] stringArray) {
        if (!this.loaded) {
            this.loadMapObjects(null);
        }
        List<String> list = Arrays.asList(stringArray);
        ArrayList<S57Object> arrayList = new ArrayList<S57Object>();
        for (S57Object s57Object : this.objects.getObjects()) {
            if (!list.contains(s57Object.getAcronym())) continue;
            arrayList.add(s57Object);
        }
        return arrayList;
    }

    public List<S57Object> getGroupOneObjects() {
        if (!this.loaded) {
            this.loadMapObjects(null);
        }
        return this.objects.getObjectsGroupOne();
    }

    public Double getScaleMin() {
        for (S57Object s57Object : this.getGroupOneObjects()) {
            if (!s57Object.getAcronym().equals("DEPARE")) continue;
            return s57Object.getScamin();
        }
        return null;
    }

    public List<S57Object> getCoverage() {
        return this.metaInfo.getCoverage();
    }

    public String getName() {
        return this.metaInfo.getName();
    }

    public List<S57Object> getMeta() {
        return this.objects.getMeta();
    }

    public Map<String, String> getMapInfoReadable() {
        return this.metaInfo.getMapMetaReadable();
    }

    public S57MapMeta getMapInfo() {
        return this.metaInfo;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public String toString() {
        return "S57Map [name=" + this.name + "]";
    }
}

