/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Layer;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.entities.S57Object;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.entities.Agency;

public class S57MapMeta
implements Serializable {
    private static final long serialVersionUID = 1326239967438064940L;
    private static final Map<String, String> navPurpose = new HashMap<String, String>();
    private static final Map<String, String> coordUnitTranslate = new HashMap<String, String>();
    private transient Resources resources;
    private final Agency agency;
    private final Map<String, String> mapMeta;
    private final Map<String, String> mapMetaReadable;
    private final File absolutePath;
    private final String name;
    private List<S57Object> coverage;

    public static S57MapMeta forge(Resources resources, String string, DataSource dataSource) throws IOException {
        String string2 = new File(string).getName();
        String string3 = resources.getConfig().getString("s57.cache.folder");
        File file = new File(string3, string2 + ".dat");
        if (file.exists()) {
            return S57MapMeta.deserialize(file, resources);
        }
        Layer layer = dataSource.GetLayer("DSID");
        Layer layer2 = dataSource.GetLayer("M_COVR");
        if (layer != null && layer2 != null) {
            S57MapMeta s57MapMeta = new S57MapMeta(resources, string, layer, layer2);
            S57MapMeta.serialize(string3, string2, s57MapMeta);
            return s57MapMeta;
        }
        throw new IOException("Error preloading meta and coverage");
    }

    public static S57MapMeta forge(Resources resources, String string) throws IOException {
        String string2 = new File(string).getName();
        String string3 = resources.getConfig().getString("s57.cache.folder");
        File file = new File(string3 + string2 + ".dat");
        if (file.exists()) {
            return S57MapMeta.deserialize(file, resources);
        }
        DataSource dataSource = S57Utils.loadDataSource(string);
        Layer layer = dataSource.GetLayer("DSID");
        Layer layer2 = dataSource.GetLayer("M_COVR");
        S57MapMeta s57MapMeta = new S57MapMeta(resources, string, layer, layer2);
        S57MapMeta.serialize(string3, string2, s57MapMeta);
        return s57MapMeta;
    }

    private S57MapMeta(Resources resources, String string, Layer layer, Layer layer2) throws IOException {
        navPurpose.put("1", "Overview");
        navPurpose.put("2", "General");
        navPurpose.put("3", "Coastal");
        navPurpose.put("4", "Approach");
        navPurpose.put("5", "Harbour");
        navPurpose.put("6", "Berthing");
        coordUnitTranslate.put("1", "Latitude/Longitude");
        coordUnitTranslate.put("2", "Easting/Northing");
        coordUnitTranslate.put("3", "Units on Chart/Map");
        this.mapMeta = new HashMap<String, String>();
        this.mapMetaReadable = new LinkedHashMap<String, String>();
        this.coverage = new ArrayList<S57Object>();
        this.resources = resources;
        this.absolutePath = new File(string).getAbsoluteFile();
        this.name = this.absolutePath.getName();
        this.loadMapInfo(layer);
        this.loadCoverage(layer2);
        this.agency = resources.getAgency(this.mapMeta.get("DSID_AGEN"));
    }

    private void loadMapInfo(Layer layer) {
        Feature feature;
        while ((feature = layer.GetNextFeature()) != null) {
            int n = feature.GetFieldCount();
            for (int i = 0; i < n; ++i) {
                String string = feature.GetFieldDefnRef(i).GetNameRef();
                String string2 = feature.IsFieldSet(i) ? feature.GetFieldAsString(i) : "";
                this.mapMeta.put(string, string2);
            }
        }
    }

    private void loadCoverage(Layer layer) {
        Feature feature;
        while ((feature = layer.GetNextFeature()) != null) {
            S57Object s57Object;
            if (!feature.GetDefnRef().GetName().equals("M_COVR") || !(s57Object = S57Object.forge(this.resources, feature)).getAttributes().get("CATCOV").getValue().get(0).equals("1")) continue;
            this.coverage.add(s57Object);
        }
    }

    protected List<S57Object> getCoverage() {
        return this.coverage;
    }

    private void buildMetaDataReadable() {
        this.mapMetaReadable.put("Path", this.absolutePath.toString());
        String string = this.mapMeta.get("DSID_AGEN");
        this.mapMetaReadable.put("Agency", this.resources.getAgency(string).getAgencyName());
        this.mapMetaReadable.put("Country", this.resources.getAgency(string).getCountry());
        this.mapMetaReadable.put("CC", this.resources.getAgency(string).getToken());
        String string2 = this.mapMeta.get("DSID_INTU");
        this.mapMetaReadable.put("Navigational Purpose", navPurpose.get(string2));
        this.mapMetaReadable.put("Coordinate Unit", coordUnitTranslate.get(this.mapMeta.get("DSPM_COUN")));
        this.mapMetaReadable.put("Edition Number", this.mapMeta.get("DSID_EDTN"));
        this.mapMetaReadable.put("Update Number", this.mapMeta.get("DSID_UPDN"));
        this.mapMetaReadable.put("Issue Date", this.mapMeta.get("DSID_ISDT"));
        this.mapMetaReadable.put("Update application date", this.mapMeta.get("DSID_UADT"));
    }

    private static void serialize(String string, String string2, S57MapMeta s57MapMeta) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string, string2 + ".dat"));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(s57MapMeta);
            ((OutputStream)bufferedOutputStream).flush();
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static S57MapMeta deserialize(File file, Resources resources) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            S57MapMeta s57MapMeta = (S57MapMeta)objectInputStream.readObject();
            s57MapMeta.setResources(resources);
            navPurpose.put("1", "Overview");
            navPurpose.put("2", "General");
            navPurpose.put("3", "Coastal");
            navPurpose.put("4", "Approach");
            navPurpose.put("5", "Harbour");
            navPurpose.put("6", "Berthing");
            coordUnitTranslate.put("1", "Latitude/Longitude");
            coordUnitTranslate.put("2", "Easting/Northing");
            coordUnitTranslate.put("3", "Units on Chart/Map");
            ((InputStream)bufferedInputStream).close();
            objectInputStream.close();
            return s57MapMeta;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public Map<String, String> getMapMetaReadable() {
        if (this.mapMetaReadable.isEmpty()) {
            this.buildMetaDataReadable();
        }
        return this.mapMetaReadable;
    }

    public String getName() {
        return this.name;
    }

    public File getAbsolutePath() {
        return this.absolutePath;
    }

    public Agency getAgency() {
        return this.agency;
    }

    public String get(String string) {
        return this.mapMeta.get(string);
    }

    public int getPurpose() {
        return Integer.valueOf(this.mapMeta.get("DSID_INTU"));
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }
}

