/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Layer;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.entities.S57Object;
import pt.lsts.s57.resources.Resources;

public class S57MapObjects
implements Serializable {
    private static final long serialVersionUID = 1549955050463007910L;
    private List<S57Object> objects = new ArrayList<S57Object>();
    private List<S57Object> objectsGroupOne = new ArrayList<S57Object>();
    private List<S57Object> meta = new ArrayList<S57Object>();
    private List<S57Object> collection = new ArrayList<S57Object>();

    public static S57MapObjects forge(DataSource dataSource, Resources resources, String string) {
        String string2 = resources.getConfig().getString("s57.cache.folder");
        File file = new File(string2, string + ".obj");
        if (file.exists()) {
            return S57MapObjects.deserialize(file);
        }
        S57MapObjects s57MapObjects = new S57MapObjects(dataSource, resources);
        S57MapObjects.serialize(string2, string, s57MapObjects);
        return s57MapObjects;
    }

    public static S57MapObjects forge(String string, Resources resources, String string2) {
        DataSource dataSource = null;
        try {
            dataSource = S57Utils.loadDataSource(string);
        }
        catch (IOException iOException) {
            System.out.println("error opening map file with gdal " + iOException.getMessage());
        }
        return S57MapObjects.forge(dataSource, resources, string2);
    }

    private S57MapObjects(DataSource dataSource, Resources resources) {
        int n = dataSource.GetLayerCount();
        for (int i = 0; i < n; ++i) {
            Feature feature;
            Layer layer = dataSource.GetLayer(i);
            String string = layer.GetLayerDefn().GetName();
            if (string.equals("DSID") || string.equals("M_COVR")) continue;
            while ((feature = layer.GetNextFeature()) != null) {
                this.loadObject(feature, resources);
            }
        }
        dataSource.delete();
    }

    private void loadObject(Feature feature, Resources resources) {
        S57Object s57Object = S57Object.forge(resources, feature);
        if (s57Object.getObjectClass().getType().equals("M")) {
            this.meta.add(s57Object);
        } else if (s57Object.getObjectClass().getType().equals("C")) {
            this.collection.add(s57Object);
        } else if (s57Object.getObjectClass().getType().equals("G")) {
            if (s57Object.isGroupOne()) {
                this.objectsGroupOne.add(s57Object);
            }
            this.objects.add(s57Object);
        } else {
            throw new IllegalArgumentException("Invalid feature type");
        }
    }

    private static void serialize(String string, String string2, S57MapObjects s57MapObjects) {
        File file = new File(string);
        File file2 = new File(string, string2 + ".obj");
        if (file2.exists()) {
            return;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string, string2 + ".obj"));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(s57MapObjects);
            objectOutputStream.flush();
            objectOutputStream.close();
            ((OutputStream)bufferedOutputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static S57MapObjects deserialize(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            S57MapObjects s57MapObjects = (S57MapObjects)objectInputStream.readObject();
            objectInputStream.close();
            ((InputStream)bufferedInputStream).close();
            ((InputStream)fileInputStream).close();
            return s57MapObjects;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public List<S57Object> getObjects() {
        return this.objects;
    }

    public List<S57Object> getObjectsGroupOne() {
        return this.objectsGroupOne;
    }

    public List<S57Object> getMeta() {
        return this.meta;
    }
}

