/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gdal.ogr.Feature;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.s57.entities.S57Attribute;
import pt.lsts.s57.entities.S57ObjectPainter;
import pt.lsts.s57.entities.geometry.S57Geometry;
import pt.lsts.s57.entities.geometry.S57GeometryFactory;
import pt.lsts.s57.entities.geometry.S57GeometryType;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.entities.Agency;
import pt.lsts.s57.resources.entities.ObjectClass;
import pt.lsts.s57.resources.entities.s52.DisplayCategory;
import pt.lsts.s57.resources.entities.s52.Instruction;
import pt.lsts.s57.resources.entities.s52.LookupTableRecord;
import pt.lsts.s57.resources.entities.s52.LookupTableType;

public class S57Object
implements Serializable {
    private static final long serialVersionUID = 7260691375690798755L;
    private final String acronym;
    private final ObjectClass objectClass;
    private final Agency agency;
    private final S57Geometry geometry;
    private final Map<LookupTableType, LookupTableRecord> lup;
    private final transient Resources resources;
    private final Map<String, S57Attribute> attributes = new HashMap<String, S57Attribute>();
    private final Map<String, String> idFields = new HashMap<String, String>();

    public static S57Object forge(Resources resources, Feature feature) {
        return new S57Object(resources, feature);
    }

    private S57Object(Resources resources, Feature feature) {
        this.resources = resources;
        if (feature.GetFID() == -1) {
            throw new IllegalArgumentException("Invalid feature FID");
        }
        this.acronym = feature.GetDefnRef().GetName();
        this.objectClass = resources.getObjectClass(this.acronym);
        for (int i = 0; i < feature.GetFieldCount(); ++i) {
            String string;
            String string2 = feature.GetFieldDefnRef(i).GetNameRef();
            String string3 = string = feature.IsFieldSet(i) ? feature.GetFieldAsString(i) : "";
            if (string2.length() != 6) {
                this.idFields.put(string2, string);
                continue;
            }
            if (this.objectClass.getAttrib_A().contains(string2) || this.objectClass.getAttrib_B().contains(string2) || this.objectClass.getAttrib_C().contains(string2)) {
                this.attributes.put(string2, S57Attribute.forge(resources, string2, string));
                continue;
            }
            throw new IllegalArgumentException("object doesnt have the necessary attributes");
        }
        this.agency = resources.getAgency(this.idFields.get("AGEN"));
        this.geometry = S57GeometryFactory.factory(feature.GetGeometryRef());
        this.lup = resources.getLupRecord(this.geometry.getType(), this.acronym, this.attributes);
    }

    public String getAcronym() {
        return this.acronym;
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public Map<String, S57Attribute> getAttributes() {
        return this.attributes;
    }

    public S57Attribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public boolean hasAttribute(String string) {
        return this.attributes.get(string) != null;
    }

    public boolean isAttribute(String string) {
        if (this.attributes.get(string) != null) {
            return !this.attributes.get(string).isEmpty();
        }
        return false;
    }

    public Map<String, String> getIdFields() {
        return this.idFields;
    }

    public String getIdField(String string) {
        return this.idFields.get(string);
    }

    public boolean isGroupOne() {
        return this.idFields.get("GRUP").equals("1");
    }

    public boolean intersects(S57Object s57Object) {
        if (this.getGeoType() == S57GeometryType.NONE || s57Object.getGeoType() == S57GeometryType.NONE) {
            return false;
        }
        if (this.getGeoType() == S57GeometryType.POINT) {
            if (s57Object.getGeoType() == S57GeometryType.POINT) {
                return false;
            }
            Path2D path2D = s57Object.getGeometry().getPolygon();
            LocationType locationType = this.getGeometry().getLocation();
            return path2D.contains(locationType.getLatitudeDegs(), locationType.getLongitudeDegs());
        }
        if (s57Object.getGeoType() == S57GeometryType.POINT) {
            Path2D path2D = this.getGeometry().getPolygon();
            LocationType locationType = s57Object.getGeometry().getLocation();
            return path2D.contains(locationType.getLatitudeDegs(), locationType.getLongitudeDegs());
        }
        return this.geometry.getPolygon().intersects(s57Object.getGeometry().getPolygon().getBounds2D());
    }

    public boolean intersects(Path2D path2D) {
        if (this.getGeoType() == S57GeometryType.POINT) {
            LocationType locationType = this.geometry.getLocation();
            return path2D.contains(locationType.getLatitudeDegs(), locationType.getLongitudeDegs());
        }
        if (this.getGeoType() == S57GeometryType.NONE) {
            return false;
        }
        return this.geometry.getPolygon().intersects(path2D.getBounds2D());
    }

    public boolean contains(Path2D path2D) {
        if (this.getGeoType() == S57GeometryType.AREA) {
            return this.geometry.getPolygon().contains(path2D.getBounds2D());
        }
        return false;
    }

    public S57GeometryType getGeoType() {
        return this.geometry.getType();
    }

    public Agency getAgency() {
        return this.agency;
    }

    public S57Geometry getGeometry() {
        return this.geometry;
    }

    public Shape getShape() {
        return this.geometry.getShape();
    }

    public double getScamin() {
        return this.getAttribute("SCAMIN").isEmpty() ? S57ObjectPainter.SCAMIN_INFINITE : Double.valueOf(this.getAttribute("SCAMIN").getValue().get(0));
    }

    public LookupTableRecord getLup(MarinerControls marinerControls) {
        return this.lup.get((Object)this.getLupType(marinerControls));
    }

    protected LookupTableType getLupType(MarinerControls marinerControls) {
        switch (this.geometry.getType()) {
            case AREA: {
                return marinerControls.getAreaStyle();
            }
            case LINE: {
                return LookupTableType.LINES;
            }
            case POINT: {
                return marinerControls.getPointStyle();
            }
        }
        System.out.println("N/A");
        throw new IllegalArgumentException("Invalid geometry type");
    }

    public boolean hasConditional(MarinerControls marinerControls) {
        return this.getLup(marinerControls).hasConditional();
    }

    public int getPriority(MarinerControls marinerControls) {
        return this.getLup(marinerControls).getPriority();
    }

    public boolean isOverRadar(MarinerControls marinerControls) {
        return this.getLup(marinerControls).getRadarFlag();
    }

    public DisplayCategory getDisplayCategory(MarinerControls marinerControls) {
        return this.getLup(marinerControls).getCategory();
    }

    public String getViewingGroup(MarinerControls marinerControls) {
        return this.getLup(marinerControls).getGroup();
    }

    public List<Instruction> getInstructions(MarinerControls marinerControls) {
        return this.getLup(marinerControls).getIntructions();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("S57Object [ " + this.acronym + " code" + this.objectClass.getCode() + " type: " + this.objectClass.getType() + "]\n");
        stringBuilder.append("   Info: ");
        for (Map.Entry<String, String> entry : this.idFields.entrySet()) {
            stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "; ");
        }
        stringBuilder.append("\n   Attributes: ");
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            stringBuilder.append(entry.getKey() + "=" + ((S57Attribute)entry.getValue()).getValue() + "; ");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String toStringLup(MarinerControls marinerControls) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("S57Object [ " + this.acronym + " code" + this.objectClass.getCode() + " type: " + this.objectClass.getType() + "]\n");
        stringBuilder.append("   Info: ");
        for (Map.Entry<String, String> entry : this.idFields.entrySet()) {
            stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "; ");
        }
        stringBuilder.append("\n   Attributes: ");
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            stringBuilder.append(entry.getKey() + "=" + ((S57Attribute)entry.getValue()).getValue() + "; ");
        }
        stringBuilder.append("\n" + this.getLupType(marinerControls).toString() + " ");
        stringBuilder.append(this.getLup(marinerControls).toString());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

