/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.s57.entities.S57Attribute;
import pt.lsts.s57.entities.S57Object;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.entities.s52.DisplayCategory;
import pt.lsts.s57.resources.entities.s52.Instruction;
import pt.lsts.s57.s52.SymbologyProcess;

public class S57ObjectPainter {
    public static double SCAMIN_INFINITE = 1499999.0;
    private Resources resources;
    private S57Object object;
    private int priority;
    private boolean overRadar;
    private DisplayCategory displayCategory;
    private String viewingGroup;
    private List<Instruction> instructions = new ArrayList<Instruction>();
    private double scamin;

    public static S57ObjectPainter forge(S57Object s57Object, MarinerControls marinerControls, Resources resources) {
        return new S57ObjectPainter(s57Object, marinerControls, resources);
    }

    private S57ObjectPainter(S57Object s57Object, MarinerControls marinerControls, Resources resources) {
        this.object = s57Object;
        this.priority = s57Object.getPriority(marinerControls);
        this.overRadar = s57Object.isOverRadar(marinerControls);
        this.displayCategory = s57Object.getDisplayCategory(marinerControls);
        this.viewingGroup = s57Object.getViewingGroup(marinerControls);
        this.instructions = s57Object.getInstructions(marinerControls);
        this.resources = resources;
        this.scamin = s57Object.getAttribute("SCAMIN") == null ? SCAMIN_INFINITE : (s57Object.getAttribute("SCAMIN").isEmpty() || s57Object.getAttribute("SCAMIN") == null ? SCAMIN_INFINITE : Double.valueOf(s57Object.getAttribute("SCAMIN").getValue().get(0)));
    }

    public void paint(Graphics graphics, StateRenderer2D stateRenderer2D, MarinerControls marinerControls) {
        SymbologyProcess.process(this.instructions, this, (Graphics2D)graphics, stateRenderer2D, this.resources, marinerControls);
    }

    public boolean hasConditional() {
        for (Instruction instruction : this.instructions) {
            if (!instruction.isConditional()) continue;
            return true;
        }
        return false;
    }

    public S57Attribute getAttribute(String string) {
        return this.object.getAttributes().get(string);
    }

    public S57Object getObject() {
        return this.object;
    }

    public void setObject(S57Object s57Object) {
        this.object = s57Object;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public boolean isOverRadar() {
        return this.overRadar;
    }

    public void setOverRadar(boolean bl) {
        this.overRadar = bl;
    }

    public DisplayCategory getDisplayCategory() {
        return this.displayCategory;
    }

    public void setDisplayCategory(DisplayCategory displayCategory) {
        this.displayCategory = displayCategory;
    }

    public String getViewingGroup() {
        return this.viewingGroup;
    }

    public void setViewingGroup(String string) {
        this.viewingGroup = string;
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<Instruction> list) {
        this.instructions = list;
    }

    public double getScamin() {
        return this.scamin;
    }

    public void setScamin(double d) {
        this.scamin = d;
    }
}

