/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities.geometry;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gdal.ogr.Geometry;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.s57.entities.geometry.S57Geometry;
import pt.lsts.s57.entities.geometry.S57GeometryType;

public class S57Area
implements S57Geometry,
Serializable {
    private static final long serialVersionUID = 7634760723075256511L;
    private final S57GeometryType type = S57GeometryType.AREA;
    private final LocationType startLocation = new LocationType();
    private final List<List<Point2D.Double>> list = new ArrayList<List<Point2D.Double>>();
    private final Shape shape;
    private final LocationType center;
    private final Path2D path = new Path2D.Double(0);

    public static S57Area forge(Geometry geometry) {
        return new S57Area(geometry);
    }

    private S57Area(Geometry geometry) {
        this.startLocation.setLatitudeDegs(geometry.GetGeometryRef(0).GetY(0));
        this.startLocation.setLongitudeDegs(geometry.GetGeometryRef(0).GetX(0));
        Path2D.Double double_ = new Path2D.Double(0);
        LocationType locationType = new LocationType();
        for (int i = 0; i < geometry.GetGeometryCount(); ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double[] dArray = new double[]{0.0, 0.0};
            LocationType locationType2 = new LocationType();
            Point2D.Double double_2 = new Point2D.Double(geometry.GetGeometryRef(i).GetY(0), geometry.GetGeometryRef(i).GetX(0));
            locationType2.setLatitudeDegs(double_2.getX());
            locationType2.setLongitudeDegs(double_2.getY());
            dArray = this.startLocation.getDistanceInPixelTo(locationType2, 22);
            ((Path2D)double_).moveTo(d += dArray[0], d2 += dArray[1]);
            locationType.setLocation(locationType2);
            double d3 = d;
            double d4 = d2;
            ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
            for (int j = 0; j < geometry.GetGeometryRef(i).GetPointCount(); ++j) {
                Point2D.Double double_3 = new Point2D.Double(geometry.GetGeometryRef(i).GetY(j), geometry.GetGeometryRef(i).GetX(j));
                arrayList.add(double_3);
                if (i == 0 && j == 0) {
                    this.path.moveTo(double_3.getX(), double_3.getY());
                } else if (i == 0 && j != 0) {
                    this.path.lineTo(double_3.getX(), double_3.getY());
                }
                LocationType locationType3 = new LocationType();
                locationType3.setLatitudeDegs(double_3.getX());
                locationType3.setLongitudeDegs(double_3.getY());
                dArray = locationType.getDistanceInPixelTo(locationType3, 22);
                ((Path2D)double_).lineTo(d3 += dArray[0], d4 += dArray[1]);
                locationType.setLocation(locationType3);
            }
            this.list.add(arrayList);
        }
        this.path.closePath();
        this.shape = double_;
        this.center = this.calculateCentroid(this.list);
    }

    private LocationType calculateCentroid(List<List<Point2D.Double>> list) throws IllegalArgumentException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double[] dArray = new double[list.size()];
        int n = 0;
        for (List<Point2D.Double> list2 : list) {
            double d = 0.0;
            for (int i = 0; i < list2.size() - 1; ++i) {
                d += list2.get((int)i).y * list2.get((int)(i + 1)).x - list2.get((int)(i + 1)).y * list2.get((int)i).x;
            }
            dArray[n] = d /= 2.0;
            ++n;
        }
        double d = dArray[0];
        if (dArray.length > 1) {
            for (int i = 1; i < dArray.length; ++i) {
                d -= dArray[i];
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        List<Point2D.Double> list3 = list.get(0);
        for (int i = 0; i < list3.size() - 1; ++i) {
            double d4 = list3.get((int)i).y * list3.get((int)(i + 1)).x - list3.get((int)(i + 1)).y * list3.get((int)i).x;
            d2 += (list3.get((int)i).y + list3.get((int)(i + 1)).y) * d4;
            d3 += (list3.get((int)i).x + list3.get((int)(i + 1)).x) * d4;
        }
        LocationType locationType = new LocationType();
        locationType.setLongitudeDegs(d2 *= 1.0 / (6.0 * d));
        locationType.setLatitudeDegs(d3 *= 1.0 / (6.0 * d));
        return locationType;
    }

    @Override
    public S57GeometryType getType() {
        return this.type;
    }

    @Override
    public LocationType getLocation() {
        return this.startLocation;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public LocationType getCenter() {
        return this.center;
    }

    @Override
    public double getDepth() {
        return 0.0;
    }

    @Override
    public boolean containsPoint(S57Geometry s57Geometry) {
        if (!this.type.equals((Object)S57GeometryType.AREA) && !s57Geometry.getType().equals((Object)S57GeometryType.POINT)) {
            throw new IllegalArgumentException("method called by a non area geometry or argument not a point!");
        }
        double d = s57Geometry.getLocation().getLatitudeDegs();
        double d2 = s57Geometry.getLocation().getLongitudeDegs();
        return this.path.contains(d2, d);
    }

    @Override
    public Path2D getPolygon() {
        return this.path;
    }

    @Override
    public List<List<Point2D.Double>> getList() {
        return this.list;
    }
}

