/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities.geometry;

import org.gdal.ogr.Geometry;
import pt.lsts.s57.entities.geometry.S57Area;
import pt.lsts.s57.entities.geometry.S57Geometry;
import pt.lsts.s57.entities.geometry.S57Line;
import pt.lsts.s57.entities.geometry.S57None;
import pt.lsts.s57.entities.geometry.S57Point;
import pt.lsts.s57.entities.geometry.S57Point25d;

public class S57GeometryFactory {
    public static S57Geometry factory(Geometry geometry) {
        int n;
        try {
            n = geometry.GetGeometryType();
        }
        catch (NullPointerException nullPointerException) {
            return S57None.forge();
        }
        switch (n) {
            case 1: {
                return S57Point.forge(geometry);
            }
            case 2: {
                return S57Line.forge(geometry);
            }
            case 3: {
                return S57Area.forge(geometry);
            }
            case -2147483647: {
                return S57Point25d.forge(geometry);
            }
        }
        System.out.println("Invalid geometry type " + n);
        throw new IllegalArgumentException("Invalid geometry type");
    }
}

