/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.entities.geometry;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gdal.ogr.Geometry;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.s57.entities.geometry.S57Geometry;
import pt.lsts.s57.entities.geometry.S57GeometryType;

public class S57Line
implements S57Geometry,
Serializable {
    private static final long serialVersionUID = 6787863321834605250L;
    private final S57GeometryType type = S57GeometryType.LINE;
    private final LocationType loc = new LocationType();
    private final Shape shape;
    private final List<LocationType> points = new ArrayList<LocationType>();
    private final Path2D path = new Path2D.Double(0);

    public static S57Line forge(Geometry geometry) {
        return new S57Line(geometry);
    }

    private S57Line(Geometry geometry) {
        double d = geometry.GetY(0);
        double d2 = geometry.GetX(0);
        int n = geometry.GetPointCount();
        this.loc.setLatitudeDegs(d);
        this.loc.setLongitudeDegs(d2);
        this.points.add(this.loc);
        this.path.moveTo(d, d2);
        GeneralPath generalPath = new GeneralPath(1, n + 2);
        generalPath.moveTo(0.0, 0.0);
        double d3 = 0.0;
        double d4 = 0.0;
        LocationType locationType = new LocationType();
        locationType.setLocation(this.loc);
        LocationType locationType2 = new LocationType();
        for (int i = 1; i < n; ++i) {
            d = geometry.GetY(i);
            d2 = geometry.GetX(i);
            locationType2.setLongitudeDegs(d2);
            locationType2.setLatitudeDegs(d);
            this.points.add(locationType2);
            double[] dArray = locationType.getDistanceInPixelTo(locationType2, 22);
            generalPath.lineTo(d3 += dArray[0], d4 += dArray[1]);
            this.path.lineTo(d, d2);
            locationType.setLocation(locationType2);
        }
        this.shape = generalPath;
    }

    @Override
    public S57GeometryType getType() {
        return this.type;
    }

    @Override
    public LocationType getLocation() {
        return this.loc;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public LocationType getCenter() {
        return this.loc;
    }

    @Override
    public double getDepth() {
        return 0.0;
    }

    @Override
    public boolean containsPoint(S57Geometry s57Geometry) {
        return false;
    }

    @Override
    public List<List<Point2D.Double>> getList() {
        return null;
    }

    @Override
    public Path2D getPolygon() {
        return this.path;
    }
}

