/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.mc;

import pt.lsts.s57.resources.entities.s52.ColorScheme;
import pt.lsts.s57.resources.entities.s52.DisplayCategory;
import pt.lsts.s57.resources.entities.s52.LookupTableType;

public class MarinerControls
implements Cloneable {
    private LookupTableType pointStyle = LookupTableType.SIMPLIFIED;
    private LookupTableType areaStyle = LookupTableType.PLAIN_BOUNDARIES;
    private ColorScheme colorScheme = ColorScheme.DAY_BRIGHT;
    private DisplayCategory displayCategory = DisplayCategory.OTHER;
    private double shallowContour = 3.0;
    private double deepContour = 10.0;
    private double safetyContour = 8.0;
    private boolean twoShades = false;
    private boolean shallowPattern = false;
    private boolean showImportantText = false;
    private boolean showOtherText = false;
    private boolean soundings = true;
    private double mapScale;
    private boolean scaleFilter = true;

    public static MarinerControls forge() {
        return new MarinerControls();
    }

    private MarinerControls() {
    }

    public LookupTableType getPointStyle() {
        return this.pointStyle;
    }

    public void setPointStyle(LookupTableType lookupTableType) {
        if (!lookupTableType.equals((Object)LookupTableType.PAPER_CHART) && !lookupTableType.equals((Object)LookupTableType.SIMPLIFIED)) {
            throw new IllegalArgumentException("illegal argument: point can only be PAPER_CHART or SIMPLIFIED");
        }
        this.pointStyle = lookupTableType;
    }

    public DisplayCategory getDisplayCategory() {
        return this.displayCategory;
    }

    public void setDisplayCategory(DisplayCategory displayCategory) {
        this.displayCategory = displayCategory;
    }

    public LookupTableType getAreaStyle() {
        return this.areaStyle;
    }

    public void setAreaStyle(LookupTableType lookupTableType) {
        if (!lookupTableType.equals((Object)LookupTableType.PLAIN_BOUNDARIES) && !lookupTableType.equals((Object)LookupTableType.SYMBOLIZED_BOUNDARIES)) {
            throw new IllegalArgumentException("illegal argument: area can only be PLAIN_BOUNDARIES or SYMBOLIZED_BOUNDARIES");
        }
        this.areaStyle = lookupTableType;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public double getShallowContour() {
        return this.shallowContour;
    }

    public void setShallowContour(double d) {
        this.shallowContour = d;
    }

    public double getDeepContour() {
        return this.deepContour;
    }

    public void setDeepContour(double d) {
        this.deepContour = d;
    }

    public double getSafetyContour() {
        return this.safetyContour;
    }

    public void setSafetyContour(double d) {
        this.safetyContour = d;
    }

    public boolean isTwoShades() {
        return this.twoShades;
    }

    public void setTwoShades(boolean bl) {
        this.twoShades = bl;
    }

    public boolean isShallowPattern() {
        return this.shallowPattern;
    }

    public void setShallowPattern(boolean bl) {
        this.shallowPattern = bl;
    }

    public double getMapScale() {
        return this.mapScale;
    }

    public void setMapScale(double d) {
        this.mapScale = d;
    }

    public boolean isScaleFilter() {
        return this.scaleFilter;
    }

    public void setScaleFilter(boolean bl) {
        this.scaleFilter = bl;
    }

    public boolean isShowImportantText() {
        return this.showImportantText;
    }

    public void setShowImportantText(boolean bl) {
        this.showImportantText = bl;
    }

    public boolean isShowOtherText() {
        return this.showOtherText;
    }

    public void setShowOtherText(boolean bl) {
        this.showOtherText = bl;
    }

    public boolean isSoundings() {
        return this.soundings;
    }

    public void setSoundings(boolean bl) {
        this.soundings = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("This should not occur since we implement Cloneable");
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.areaStyle == null ? 0 : this.areaStyle.hashCode());
        n = 31 * n + (this.colorScheme == null ? 0 : this.colorScheme.hashCode());
        long l = Double.doubleToLongBits(this.deepContour);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.displayCategory == null ? 0 : this.displayCategory.hashCode());
        l = Double.doubleToLongBits(this.mapScale);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.pointStyle == null ? 0 : this.pointStyle.hashCode());
        l = Double.doubleToLongBits(this.safetyContour);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.scaleFilter ? 1231 : 1237);
        l = Double.doubleToLongBits(this.shallowContour);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.shallowPattern ? 1231 : 1237);
        n = 31 * n + (this.showImportantText ? 1231 : 1237);
        n = 31 * n + (this.showOtherText ? 1231 : 1237);
        n = 31 * n + (this.soundings ? 1231 : 1237);
        n = 31 * n + (this.twoShades ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MarinerControls marinerControls = (MarinerControls)object;
        if (this.areaStyle != marinerControls.areaStyle) {
            return false;
        }
        if (this.colorScheme != marinerControls.colorScheme) {
            return false;
        }
        if (Double.doubleToLongBits(this.deepContour) != Double.doubleToLongBits(marinerControls.deepContour)) {
            return false;
        }
        if (this.displayCategory != marinerControls.displayCategory) {
            return false;
        }
        if (Double.doubleToLongBits(this.mapScale) != Double.doubleToLongBits(marinerControls.mapScale)) {
            return false;
        }
        if (this.pointStyle != marinerControls.pointStyle) {
            return false;
        }
        if (Double.doubleToLongBits(this.safetyContour) != Double.doubleToLongBits(marinerControls.safetyContour)) {
            return false;
        }
        if (this.scaleFilter != marinerControls.scaleFilter) {
            return false;
        }
        if (Double.doubleToLongBits(this.shallowContour) != Double.doubleToLongBits(marinerControls.shallowContour)) {
            return false;
        }
        if (this.shallowPattern != marinerControls.shallowPattern) {
            return false;
        }
        if (this.showImportantText != marinerControls.showImportantText) {
            return false;
        }
        if (this.showOtherText != marinerControls.showOtherText) {
            return false;
        }
        if (this.soundings != marinerControls.soundings) {
            return false;
        }
        return this.twoShades == marinerControls.twoShades;
    }
}

