/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.painters;

import com.kitfox.svg.SVGException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.s57.S57;
import pt.lsts.s57.S57Factory;
import pt.lsts.s57.entities.S57Map;
import pt.lsts.s57.entities.S57Object;
import pt.lsts.s57.entities.S57ObjectPainter;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.painters.S57Painter;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.entities.s52.Instruction;
import pt.lsts.s57.resources.entities.s52.InstructionType;
import pt.lsts.s57.s52.ConditionalSymbologyProcess;

public class NeptusS57Painter
implements Renderer2DPainter,
S57Painter {
    public static int offScreenBufferPixel = 400;
    private final Resources resources;
    private Map<String, S57Map> maps;
    private S57 s57;
    private Map<String, List<S57ObjectPainter>> mapsPainters = new HashMap<String, List<S57ObjectPainter>>();
    private List<String> mapOrder = new ArrayList<String>();
    private MarinerControls mc;
    private MarinerControls mcLastState;
    private Map<String, Object> rendererLastState = new HashMap<String, Object>();
    private BufferedImage cache;
    private boolean cacheValid;
    private Graphics2D graphics;
    private int numObjs = 0;
    private Comparator<S57ObjectPainter> painterComparator;
    private Comparator<String> mapComparator;
    private Comparator<S57Map> mapObjectComparator;
    private List<S57Map> currentMaps = Collections.synchronizedList(new ArrayList());

    public static NeptusS57Painter forge(S57 s57, MarinerControls marinerControls) {
        return new NeptusS57Painter(s57, marinerControls);
    }

    private NeptusS57Painter(S57 s57, MarinerControls marinerControls) {
        this.resources = s57.getResources();
        this.maps = s57.getMaps();
        this.s57 = s57;
        this.mc = marinerControls;
        this.mcLastState = null;
        this.cacheValid = false;
        this.painterComparator = new Comparator<S57ObjectPainter>(){

            @Override
            public int compare(S57ObjectPainter s57ObjectPainter, S57ObjectPainter s57ObjectPainter2) {
                if (s57ObjectPainter.getPriority() < s57ObjectPainter2.getPriority()) {
                    return -1;
                }
                if (s57ObjectPainter.getPriority() > s57ObjectPainter2.getPriority()) {
                    return 1;
                }
                return 0;
            }
        };
        this.mapComparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n;
                int n2 = string.charAt(2);
                if (n2 < (n = Integer.valueOf(string2.charAt(2)).intValue())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
        };
        this.mapObjectComparator = new Comparator<S57Map>(){

            @Override
            public int compare(S57Map s57Map, S57Map s57Map2) {
                int n;
                int n2 = s57Map.getMapInfo().getPurpose();
                if (n2 > (n = s57Map2.getMapInfo().getPurpose())) {
                    return -1;
                }
                if (n2 < n) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public void paint(Graphics2D graphics2D, StateRenderer2D stateRenderer2D) {
        long l = System.nanoTime();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHints(renderingHints);
        Map<String, Object> map = this.saveRendererState(stateRenderer2D);
        graphics2D.translate(1, -1);
        if (!this.hasRendererChanged(map) && this.mc.equals(this.mcLastState) && this.cacheValid) {
            LocationType locationType = (LocationType)this.rendererLastState.get("center");
            double[] dArray = stateRenderer2D.getCenter().getDistanceInPixelTo(locationType, stateRenderer2D.getLevelOfDetail());
            dArray = AngleCalc.rotate((double)stateRenderer2D.getRotation(), (double)dArray[0], (double)dArray[1], (boolean)true);
            graphics2D.drawImage(this.cache, null, (int)dArray[0] - offScreenBufferPixel, (int)dArray[1] - offScreenBufferPixel);
            return;
        }
        this.cache = new BufferedImage(stateRenderer2D.getWidth() + offScreenBufferPixel * 2, stateRenderer2D.getHeight() + offScreenBufferPixel * 2, 2);
        this.graphics = this.cache.createGraphics();
        this.graphics.translate(offScreenBufferPixel, offScreenBufferPixel);
        this.graphics.setRenderingHints(graphics2D.getRenderingHints());
        double d = 0.0;
        if (!(this.cacheValid && (this.maps.size() <= 0 || this.mc.equals(this.mcLastState) && this.rendererLastState.get("scale").equals(map.get("scale"))))) {
            long l2 = System.nanoTime();
            this.mapsPainters.clear();
            this.mapOrder.clear();
            this.process(stateRenderer2D);
            d = (double)(System.nanoTime() - l2) / 1.0E9;
        }
        if (stateRenderer2D.getLevelOfDetail() < 11) {
            this.paintSVG(this.graphics, stateRenderer2D);
        }
        for (String string : this.mapOrder) {
            for (S57ObjectPainter object : this.mapsPainters.get(string)) {
                object.paint(this.graphics, stateRenderer2D, this.mc);
            }
        }
        graphics2D.drawImage(this.cache, null, -offScreenBufferPixel, -offScreenBufferPixel);
        this.rendererLastState = map;
        this.mcLastState = (MarinerControls)this.mc.clone();
        this.cacheValid = true;
        if (S57Factory.DEBUG) {
            int n = 0;
            int n2 = 0;
            for (Map.Entry entry : this.s57.getMaps().entrySet()) {
                S57Map s57Map = (S57Map)entry.getValue();
                if (s57Map.isLoaded()) {
                    ++n;
                }
                if (!s57Map.isLoading()) continue;
                ++n2;
            }
            System.out.println("loadded: " + n + " loading: " + n2);
            System.out.println("Painted in " + (double)(System.nanoTime() - l) / 1.0E9 + "s process took " + d + " with " + this.numObjs + " objs ( LOD " + stateRenderer2D.getLevelOfDetail() + " ) current maps " + this.getCurrentMaps().size());
        }
    }

    private void paintSVG(Graphics2D graphics2D, StateRenderer2D stateRenderer2D) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        LocationType locationType = new LocationType(90.0, -180.0);
        Point2D point2D = stateRenderer2D.getScreenPosition(locationType);
        double d = Math.pow(2.0, stateRenderer2D.getLevelOfDetail());
        graphics2D2.translate(point2D.getX(), point2D.getY() - 15.0 * d);
        graphics2D2.scale(d, d);
        try {
            this.resources.renderSVG(graphics2D2);
        }
        catch (SVGException sVGException) {
            System.out.println("exception rendering svg!");
        }
        graphics2D2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(StateRenderer2D stateRenderer2D) {
        Path2D path2D = this.getRendererBoundsGPS(stateRenderer2D, false);
        Path2D path2D2 = this.getRendererBoundsGPS(stateRenderer2D, true);
        ArrayList<S57Map> arrayList = new ArrayList<S57Map>();
        ArrayList<S57Map> arrayList2 = new ArrayList<S57Map>();
        this.numObjs = 0;
        Map<String, S57Map> map = this.maps;
        synchronized (map) {
            for (Map.Entry<String, S57Map> entry : this.maps.entrySet()) {
                S57Map s57Map = entry.getValue();
                String string = entry.getKey();
                List<S57Object> list = s57Map.getCoverage();
                if (!this.intersectCovsWithRenderer(list, path2D2)) {
                    if (!s57Map.isLoaded()) continue;
                    arrayList2.add(s57Map);
                    continue;
                }
                ArrayList<S57ObjectPainter> arrayList3 = new ArrayList<S57ObjectPainter>();
                int n = s57Map.getMapInfo().getPurpose() * 2 + 3;
                arrayList3.addAll(this.createCoveragePainter(list));
                boolean bl = this.getScale(s57Map.getMapInfo().getPurpose(), stateRenderer2D.getMapScale());
                if (bl) {
                    arrayList.add(s57Map);
                }
                if (s57Map.isLoaded() && stateRenderer2D.getLevelOfDetail() < n) {
                    arrayList2.add(s57Map);
                } else if (s57Map.isLoaded()) {
                    List<S57Object> list2 = s57Map.getObjects();
                    for (S57Object s57Object : list2) {
                        if (s57Object.getLup(this.mc).isEmpty() || this.mc.isScaleFilter() && s57Object.getScamin() < stateRenderer2D.getMapScale() && !s57Object.getIdField("GRUP").equals("1") || !s57Object.intersects(path2D) || !this.mc.isSoundings() && s57Object.getAcronym().equals("SOUNDG")) continue;
                        S57ObjectPainter s57ObjectPainter = S57ObjectPainter.forge(s57Object, this.mc, this.resources);
                        if (s57Object.hasConditional(this.mc)) {
                            ConditionalSymbologyProcess.process(s57ObjectPainter, this.resources, this.mc, entry.getValue(), arrayList3);
                        }
                        if (this.mc.getDisplayCategory().getCode() < s57ObjectPainter.getDisplayCategory().getCode()) continue;
                        arrayList3.add(s57ObjectPainter);
                        ++this.numObjs;
                    }
                }
                if (arrayList3.isEmpty()) continue;
                this.mapsPainters.put(string, arrayList3);
                this.mapOrder.add(string);
                Collections.sort(arrayList3, this.painterComparator);
            }
        }
        Collections.sort(arrayList, this.mapObjectComparator);
        for (S57Map s57Map : arrayList) {
            if (!this.mapContainsRenderer(s57Map.getCoverage(), path2D2)) continue;
            S57Map s57Map2 = s57Map;
            arrayList.remove(s57Map);
            arrayList2.addAll(arrayList);
            arrayList.clear();
            arrayList.add(s57Map2);
            break;
        }
        this.currentMaps.clear();
        this.currentMaps.addAll(arrayList);
        this.s57.loadMapObjects(arrayList);
        this.s57.unloadMapObjects(arrayList2);
        Collections.sort(this.mapOrder, this.mapComparator);
    }

    private Map<String, Object> saveRendererState(StateRenderer2D stateRenderer2D) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zoom", stateRenderer2D.getLevelOfDetail());
        hashMap.put("center", stateRenderer2D.getCenter().getNewAbsoluteLatLonDepth());
        hashMap.put("width", stateRenderer2D.getWidth());
        hashMap.put("height", stateRenderer2D.getHeight());
        hashMap.put("scale", stateRenderer2D.getMapScale());
        hashMap.put("rotation", stateRenderer2D.getRotation());
        return hashMap;
    }

    private boolean hasRendererChanged(Map<String, Object> map) {
        LocationType locationType;
        if (!map.get("zoom").equals(this.rendererLastState.get("zoom"))) {
            return true;
        }
        LocationType locationType2 = ((LocationType)map.get("center")).getNewAbsoluteLatLonDepth();
        double[] dArray = locationType2.getDistanceInPixelTo(locationType = (LocationType)this.rendererLastState.get("center") == null ? new LocationType(0.0, 0.0) : (LocationType)this.rendererLastState.get("center"), ((Integer)map.get("zoom")).intValue());
        if (Math.abs(dArray[0]) > (double)offScreenBufferPixel || Math.abs(dArray[1]) > (double)offScreenBufferPixel) {
            return true;
        }
        if (!map.get("width").equals(this.rendererLastState.get("width"))) {
            return true;
        }
        if (!map.get("height").equals(this.rendererLastState.get("height"))) {
            return true;
        }
        return !map.get("rotation").equals(this.rendererLastState.get("rotation"));
    }

    private boolean getScale(int n, double d) {
        switch (n) {
            case 1: {
                return d < 1499999.0;
            }
            case 2: {
                return d < 1499999.0;
            }
            case 3: {
                return d < 349999.0;
            }
            case 4: {
                return d < 89999.0;
            }
            case 5: {
                return d < 21999.0;
            }
            case 6: {
                return d < 4000.0;
            }
        }
        return false;
    }

    @Override
    public boolean isCacheValid() {
        return this.cacheValid;
    }

    @Override
    public void setCacheValid(boolean bl) {
        this.cacheValid = bl;
    }

    @Override
    public List<S57Map> getCurrentMaps() {
        return this.currentMaps;
    }

    private boolean intersectCovsWithRenderer(List<S57Object> list, Path2D path2D) {
        for (S57Object s57Object : list) {
            if (!s57Object.intersects(path2D)) continue;
            return true;
        }
        return false;
    }

    private boolean mapContainsRenderer(List<S57Object> list, Path2D path2D) {
        for (S57Object s57Object : list) {
            if (!s57Object.contains(path2D)) continue;
            return true;
        }
        return false;
    }

    private List<S57ObjectPainter> createCoveragePainter(List<S57Object> list) {
        ArrayList<S57ObjectPainter> arrayList = new ArrayList<S57ObjectPainter>();
        for (S57Object s57Object : list) {
            S57ObjectPainter s57ObjectPainter = S57ObjectPainter.forge(s57Object, this.mc, this.resources);
            Instruction instruction = Instruction.forge(InstructionType.LS, "SOLD,5,LITGN");
            ArrayList<Instruction> arrayList2 = new ArrayList<Instruction>();
            arrayList2.add(instruction);
            s57ObjectPainter.setInstructions(arrayList2);
            s57ObjectPainter.setPriority(9);
            arrayList.add(s57ObjectPainter);
        }
        return arrayList;
    }

    private Path2D getRendererBoundsGPS(StateRenderer2D stateRenderer2D, boolean bl) {
        int n = offScreenBufferPixel;
        if (bl) {
            n = (int)(((double)stateRenderer2D.getWidth() * 0.2 + (double)stateRenderer2D.getHeight() * 0.2) / 2.0);
        }
        LocationType locationType = stateRenderer2D.getRealWorldLocation((Point2D)new Point2D.Double(0 - n, 0 - n));
        LocationType locationType2 = stateRenderer2D.getRealWorldLocation((Point2D)new Point2D.Double(stateRenderer2D.getWidth() - 1 + n, 0 - n));
        LocationType locationType3 = stateRenderer2D.getRealWorldLocation((Point2D)new Point2D.Double(stateRenderer2D.getWidth() - 1 + n, stateRenderer2D.getHeight() - 1 + n));
        LocationType locationType4 = stateRenderer2D.getRealWorldLocation((Point2D)new Point2D.Double(0 - n, stateRenderer2D.getHeight() - 1 + n));
        Path2D.Double double_ = new Path2D.Double(0);
        ((Path2D)double_).moveTo(locationType.getLatitudeDegs(), locationType.getLongitudeDegs());
        ((Path2D)double_).lineTo(locationType2.getLatitudeDegs(), locationType2.getLongitudeDegs());
        ((Path2D)double_).lineTo(locationType3.getLatitudeDegs(), locationType3.getLongitudeDegs());
        ((Path2D)double_).lineTo(locationType4.getLatitudeDegs(), locationType4.getLongitudeDegs());
        double_.closePath();
        return double_;
    }
}

