/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import pt.lsts.s57.entities.S57Attribute;
import pt.lsts.s57.entities.geometry.S57GeometryType;
import pt.lsts.s57.resources.CSVType;
import pt.lsts.s57.resources.entities.Agencies;
import pt.lsts.s57.resources.entities.Agency;
import pt.lsts.s57.resources.entities.Attribute;
import pt.lsts.s57.resources.entities.Attributes;
import pt.lsts.s57.resources.entities.Input;
import pt.lsts.s57.resources.entities.Inputs;
import pt.lsts.s57.resources.entities.ObjectClass;
import pt.lsts.s57.resources.entities.ObjectClasses;
import pt.lsts.s57.resources.entities.s52.ColorScheme;
import pt.lsts.s57.resources.entities.s52.ColorTable;
import pt.lsts.s57.resources.entities.s52.LookupTable;
import pt.lsts.s57.resources.entities.s52.LookupTableRecord;
import pt.lsts.s57.resources.entities.s52.LookupTableType;
import pt.lsts.s57.resources.entities.s52.symbol.S52Pattern;
import pt.lsts.s57.resources.entities.s52.symbol.S52Symbol;
import pt.lsts.s57.resources.entities.s52.symbol.Symbols;

public class Resources
implements Serializable {
    private static final long serialVersionUID = 6617883540259537424L;
    private final Map<CSVType, ObjectClasses> objectClassesMap;
    private final Map<CSVType, Attributes> attributesMap;
    private final Agencies agencies;
    private final Inputs inputs;
    private final Map<LookupTableType, LookupTable> lupMap;
    private final ColorTable colorTable;
    private final Symbols symbols;
    private transient SVGDiagram diagram;
    private transient Configuration config;

    public static Resources forge(Configuration configuration, Map<CSVType, ObjectClasses> map, Map<CSVType, Attributes> map2, Agencies agencies, Inputs inputs, Map<LookupTableType, LookupTable> map3, ColorTable colorTable, Symbols symbols) {
        return new Resources(configuration, map, map2, agencies, inputs, map3, colorTable, symbols);
    }

    private Resources(Configuration configuration, Map<CSVType, ObjectClasses> map, Map<CSVType, Attributes> map2, Agencies agencies, Inputs inputs, Map<LookupTableType, LookupTable> map3, ColorTable colorTable, Symbols symbols) {
        this.config = configuration;
        this.objectClassesMap = map;
        this.attributesMap = map2;
        this.agencies = agencies;
        this.inputs = inputs;
        this.lupMap = map3;
        this.colorTable = colorTable;
        this.symbols = symbols;
        this.diagram = null;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void renderSVG(Graphics2D graphics2D) throws SVGException {
        if (this.diagram == null) {
            this.lazyLoadSVG();
        }
        this.diagram.render(graphics2D);
    }

    public void lazyLoadSVG() {
        File file = new File(this.config.getString("s57.svg"));
        SVGUniverse sVGUniverse = new SVGUniverse();
        try {
            this.diagram = sVGUniverse.getDiagram(sVGUniverse.loadSVG(file.toURL()));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("error loading svg!");
        }
    }

    public Attribute getAttribute(String string) {
        return this.attributesMap.get((Object)CSVType.STANDARD).get(string);
    }

    public Attribute getAttribute(String string, CSVType cSVType) {
        return this.attributesMap.get((Object)cSVType).get(string);
    }

    public ObjectClass getObjectClass(String string) {
        return this.objectClassesMap.get((Object)CSVType.STANDARD).get(string);
    }

    public ObjectClass getObjectClass(String string, CSVType cSVType) {
        return this.objectClassesMap.get((Object)cSVType).get(string);
    }

    public Agency getAgency(String string) {
        return this.agencies.get(string);
    }

    public Input getInput(int n, int n2) {
        return this.inputs.get(n, n2);
    }

    public LookupTable getLookupTable(LookupTableType lookupTableType) {
        return this.lupMap.get((Object)lookupTableType);
    }

    public Map<LookupTableType, LookupTableRecord> getLupRecord(S57GeometryType s57GeometryType, String string, Map<String, S57Attribute> map) {
        HashMap<LookupTableType, LookupTableRecord> hashMap = new HashMap<LookupTableType, LookupTableRecord>();
        switch (s57GeometryType) {
            case LINE: {
                hashMap.put(LookupTableType.LINES, this.getLookupTable(LookupTableType.LINES).get(string, map));
                break;
            }
            case AREA: {
                hashMap.put(LookupTableType.PLAIN_BOUNDARIES, this.getLookupTable(LookupTableType.PLAIN_BOUNDARIES).get(string, map));
                hashMap.put(LookupTableType.SYMBOLIZED_BOUNDARIES, this.getLookupTable(LookupTableType.SYMBOLIZED_BOUNDARIES).get(string, map));
                break;
            }
            case POINT: {
                hashMap.put(LookupTableType.PAPER_CHART, this.getLookupTable(LookupTableType.PAPER_CHART).get(string, map));
                hashMap.put(LookupTableType.SIMPLIFIED, this.getLookupTable(LookupTableType.SIMPLIFIED).get(string, map));
                break;
            }
            case NONE: {
                break;
            }
        }
        return hashMap;
    }

    public Color getColor(String string, ColorScheme colorScheme) {
        return this.colorTable.get(string).get(colorScheme);
    }

    public S52Symbol getSymbol(String string) {
        return this.symbols.getSymbol(string);
    }

    public S52Pattern getPattern(String string) {
        return this.symbols.getPattern(string);
    }

    public S52Symbol getLine(String string) {
        return this.symbols.getLine(string);
    }

    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }
}

